package com.payu.ui.model.widgets

import android.app.Dialog
import android.content.Context
import android.content.DialogInterface
import android.content.res.Resources
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import com.google.android.material.bottomsheet.BottomSheetDialog
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import com.payu.ui.R
import com.payu.ui.model.managers.BottomSheetManager
import com.payu.ui.model.utils.SdkUiConstants

class RoundedCornerBottomSheet :
    BottomSheetDialogFragment() {

    override fun getTheme(): Int = R.style.PayU_BottomSheetDialogTheme
    override fun onCreateDialog(savedInstanceState: Bundle?): Dialog =
        BottomSheetDialog(requireContext(), theme)

    var bottomSheetListener: OnBottomSheetListener? = null
    var layoutId: Int? = null
    private var hasFixedSize: Boolean = false


    fun setListener(bottomSheetListener: OnBottomSheetListener) {
        this.bottomSheetListener = bottomSheetListener
    }

    override fun onAttach(context: Context) {
        super.onAttach(context)
        if (bottomSheetListener == null && context is OnBottomSheetListener) {
            this.bottomSheetListener = context
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        bottomSheetListener?.bottomSheetDetach()
        bottomSheetListener = null
        layoutId = null
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        bottomSheetListener?.bottomSheetAttach()
        arguments?.let {
            layoutId = it.getInt(SdkUiConstants.LAYOUT_ID)
            hasFixedSize = it.getBoolean(SdkUiConstants.CP_HAS_FIXED_SIZE)
        }
    }

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        return if (hasFixedSize) {
            val view = inflater.inflate(layoutId!!, container, false)
            val container = view?.findViewById<FrameLayout>(R.id.offersContainer)
            val layoutParams = container?.layoutParams
            val height = (Resources.getSystem().displayMetrics.heightPixels * 75) / 100
            layoutParams?.height = height
            container?.layoutParams = layoutParams
            view
        } else {
            return inflater.inflate(layoutId!!, container, false)
        }
    }


    companion object {
        /**
         * Use this factory method to create a new instance of
         * this fragment using the provided parameters.
         * @return A new instance of fragment RoundedCornerBottomSheet.
         */
        // TODO: Rename and change types and number of parameters
        @JvmStatic
        fun newInstance(
            layoutId: Int,
            hasFixedSize: Boolean = false
        ) =
            RoundedCornerBottomSheet().apply {
                arguments = Bundle().apply {
                    putInt(SdkUiConstants.LAYOUT_ID, layoutId)
                    putBoolean(SdkUiConstants.CP_HAS_FIXED_SIZE, hasFixedSize)
                }
            }

        /**
         * Use this factory method to create a new instance of
         * this fragment using the provided parameters.
         * @return A new instance of fragment RoundedCornerBottomSheet.
         */
        // TODO: Rename and change types and number of parameters
        @JvmStatic
        fun newInstance(layoutId: Int, manager: BottomSheetManager) =
            RoundedCornerBottomSheet().apply {
                arguments = Bundle().apply {
                    putInt(SdkUiConstants.LAYOUT_ID, layoutId)
                }
                bottomSheetListener = manager
            }
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        bottomSheetListener?.getInflatedView(view, this)
    }

    interface OnBottomSheetListener {
        fun getInflatedView(view: View, roundedCornerBottomSheet: RoundedCornerBottomSheet)
        fun handleBottomSheetClose()
        fun bottomSheetDetach()
        fun bottomSheetAttach()
    }

    override fun onCancel(dialog: DialogInterface) {
        super.onCancel(dialog)
        bottomSheetListener?.handleBottomSheetClose()
    }


}