package com.payu.ui.model.utils

import android.content.Context
import android.graphics.Color
import androidx.core.content.ContextCompat
import androidx.core.graphics.ColorUtils
import java.util.*

object TextColorSelector {

    fun getTextColorFromBackgroundColor(bgColor: Int, context: Context) : String{

        val color: Int = ContextCompat.getColor(context, bgColor)
        val hexColor = SdkUiConstants.HASH + Integer.toHexString(color).uppercase(Locale.getDefault())
        val backgroundColor: Int = Color.parseColor(hexColor) // Replace with your background color
        val luminance: Double = ColorUtils.calculateLuminance(backgroundColor)

        val textColor = if (luminance > 0.5) {
            // Light background, use dark text color
            SdkUiConstants.PAYU_BLACK_HEX_CODE
        } else {
            // Dark background, use light text color
            SdkUiConstants.PAYU_WHITE_HEX_CODE
        }

        return textColor
    }

    fun getTextColorFromBackgroundColorString(hexColor: String, context: Context) : String{

        val backgroundColor: Int = Color.parseColor(hexColor) // Replace with your background color
        val luminance: Double = ColorUtils.calculateLuminance(backgroundColor)

        val textColor = if (luminance > 0.5) {
            // Light background, use dark text color
            SdkUiConstants.PAYU_BLACK_HEX_CODE
        } else {
            // Dark background, use light text color
            SdkUiConstants.PAYU_WHITE_HEX_CODE
        }

        return textColor
    }

}