package com.payu.ui.model.utils

import android.app.Activity
import android.app.Dialog
import android.content.Context
import android.graphics.drawable.Drawable
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import androidx.annotation.DrawableRes
import androidx.appcompat.widget.AppCompatImageView
import androidx.appcompat.widget.AppCompatTextView
import androidx.vectordrawable.graphics.drawable.Animatable2Compat
import androidx.vectordrawable.graphics.drawable.AnimatedVectorDrawableCompat
import com.payu.ui.R;
import com.payu.ui.model.listeners.onProgressDialogBackPressListener
import com.payu.ui.model.utils.ViewUtils.applyLoopingAnimatedVectorDrawable
import com.payu.ui.model.utils.ViewUtils.setPayUDialogSettings
import java.util.*


/**
 * Created by himanshu.gupta on 28/12/17.
 */
class PayUProgressDialog(
    context: Context?,
    view: View?,
    isLaunchLoader: Boolean = false,
    private val onProgressDialogBackPressListener: onProgressDialogBackPressListener? = null
) : Dialog(
    context!!, R.style.Theme_AppCompat_Light_NoActionBar
) {
    private var tvMessage: AppCompatTextView? = null
    private val mActivity: Activity?
    private var layout: View? = null
    var ivProgress: AppCompatImageView? = null

    /**
     * Displaying Payuloader.
     *
     * @param context base activity context
     * @param view    Custom Progress Dialog Layout if any
     */
    init {
        mActivity = context as Activity?
        val mInflater = LayoutInflater.from(context)
        if (null != view) {
            layout = view
            if (view.parent != null) {
                val parent = view.parent as ViewGroup
                parent.removeView(view)
            }
            setContentView(layout!!)
        } else {
            //Default PayU progress Dialog
            layout = mInflater.inflate(R.layout.payu_loader_layout, null, false)
            setContentView(layout!!)
            ivProgress = layout?.findViewById<View>(R.id.payu_loader) as? AppCompatImageView
            if (mActivity != null) {
                setPayUDialogSettings(ivProgress, mActivity)
            }
            if(isLaunchLoader) {
                (layout?.findViewById<View>(R.id.tvMessage) as? AppCompatTextView)?.visibility = View.GONE
                (layout?.findViewById<View>(R.id.tvMessageBottom) as? AppCompatTextView)?.text =
                    context?.getString(R.string.payu_loader_processing)
                (layout?.findViewById<View>(R.id.tvMessageFooter) as? AppCompatTextView)?.visibility = View.GONE
            }
        }
        setCancelable(true)
        setCanceledOnTouchOutside(false)
    }



    fun setText(text: String?) {
        tvMessage?.text = text
    }



    override fun onBackPressed() {
        onProgressDialogBackPressListener?.onBackPressListener()
    }

}



