package com.payu.ui.model.models

import androidx.annotation.DrawableRes
import androidx.fragment.app.FragmentManager
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentState
import com.payu.base.models.PaymentType
import com.payu.ui.model.listeners.OfferApplyListener
import com.payu.ui.model.listeners.OnBankAdapterListener

sealed class AdapterViewSections(open val preferredPosition: Int) {

    data class Summary(
        val title: String,
        override val preferredPosition: Int = ListOrder.Summary.ordinal
    ) : AdapterViewSections(preferredPosition = preferredPosition)

    data class Offer(override val preferredPosition: Int = ListOrder.Offer.ordinal) :
        AdapterViewSections(preferredPosition)

    data class TopBanks(
        val paymentType: PaymentType,
        var topBankList: ArrayList<PaymentOption>,
        var paymentState: PaymentState? = null,
        var childFragmentManager: FragmentManager,
        val offerApplyListener: OfferApplyListener,
        val onBankAdapterListener: OnBankAdapterListener?,
        override val preferredPosition: Int = ListOrder.TopBanks.ordinal
    ) : AdapterViewSections(preferredPosition)

    data class AddNewCard(
        val title: String?,
        val detailsText: String?,
        val showHeader: Boolean,
        val showRightIcon: Boolean,
        @DrawableRes val rightIcon: Int? = null,
        @DrawableRes val addIconRes: Int?,
        val showAddIcon: Boolean,
        val showDetails: Boolean,
        val showOffer: Boolean,
        override val preferredPosition: Int = ListOrder.AddMoreSection.ordinal
    ) : AdapterViewSections(preferredPosition)

    data class SearchSection(override val preferredPosition: Int = ListOrder.Search.ordinal) :
        AdapterViewSections(preferredPosition = preferredPosition)

    data class ErrorSection(
        var errorText: String?,
        override val preferredPosition: Int = ListOrder.ListErrorSection.ordinal
    ) :
        AdapterViewSections(preferredPosition = preferredPosition)

    data class TpvAccountView(
        var tilesDataList: ArrayList<TilesData>,
        override val preferredPosition: Int = ListOrder.TPVAccounts.ordinal
    ) : AdapterViewSections(preferredPosition = preferredPosition)

    // For One Time Mandate Message View
    data class OTMMessageView(
        val title: String,
        val subTitle: String,
        override val preferredPosition: Int = ListOrder.OTMMessage.ordinal
    ) : AdapterViewSections(preferredPosition = preferredPosition)


    data class LoginSection(
        var showTimer: Boolean = false,
        var timerString: String? = null,
        var phoneNumber: String? = null,
        var showInUi: Boolean = false,
        override val preferredPosition: Int = ListOrder.LoginSection.ordinal
    ) : AdapterViewSections(preferredPosition = preferredPosition)

}


