package com.payu.ui.model.managers

import com.payu.base.models.FeeCombinations
import com.payu.base.models.FetchOfferDetails
import com.payu.base.models.InternalConfig
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentType
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.utils.SdkUiConstants
import java.util.Locale

object CFManager {
    private var cfMap: HashMap<String, FeeCombinations?> = HashMap()
    private var cfMapForSI: HashMap<String, FeeCombinations?> = HashMap()

    private var offerCFMap: HashMap<String, Pair<String, FeeCombinations?>> = HashMap()
    private var offerCFMapForSI: HashMap<String, Pair<String, FeeCombinations?>> = HashMap()

    fun invalidateCFData() {
        cfMap.clear()
        cfMapForSI.clear()
        clearOfferCFData()
    }

    fun clearOfferCFData(){
        offerCFMap.clear()
        offerCFMapForSI.clear()
    }

    fun addCFData(
        ibiboCode: String,
        feeCombinations: FeeCombinations?,
        isSITxn: Boolean = false,
    ) {

        if (InternalConfig.userSelectedOfferInfo == null) {
            if (isSITxn.not())
                cfMap[ibiboCode] = feeCombinations
            else
                cfMapForSI[ibiboCode] = feeCombinations
        } else {
            if (isSITxn.not())
                offerCFMap[ibiboCode] = Pair(InternalConfig.userSelectedOfferInfo?.offerKey ?: "", feeCombinations)
            else
                offerCFMapForSI[ibiboCode] = Pair(InternalConfig.userSelectedOfferInfo?.offerKey ?: "", feeCombinations)
        }
    }

    fun getCFData(
        ibiboCode: String,
        isSITxn: Boolean = SdkUiInitializer.apiLayer?.payUPaymentParams?.payUSIParams != null
    ): FeeCombinations? {

        val data = if (InternalConfig.userSelectedOfferInfo != null) {
            getOfferCF(offerKey = InternalConfig.userSelectedOfferInfo?.offerKey, ibiboCode, isSITxn)
        } else {
            if (isSITxn.not()) cfMap.get(ibiboCode) else cfMapForSI.get(ibiboCode)
        }

        return data
    }

    fun getCFandTaxAmount(
        ibiboCode: String,
        isSITxn: Boolean = SdkUiInitializer.apiLayer?.payUPaymentParams?.payUSIParams != null
    ): Pair<Double, Double>? {
        var taxAmount = 0.0
        var cfAmount = 0.0

        val feeCombinations = if (InternalConfig.userSelectedOfferInfo != null)
            getOfferCF(offerKey = InternalConfig.userSelectedOfferInfo?.offerKey, ibiboCode, isSITxn)
        else if (isSITxn.not()) cfMap.get(ibiboCode) else cfMapForSI.get(ibiboCode)

        feeCombinations?.convenienceFeeCharges?.forEach {
            taxAmount += it.taxAmount
            cfAmount += it.baseFee
        } ?: return null

        return Pair(cfAmount, taxAmount)

    }

    fun getConvFeeComb(
        ibiboCode: String,
        isSITxn: Boolean = SdkUiInitializer.apiLayer?.payUPaymentParams?.payUSIParams != null
    ): FeeCombinations? {
        var taxAmount = 0.0
        var cfAmount = 0.0

        val feeCombinations = if (InternalConfig.userSelectedOfferInfo != null)
            getOfferCF(offerKey = InternalConfig.userSelectedOfferInfo?.offerKey, ibiboCode, isSITxn)
        else if (isSITxn.not()) cfMap.get(ibiboCode) else cfMapForSI.get(ibiboCode)

        feeCombinations?.convenienceFeeCharges?.forEach {
            taxAmount += it.taxAmount
            cfAmount += it.baseFee
        } ?: return null

        return feeCombinations

    }

    fun getCFandTaxAmountFromFeeComb(
        feeCombinations: FeeCombinations?,
    ): Pair<Double, Double>? {
        var taxAmount = 0.0
        var cfAmount = 0.0

        feeCombinations?.convenienceFeeCharges?.forEach {
            taxAmount += it.taxAmount
            cfAmount += it.baseFee
        } ?: return null

        return Pair(cfAmount, taxAmount)

    }


    fun checkIfCFPresent(
        ibiboCode: String,
        isSITxn: Boolean = SdkUiInitializer.apiLayer?.payUPaymentParams?.payUSIParams != null
    ): Boolean {
        return if (InternalConfig.userSelectedOfferInfo != null)
            getOfferCF(offerKey = InternalConfig.userSelectedOfferInfo?.offerKey, ibiboCode, isSITxn) != null
        else if (isSITxn.not()) cfMap.containsKey(ibiboCode) else cfMapForSI.containsKey(ibiboCode)
    }


    private fun getOfferCF(offerKey: String?, ibiboCode: String, isSITxn: Boolean): FeeCombinations? {
        return if (isSITxn.not()) {
            offerCFMap[ibiboCode]?.let {
                if (it.first == offerKey) it.second else null
            }
        } else {
            offerCFMapForSI[ibiboCode]?.let {
                if (it.first == offerKey) it.second else null
            }
        }
    }

    fun getModeForCF(category: String?): String? {
        return when (category?.uppercase()) {
            SdkUiConstants.CP_NB -> SdkUiConstants.CP_NET_BANKING
            SdkUiConstants.CP_WALLET.uppercase(Locale.ROOT), SdkUiConstants.CP_CASH, SdkUiConstants.CP_CASH_CARD -> SdkUiConstants.CP_CASH_CARD.uppercase(
                Locale.ROOT
            )
            SdkUiConstants.CP_UPI, SdkUiConstants.CP_EMI, SdkUiConstants.CP_BNPL -> category.uppercase(
                Locale.ROOT
            )
            SdkUiConstants.CP_UPI_INTENT -> SdkUiConstants.CP_UPI
            else -> category
        }
    }

    fun getPaymentModeNameForCF(paymentOption: PaymentOption?): String?{
        return when (paymentOption?.paymentType) {
            PaymentType.CARD -> paymentOption.bankCode
            PaymentType.WALLET -> SdkUiConstants.CP_CASH_CARD
            PaymentType.CLOSED_LOOP_WALLET -> SdkUiConstants.CP_CASH_CARD
            PaymentType.OPEN_LOOP_WALLET -> SdkUiConstants.CP_CASH_CARD
            PaymentType.UPI_INTENT -> SdkUiConstants.CP_UPI
            else -> paymentOption?.paymentType?.name
        }
    }

    fun getPaymentModeNameForCF(paymentType: String?): String?{
        return when (paymentType?.uppercase(Locale.ROOT)) {
            PaymentType.WALLET.name -> SdkUiConstants.CP_CASH_CARD
            PaymentType.CLOSED_LOOP_WALLET.name -> SdkUiConstants.CP_CASH_CARD
            PaymentType.OPEN_LOOP_WALLET.name -> SdkUiConstants.CP_CASH_CARD
            PaymentType.UPI_INTENT.name -> SdkUiConstants.CP_UPI
            else ->paymentType
        }
    }

}