package com.payu.ui.model.callbacks

import androidx.recyclerview.widget.DiffUtil
import com.payu.base.models.PaymentOption

class RecyclerViewDiffUtils(
    private val oldList: ArrayList<PaymentOption>,
    private val newList: List<PaymentOption>
) :
    DiffUtil.Callback() {

    override fun getOldListSize(): Int {
        return oldList.size
    }

    override fun getNewListSize(): Int {
        return newList.size
    }

    override fun areItemsTheSame(oldItemPosition: Int, newItemPosition: Int): Boolean {
        return oldList[oldItemPosition].bankName == newList[newItemPosition].bankName
    }

    override fun areContentsTheSame(oldItemPosition: Int, newItemPosition: Int): Boolean {
        val (name) = listOf(oldList[oldItemPosition])
        val (name1) = listOf(newList[newItemPosition])
        return (name.bankName == name1.bankName)
    }

    override fun getChangePayload(oldItemPosition: Int, newItemPosition: Int): Any? {
        return super.getChangePayload(oldItemPosition, newItemPosition)
    }
}
