package com.payu.ui.model.adapters.viewholders

import android.content.Context
import android.view.View
import android.widget.TextView
import androidx.recyclerview.widget.GridLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.payu.ui.R
import com.payu.ui.model.adapters.TopBankAdapter
import com.payu.ui.model.models.AdapterViewSections

class TopBanksViewHolder(view: View) : RecyclerView.ViewHolder(view) {
        private var rlTopBankView: TextView? = view.findViewById(R.id.rlTopBankView)
        private var rvTopBanks: RecyclerView? = view.findViewById(R.id.rvTopBanks)

        fun bind(item: AdapterViewSections.TopBanks, displayTopBanks: Boolean?) {
            if (rvTopBanks?.layoutManager == null)
                rvTopBanks?.layoutManager = GridLayoutManager(itemView.context, 3)
            if (displayTopBanks == true) {
                rlTopBankView?.visibility = View.VISIBLE
                rvTopBanks?.visibility = View.VISIBLE
            } else {
                rlTopBankView?.visibility = View.GONE
                rvTopBanks?.visibility = View.GONE
            }
            val adapter = TopBankAdapter(
                paymentType = item.paymentType,
                banksList = item.topBankList,
                paymentState = item.paymentState,
                childFragmentManager = item.childFragmentManager,
                offerApplyListener = item.offerApplyListener,
                onBankAdapterListener = item.onBankAdapterListener
            )
            rvTopBanks?.adapter = adapter
            rvTopBanks?.visibility = View.VISIBLE
            rlTopBankView?.visibility = View.VISIBLE

        }
    }
