package com.payu.ui.model.adapters.viewholders

import android.view.View
import android.widget.ImageView
import android.widget.TextView
import com.payu.base.listeners.OnFetchImageListener
import com.payu.base.listeners.VerifyServiceListener
import com.payu.base.models.ApiResponse
import com.payu.base.models.BnplOption
import com.payu.base.models.CardOption
import com.payu.base.models.ImageDetails
import com.payu.base.models.ImageParam
import com.payu.base.models.InternalConfig
import com.payu.base.models.PaymentMode
import com.payu.base.models.PaymentType
import com.payu.base.models.UPIOption
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.managers.OfferFilterManager
import com.payu.ui.model.utils.ImageViewUtils
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.Utils
import com.payu.ui.model.utils.ViewUtils

class SavedOptionViewHolder(itemView: View) : QuickOptionViewHolder(itemView) {
    private val tvPaymentOptionType: TextView = itemView.findViewById(R.id.tvPaymentOptionType)
    private val tvPaymentOptionDetail: TextView = itemView.findViewById(R.id.tvPaymentOptionDetail)
    private val ivVerified: ImageView = itemView.findViewById(R.id.ivVerified)
    private val tvCvvText: TextView = itemView.findViewById(R.id.tv_cvv_text)
    private val tvCvvImg: ImageView = itemView.findViewById(R.id.tv_cvv_img)
    private val tvBNPLNotEligible: TextView = itemView.findViewById(R.id.tvBNPLNotEligible)

    fun bind(paymentMode: PaymentMode, selectedPosition: Int) {
        val paymentOption = paymentMode.optionDetail?.get(0)
        updateSelectedItem(paymentMode, selectedPosition)
        tvCvvImg.visibility = View.GONE
        tvCvvText.visibility = View.GONE
        when (paymentMode.type) {

            PaymentType.CARD -> {
                val cardOption = paymentOption as CardOption
                if (!paymentMode.name.equals(SdkUiConstants.CP_NULL, ignoreCase = true)) {
                    tvPaymentOptionName.text = cardOption.bankName
                }
                tvPaymentOptionType.text =
                    cardOption.cardBinInfo?.cardType?.getTypeName()

                when {
                    paymentMode.isBankDown -> showBankDownView()
                    //TODO will uncommnt when offer supported in saved card
//                        quickOptionList[position].isOfferValid -> showOfferView(holder)
                    else -> {
                        showDefaultView()
                        enableView()
                    }
                }

                Utils.splitCardNumber(cardOption.cardNumber).let {
                    if (it.isNotEmpty())
                        tvPaymentOptionDetail.visibility = View.VISIBLE
                    tvPaymentOptionDetail.text = it
                }

                val param = ImageParam(paymentOption, true, R.drawable.payu_cards_placeholder)
                SdkUiInitializer.apiLayer?.getImageForPaymentOption(
                    param,
                    object : OnFetchImageListener {
                        override fun onImageGenerated(result: ImageDetails) {
                            ImageViewUtils.setImage(ivPaymentOptionIcon, result)
                        }
                    })
                tvCvvImg.visibility = View.VISIBLE
                tvCvvText.visibility = View.VISIBLE
            }

            PaymentType.UPI, PaymentType.UPI_INTENT -> {
                when {
                    (paymentOption?.isBankDown == true) -> showBankDownView()

                    paymentMode.isOfferValid && InternalConfig.selectedOfferInfo != null -> {
                        showOfferView(
                            true
                        )
                        enableView()
                    }

                    paymentOption?.let {
                        !OfferFilterManager.filterPaymentOption(InternalConfig.userSelectedOfferInfo?.upiOptionOfferInfoList, ArrayList(arrayListOf(it))).isNullOrEmpty()
                    } == true && InternalConfig.selectedOfferInfo != null -> {
                        showOfferView()
                        enableView()
                    }

                    else -> {
                        showDefaultView()
                        enableView()
                    }
                }
                (paymentOption as UPIOption).vpa.let {
                    if (it.isNotEmpty())
                        tvPaymentOptionDetail.visibility = View.VISIBLE
                    tvPaymentOptionDetail.text = it
                }
                tvPaymentOptionName.text = paymentOption.bankName
                ivVerified.visibility = View.VISIBLE
                tvPaymentOptionType.visibility = View.GONE
            }

            PaymentType.NB -> {
                val bankCode = Utils.getValueFromPaymentOption<String>(
                    SdkUiConstants.CP_BANK_CODE,
                    paymentOption?.otherParams as? HashMap<String, Any?>
                ).toString()

                tvPaymentOptionType.text =
                    tvPaymentOptionType.context?.getString(R.string.payu_netbanking)

                when {
                    (paymentOption?.isBankDown == true) -> showBankDownView()
                    paymentMode.isOfferValid && InternalConfig.selectedOfferInfo != null -> {
                        showOfferView(
                            true
                        )
                        enableView()
                    }

                    paymentOption?.paymentType?.let { paymenType ->
                        Utils.isOfferAvailable(
                            bankCode,
                            paymenType
                        )
                    } == true && InternalConfig.selectedOfferInfo != null -> {
                        showOfferView()
                        enableView()
                    }

                    else -> {
                        showDefaultView()
                        enableView()
                    }
                }
                tvPaymentOptionDetail.visibility = View.VISIBLE
                tvPaymentOptionDetail.text =
                    tvPaymentOptionDetail.context?.getString(R.string.payu_pay_using_nb_text)
                tvPaymentOptionName.text = paymentOption?.bankName

            }
            PaymentType.WALLET -> {
                val bankCode = Utils.getValueFromPaymentOption<String>(
                    SdkUiConstants.CP_BANK_CODE,
                    paymentOption?.otherParams as? HashMap<String, Any?>
                ).toString()

                tvPaymentOptionType.text =
                    tvPaymentOptionType.context?.getString(R.string.payu_wallet)

                when {
                    (paymentOption?.isBankDown == true) -> showBankDownView()
                    paymentMode.isOfferValid && InternalConfig.selectedOfferInfo != null -> {
                        showOfferView(
                            true
                        )
                        enableView()
                    }

                    paymentOption?.paymentType?.let { paymenType ->
                        Utils.isOfferAvailable(
                            bankCode,
                            paymenType
                        )
                    } == true && InternalConfig.selectedOfferInfo != null -> {
                        showOfferView()
                        enableView()
                    }

                    else -> {
                        showDefaultView()
                        enableView()
                    }
                }
                tvPaymentOptionDetail.visibility = View.VISIBLE
                tvPaymentOptionDetail.text =
                    tvPaymentOptionDetail.context?.getString(R.string.pay_using_wallet_text)
                tvPaymentOptionName.text = paymentOption?.bankName

            }


            PaymentType.BNPL -> {
                val bnplOption = (paymentOption as BnplOption)
                bnplOption.phoneNumber.let {
                    if (it.isNotEmpty())
                        tvPaymentOptionDetail.visibility = View.VISIBLE
                    tvPaymentOptionDetail.text = it
                }
                tvPaymentOptionName.text = bnplOption.bankName

                when(bnplOption.isEligible) {
                    null -> {
                        ViewUtils.disableView(btnProceedToPay)
                        ivVerified.visibility = View.GONE
                        tvBNPLNotEligible.visibility = View.GONE

                        SdkUiInitializer.apiLayer?.verifyEligibilityAPI(bnplOption, object :
                            VerifyServiceListener {
                            override fun eligibilityDetails(apiResponse: ApiResponse) {
                                val resourceId: Int? = Utils.getEligibilityDetails(apiResponse, bnplOption.paymentType!!)
                                bnplOption.isEligible = resourceId == null
                                bind(paymentMode, selectedPosition)
                            }
                        })
                    }
                    true -> {
                        ViewUtils.enableView(btnProceedToPay)
                        ivVerified.visibility = View.VISIBLE
                        tvBNPLNotEligible.visibility = View.GONE
                    }
                    false -> {
                        ViewUtils.disableView(btnProceedToPay)
                        ivVerified.visibility = View.GONE
                        tvBNPLNotEligible.visibility = View.VISIBLE
                    }
                }

                tvPaymentOptionType.visibility = View.GONE
            }

        }

        btnProceedToPay.setOnClickListener {
            paymentOption?.let {
                makePayment(btnProceedToPay.context, paymentOption)
            }
        }

        rlQuickOptions.setOnClickListener {
            onItemClickListener?.invoke(
                paymentMode,
                absoluteAdapterPosition,
                true
            )
        }

        if (paymentOption?.paymentType != PaymentType.CARD) {
            paymentOption?.let {
                val param = ImageParam(
                    it, false, Utils.getDefaultDrawable(paymentMode.type)
                )
                SdkUiInitializer.apiLayer?.getImageForPaymentOption(param,
                    object : OnFetchImageListener {
                        override fun onImageGenerated(result: ImageDetails) {
                            ImageViewUtils.setImage(ivPaymentOptionIcon, result)
                        }
                    })
            }
        }
    }

    private fun enableView() {
        ViewUtils.enableViews(listOf(tvPaymentOptionType, tvPaymentOptionDetail))
    }
}
