package com.payu.ui.model.adapters.viewholders


import android.view.View
import android.widget.Button
import android.widget.ImageView
import android.widget.TextView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.recyclerview.widget.RecyclerView
import com.payu.base.models.PaymentMode
import com.payu.base.models.PaymentOption
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.utils.ViewUtils

open class QuickPayViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
    internal val bankLogo = itemView.findViewById<ImageView>(R.id.iv_bank)
    internal val tvTitle = itemView.findViewById<TextView>(R.id.tv_title)
    internal val tvOfferText = itemView.findViewById<TextView>(R.id.tvOfferText)
    internal val btnPay = itemView.findViewById<Button>(R.id.btn_pay)
    internal val clItemView = itemView.findViewById<ConstraintLayout>(R.id.clItemView)

    var onItemClickListener: ((paymentMode: PaymentMode, position: Int) -> Unit)? =
        null
    var makePayment: ((paymentOption: PaymentOption, position: Int) -> Unit)? = null

    internal fun updateBgColorView() {
        ViewUtils.updateBackgroundColor(
            btnPay.context,
            btnPay,
            SdkUiInitializer.apiLayer?.config?.primaryColor,
            R.color.one_payu_colorPrimary
        )
        ViewUtils.updateButtonTextColor(btnPay, SdkUiInitializer.apiLayer?.config?.baseTextColor)
    }

    internal fun showOfferView(isOfferAvailable: Boolean) {
        if (isOfferAvailable)
            tvOfferText.visibility = View.VISIBLE
        else tvOfferText.visibility = View.GONE
    }
}