package com.payu.ui.model.adapters.viewholders

import android.view.View
import android.view.ViewGroup
import androidx.annotation.DrawableRes
import com.payu.base.listeners.OnFetchImageListener
import com.payu.base.models.ImageDetails
import com.payu.base.models.ImageParam
import com.payu.base.models.PaymentMode
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentType
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.utils.ImageViewUtils

class QuickPayNBViewHolder(itemView: View) : QuickPayViewHolder(itemView) {
    internal fun bind(
        item: PaymentMode,
        selectedPosition: Int
    ) {

        val paymentOption = item.optionDetail?.get(0)

        showOfferView(item.isOfferValid)
        updateSelectedItem(item, selectedPosition)
        updateBgColorView()

        when (paymentOption?.paymentType) {
            PaymentType.NB -> {
                updateUI(
                    paymentOption,
                    R.drawable.payu_netbanking,
                    tvTitle.context.getString(R.string.payu_netbanking)
                )
            }

            PaymentType.WALLET -> {
                updateUI(
                    paymentOption,
                    R.drawable.payu_wallet,
                    tvTitle.context.getString(R.string.payu_wallet)
                )
            }

            PaymentType.UPI, PaymentType.UPI_INTENT -> {
                updateUI(
                    paymentOption,
                    R.drawable.payu_upi
                )
            }

            else -> {
                updateUI(
                    paymentOption,
                    R.drawable.payu_bnpl
                )
            }
        }



        tvTitle.setOnClickListener {
            onItemClickListener?.invoke(item, position)

        }
        bankLogo.setOnClickListener {
            onItemClickListener?.invoke(item, position)
        }
        btnPay.setOnClickListener {
            if (paymentOption != null) {
                makePayment?.invoke(paymentOption, absoluteAdapterPosition)
            }
        }

    }

    private fun handleItemSelection(paymentType: PaymentType?) {
        btnPay.visibility = View.VISIBLE
        clItemView.background =
            clItemView.context.resources.getDrawable(R.drawable.rectangular_background)
        val param = clItemView.layoutParams as ViewGroup.MarginLayoutParams
        param.setMargins(8, 0, 8, 0)
        clItemView.layoutParams = param
    }

    private fun handleNoSelection() {
        btnPay.visibility = View.GONE
        clItemView.background = null
        val param = clItemView.layoutParams as ViewGroup.MarginLayoutParams
        param.setMargins(0, 0, 0, 0)
        clItemView.layoutParams = param
    }

    private fun updateSelectedItem(
        paymentMode: PaymentMode,
        selectedPosition: Int
    ) {
        if (selectedPosition == absoluteAdapterPosition)
            handleItemSelection(paymentMode.type)
        else {
            paymentMode.isOfferValid = false
            handleNoSelection()
        }

    }

    private fun updateUI(
        paymentOption: PaymentOption?,
        @DrawableRes defaultDrawable: Int,
        paymentTypeName: String = "",
    ) {
        paymentOption?.let {
            tvTitle.text = it.bankName + " " + paymentTypeName
            val param = ImageParam(it, false, defaultDrawable)
            SdkUiInitializer.apiLayer?.getImageForPaymentOption(
                param,
                object : OnFetchImageListener {
                    override fun onImageGenerated(result: ImageDetails) {
                        ImageViewUtils.setImage(bankLogo, result)
                    }
                })
        }
    }
}