package com.payu.ui.model.adapters.viewholders

import android.text.Editable
import android.text.TextWatcher
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import com.payu.base.listeners.OnFetchImageListener
import com.payu.base.models.ImageDetails
import com.payu.base.models.ImageParam
import com.payu.base.models.PaymentMode
import com.payu.base.models.SavedCardOption
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.utils.ImageViewUtils
import com.payu.ui.model.utils.Utils

class QuickPayCardsViewHolder(itemView: View) : QuickPayViewHolder(itemView) {

    private val cvvLable = itemView.findViewById<TextView>(R.id.tv_cv)
    private val cvvValue = itemView.findViewById<TextView>(R.id.et_cvv)

    internal fun bind(
        item: PaymentMode,
        selectedPosition: Int
    ) {
        val savedCardOption = item.optionDetail?.get(0) as? SavedCardOption
        tvTitle.text =
            savedCardOption?.bankName + " " + savedCardOption?.cardBinInfo?.cardType?.getTypeName() + " " + Utils.getFormattedString(
                savedCardOption?.cardNumber,
                savedCardOption?.cardBinInfo?.cardScheme
            )?.takeLast(9)
        updateSelectedItem(item, selectedPosition)
        updateBgColorView()
        if (savedCardOption != null) {
            val param = ImageParam(savedCardOption, true, R.drawable.payu_cards_placeholder)
            SdkUiInitializer.apiLayer?.getImageForPaymentOption(
                param,
                object : OnFetchImageListener {
                    override fun onImageGenerated(result: ImageDetails) {
                        ImageViewUtils.setImage(bankLogo, result)
                    }
                })
        }

        val cvvLength = Utils.getCvvInputLength(savedCardOption?.cardBinInfo?.cardScheme)

        cvvValue?.addTextChangedListener(object : TextWatcher {
            override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {
            }

            override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
            }

            override fun afterTextChanged(s: Editable?) {
                if (cvvValue.text.length == cvvLength) {
                    btnPay.isEnabled = true
                    btnPay.alpha = 1f
                    savedCardOption?.cvv = cvvValue.text.toString()
                } else {
                    btnPay.isEnabled = false
                    btnPay.alpha = 0.5f
                }
            }

        })

        tvTitle.setOnClickListener {
            onItemClickListener?.invoke(item, position)
        }
        bankLogo.setOnClickListener {
            onItemClickListener?.invoke(item, position)
        }
        btnPay.setOnClickListener {
            if (savedCardOption != null) {
                makePayment?.invoke(savedCardOption, absoluteAdapterPosition)
            }
        }


    }

    private fun handleItemSelection() {
        btnPay.isEnabled = false
        btnPay.alpha = 0.5f
        cvvValue.text = ""
        btnPay.visibility = View.VISIBLE
        cvvLable.visibility = View.VISIBLE
        cvvValue.visibility = View.VISIBLE
        val param = clItemView.layoutParams as ViewGroup.MarginLayoutParams
        param.setMargins(8, 0, 8, 0)
        clItemView.layoutParams = param
        clItemView.background =
            clItemView.context.resources.getDrawable(R.drawable.rectangular_background)

    }

    private fun handleNoSelection() {
        btnPay.visibility = View.GONE
        cvvLable.visibility = View.GONE
        cvvValue.visibility = View.GONE
        clItemView.background = null
        val param = clItemView.layoutParams as ViewGroup.MarginLayoutParams
        param.setMargins(0, 0, 0, 0)
        clItemView.layoutParams = param
    }

    private fun updateSelectedItem(
        paymentMode: PaymentMode,
        selectedPosition: Int
    ) {
        if (selectedPosition == absoluteAdapterPosition)
            handleItemSelection()
        else {
            paymentMode.isOfferValid = false
            handleNoSelection()
        }

    }

}