package com.payu.ui.model.adapters.viewholders

import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.ProgressBar
import android.widget.TextView
import com.payu.base.models.BnplOption
import com.payu.base.models.PaymentMode
import com.payu.ui.R
import com.payu.ui.model.utils.ViewUtils
import com.payu.base.listeners.OnFetchImageListener
import com.payu.base.models.ImageDetails
import com.payu.base.models.ImageParam
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.utils.ImageViewUtils

class QuickPayBNPLViewHolder(itemView: View) : QuickPayViewHolder(itemView) {

    private var progressBar = itemView.findViewById<ProgressBar>(R.id.progressBar)
    private var mobNum = itemView.findViewById<TextView>(R.id.tv_num)
    private var tvEligibility = itemView.findViewById<TextView>(R.id.tvEligibility)
    private var ivEligible = itemView.findViewById<ImageView>(R.id.ivEligible)

    internal fun bind(
        item: PaymentMode,
        selectedPosition: Int
    ) {
        val paymentOption = item.optionDetail?.get(0)
        tvTitle.text = paymentOption?.bankName
        updateSelectedItem(item, selectedPosition)
        updateBgColorView()

        clItemView.setOnClickListener {
            onItemClickListener?.invoke(item, position)
        }
        btnPay.setOnClickListener {
            if (paymentOption != null) {
                makePayment?.invoke(paymentOption, absoluteAdapterPosition)
            }
        }
        if (paymentOption != null) {
            val param = ImageParam(paymentOption, false, R.drawable.payu_bnpl)
            SdkUiInitializer.apiLayer?.getImageForPaymentOption(
                param,
                object : OnFetchImageListener {
                    override fun onImageGenerated(result: ImageDetails) {
                        ImageViewUtils.setImage(bankLogo, result)
                    }
                })
        }
    }

    private fun handleItemSelection(paymentType: PaymentMode) {
        btnPay.visibility = View.VISIBLE
        mobNum.visibility = View.VISIBLE
        val paymentOption = paymentType.optionDetail?.get(0)
        mobNum.text = paymentOption?.phoneNumber ?: ""
        val param = clItemView.layoutParams as ViewGroup.MarginLayoutParams
        param.setMargins(8, 0, 8, 0)
        clItemView.layoutParams = param
        clItemView.background =
            clItemView.context.resources.getDrawable(R.drawable.rectangular_background)

        when ((paymentType.optionDetail?.get(0) as BnplOption).isEligible) {
            null -> {
                progressBar.visibility = View.VISIBLE
                ViewUtils.disableView(btnPay)
                tvEligibility.visibility = View.GONE
            }
            true -> {
                progressBar.visibility = View.GONE
                ViewUtils.enableView(btnPay)
                tvEligibility.visibility = View.GONE
                ivEligible.visibility = View.VISIBLE
            }
            else -> {
                progressBar.visibility = View.GONE
                ViewUtils.disableView(btnPay)
                tvEligibility.visibility = View.VISIBLE
                ivEligible.visibility = View.GONE
                tvEligibility.text = itemView.context.getString(R.string.payu_not_eligible)
                tvEligibility.background = itemView.context.getDrawable(R.drawable.ic_bnpl_no_eligibility)
            }
        }
    }

    private fun handleNoSelection() {
        btnPay.visibility = View.GONE
        progressBar.visibility = View.GONE
        mobNum.visibility = View.GONE
        clItemView.background = null
        val param = clItemView.layoutParams as ViewGroup.MarginLayoutParams
        param.setMargins(0, 0, 0, 0)
        clItemView.layoutParams = param
    }

    private fun updateSelectedItem(
        paymentMode: PaymentMode,
        selectedPosition: Int
    ) {
        if (selectedPosition == absoluteAdapterPosition)
            handleItemSelection(paymentMode)
        else {
            paymentMode.isOfferValid = false
            handleNoSelection()
        }

    }
}