package com.payu.ui.model.adapters.viewholders

import android.view.View
import android.widget.Button
import android.widget.TextView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.content.ContextCompat
import androidx.core.view.isVisible
import androidx.recyclerview.widget.RecyclerView
import com.payu.base.models.InternalConfig
import com.payu.base.models.OfferInfo
import com.payu.ui.R
import com.payu.ui.model.listeners.OnOfferDetailsListener
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.Utils
import java.util.Locale

class OfferListViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView),
    View.OnClickListener {

    private val tvOfferName: TextView = itemView.findViewById(R.id.tvOfferName)
    private val tvOfferDetails: TextView = itemView.findViewById(R.id.tvOfferDetails)
    private val btnUseOfferButton: Button = itemView.findViewById(R.id.btnUseOfferButton)
    private val tvtnc: TextView = itemView.findViewById(R.id.tvtnc)
    private val tvTermsAndConditionDesc: TextView = itemView.findViewById(R.id.tvTermsAndConditionDesc)
    private val tvSkuName: TextView = itemView.findViewById(R.id.tvSkuName)
    private val tvDiscount: TextView = itemView.findViewById(R.id.tvDiscount)
    private val tvRewardOfferDesc: TextView = itemView.findViewById(R.id.tvRewardsDesc)

    private var tncPosition = -1
    private var updatePreviousSkuId: ((String) -> Unit)? = null
    private var updateTncPosition: ((Int) -> Unit)? = null
    private var onOfferDetailsListener: OnOfferDetailsListener? = null
    private var offerInfo: OfferInfo?= null
    init {
        btnUseOfferButton.setOnClickListener(this)
        tvtnc.setOnClickListener(this)
    }

    fun bind(
        offerInfo: OfferInfo?,
        previousSkuId: String,
        tncPosition: Int,
        updatePreviousSkuId: ((String) -> Unit)?,
        updateTncPosition: ((Int) -> Unit)?,
        offerListener: OnOfferDetailsListener?
    ) {
        this.offerInfo = offerInfo
        this.tncPosition = tncPosition
        this.updatePreviousSkuId = updatePreviousSkuId
        this.updateTncPosition = updateTncPosition
        this.onOfferDetailsListener = offerListener
        val context = itemView.context
        val data = offerInfo
        tvOfferName.text = data?.title?.trim()
        tvOfferDetails.visibility = View.VISIBLE
        tvOfferDetails.text = data?.description?.trim()
        tvtnc.visibility = View.VISIBLE
        if (data?.sku?.skuName != null && (previousSkuId != data.sku?.skuId.toString())) {
            tvSkuName.visibility = View.VISIBLE
            tvSkuName.text = data.sku?.skuName?.replaceFirstChar {
                if (it.isLowerCase()) it.titlecase(
                    Locale.ROOT
                ) else it.toString()
            }
            updatePreviousSkuId?.invoke(data.sku?.skuId.toString())
        } else {
            tvSkuName.visibility = View.GONE
        }
        data?.discountDetailsOfOffers?.discount?.let {
            tvDiscount.visibility = View.VISIBLE
            tvDiscount.text = context.getString(
                R.string.payu_discount_text, Utils.getFormattedAmount(
                    it,
                    context,
                    R.string.payu_amount_text
                ), context.getString(R.string.payu_off_text)
            )
        }
        data?.offerType?.let{
            tvRewardOfferDesc.isVisible = data.offerType.equals(SdkUiConstants.CP_REWARD, ignoreCase = true)
        }
        handleNoSelection()
    }

    override fun onClick(v0: View?) {
        when (v0?.id) {
            R.id.btnUseOfferButton -> {
                offerInfo?.let {
                    InternalConfig.userSelectedOfferInfo = it
                }
                onOfferDetailsListener?.let {
                    it.hideBottomSheet()
                    it.updateSelectedOfferForUserSelected()
                    it.showChangeOfferView(
                        shouldShowChangeOffer = true,
                        isAutoApply = false
                    )
                    it.updateOffer()
                }
            }

            R.id.tvtnc -> {
                val context = itemView.context
                if (tncPosition == -1) {
                    tvTermsAndConditionDesc.visibility = View.VISIBLE
                    tvTermsAndConditionDesc.text =
                        offerInfo?.tnc
                    tvtnc.text = context.getText(R.string.payu_hide_tnc)
                    tncPosition = 1
                } else {
                    tncPosition = -1
                    tvTermsAndConditionDesc.visibility = View.GONE
                    tvtnc.text = context.getText(R.string.payu_tnc)
                    tvtnc.setTextColor(
                        ContextCompat.getColor(
                            context,
                            R.color.payu_color_053bc1
                        )
                    )

                }
            }
        }

    }

    private fun handleNoSelection() {
        val context = itemView.context
        val updateTextViewMargin : (TextView)-> Unit =  { it ->
            it.isSingleLine = false
            val layoutParams = it.layoutParams as ConstraintLayout.LayoutParams
            layoutParams.marginEnd = context.resources.getDimension(R.dimen.payu_dimen_26dp).toInt()
            it.layoutParams = layoutParams
        }
        tvOfferName.also {
            updateTextViewMargin.invoke(it)
        }
        tvOfferDetails.also {
            updateTextViewMargin.invoke(it)
        }
    }
}
