package com.payu.ui.model.adapters.viewholders

import android.view.View
import android.view.View.OnClickListener
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.payu.ui.R
import com.payu.ui.model.listeners.OnNetBankingAdapterListener
import com.payu.ui.model.models.AdapterViewSections

class LoginSectionViewHolder(view: View) : RecyclerView.ViewHolder(view), OnClickListener {
    private var tvLoggedInPhoneNumber: TextView = view.findViewById(R.id.tvGlobalVaultPhoneNumber)
    private var ivLoginSettings: ImageView = view.findViewById(R.id.ivGvSettings)
    private var tvTimer: TextView = view.findViewById(R.id.tvTimer)

    private var onNetBankingAdapterListener: OnNetBankingAdapterListener? = null

    fun bind(
        item: AdapterViewSections.LoginSection,
        onNetBankingAdapterListener: OnNetBankingAdapterListener
    ) {
        tvTimer.text = item.timerString
        this.onNetBankingAdapterListener = onNetBankingAdapterListener
        tvLoggedInPhoneNumber.text = item.phoneNumber
        ivLoginSettings.visibility = if (item.phoneNumber.isNullOrEmpty()) View.GONE else View.VISIBLE
        tvLoggedInPhoneNumber.setOnClickListener(this)
        ivLoginSettings.setOnClickListener(this)
    }

    override fun onClick(v: View?) {
        when (v?.id) {
            R.id.tvTimer,
            R.id.tvGlobalVaultPhoneNumber,
            R.id.ivGvSettings -> {
                onNetBankingAdapterListener?.showLoginSettings()
            }
        }
    }
}
