package com.payu.ui.model.adapters.viewholders

import android.text.Editable
import android.view.View
import android.widget.Button
import android.widget.CheckBox
import android.widget.EditText
import android.widget.ImageView
import android.widget.ProgressBar
import android.widget.RelativeLayout
import android.widget.TextView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.content.ContextCompat
import androidx.core.widget.addTextChangedListener
import androidx.recyclerview.widget.RecyclerView
import com.payu.base.listeners.OnFetchImageListener
import com.payu.base.listeners.VerifyServiceListener
import com.payu.base.models.ApiResponse
import com.payu.base.models.CardOption
import com.payu.base.models.EMIOption
import com.payu.base.models.ImageDetails
import com.payu.base.models.ImageParam
import com.payu.base.models.InternalConfig
import com.payu.base.models.NBOptions
import com.payu.base.models.PaymentFlowState
import com.payu.base.models.PaymentModel
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentState
import com.payu.base.models.PaymentType
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.listeners.OnBankAdapterListener
import com.payu.ui.model.listeners.ValidateOfferResultListener
import com.payu.ui.model.managers.CFManager
import com.payu.ui.model.managers.NetworkManager
import com.payu.ui.model.utils.AnalyticsUtils
import com.payu.ui.model.utils.ImageViewUtils
import com.payu.ui.model.utils.MultipleClickHandler
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.Utils
import com.payu.ui.model.utils.ViewUtils

class BankItemViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView),
    View.OnClickListener, View.OnFocusChangeListener {
    private val context = itemView.context
    private val ivPaymentOptionIcon: ImageView = itemView.findViewById(R.id.ivPaymentOptionIcon)
    private val ivRightArrow: ImageView = itemView.findViewById(R.id.ivRightArrow)
    private val tvPaymentOptionName: TextView = itemView.findViewById(R.id.tvPaymentOptionName)
    private val tvOfferText: TextView = itemView.findViewById(R.id.tvOfferText)
    private val tvPaymentOptionDetails: TextView =
        itemView.findViewById(R.id.tvPaymentOptionDetails)
    private val tvBankDown: TextView = itemView.findViewById(R.id.tvBankDown)
    val tvErrorPhone: TextView = itemView.findViewById(R.id.tvErrorPhone)
    private val btnProceedToPay: Button = itemView.findViewById(R.id.btnProceedToPay)
    private val pbPhone: ProgressBar = itemView.findViewById(R.id.pbPhone)
    private val rlOptionDetail: ConstraintLayout = itemView.findViewById(R.id.rlOptionDetail)
    private val clOtherOption: ConstraintLayout = itemView.findViewById(R.id.clOtherOption)
    private val clExpandedView: ConstraintLayout = itemView.findViewById(R.id.clExpandedView)
    val etPhoneBackground: View = itemView.findViewById(R.id.etPhoneBackground)
    val etPhone: EditText = itemView.findViewById(R.id.etPhone)
    private val tvNoCostEmi: TextView = itemView.findViewById(R.id.tvNoCostEmi)
    private var bankAdapterListener: OnBankAdapterListener? = null
    private val rlSwitchSaveCard: RelativeLayout = itemView.findViewById(R.id.rlSwitchSaveCard)
    private val switchSaveCard: CheckBox = itemView.findViewById(R.id.switchSaveCard)
    private val tvTpvInfo: TextView = itemView.findViewById(R.id.tvTpvInfo)
    private val tvError: TextView = itemView.findViewById(R.id.tvError)

    private var paymentType: PaymentType? = null
    private var paymentState: PaymentState? = null
    private var bankCode: String? = null
    private var paymentOption: PaymentOption? = null
    private var isOfferValid: Boolean = false
    private var changeSelection: ((Int?) -> Unit)? = null
    private var notifyItemChanged: ((Int) -> Unit)? = null

    private var filteredListSize: Int = -1
    private var relativePosition: Int = -1
    private var selectedPosition: Int = -1

    init {
        rlOptionDetail.setOnClickListener(this)
        btnProceedToPay.setOnClickListener(this)
        etPhone.onFocusChangeListener = this
        updateBgColors()
    }

    fun bind(
        paymentOption: PaymentOption,
        paymentState: PaymentState?,
        relativePosition: Int,
        selectedPosition: Int,
        defaultListSize: Int,
        filteredListSize: Int,
        changeSelection: ((Int?) -> Unit)? = null,
        notifyItemChanged: (Int) -> Unit,
        onBankAdapterListener: OnBankAdapterListener?,
    ) {
        this.paymentType = paymentOption.paymentType
        this.paymentState = paymentState
        this.paymentOption = paymentOption
        this.selectedPosition = selectedPosition
        this.filteredListSize = filteredListSize
        this.bankAdapterListener = onBankAdapterListener
        this.changeSelection = changeSelection
        this.notifyItemChanged = notifyItemChanged
        this.relativePosition = relativePosition
        etPhone.addTextChangedListener { editable ->
            numberChanged(editable, paymentOption)
        }

        val data = paymentOption

        if (selectedPosition == relativePosition)
            handleItemSelection(paymentOption)
        else if (filteredListSize == 1 && defaultListSize == 1 && paymentType == PaymentType.EMI) {
            this.selectedPosition = relativePosition
            changeSelection?.invoke(relativePosition)
            proceedToPayClicked(isForcedPayment = true)
        } else {
            data.isOfferValid = false
            handleNoSelection()
        }
        if (InternalConfig.userAccountInfoList.isNullOrEmpty()
                .not() && paymentType == PaymentType.NB
        ) {
            tvPaymentOptionDetails.visibility = View.VISIBLE
            val accountNumber =
            if (Utils.isEnachPayment(paymentType)) {
                (data as? NBOptions)?.beneficiaryDetails?.beneficiaryAccountNumber
            } else {
                data.accountNumber
            }
            tvTpvInfo.text = context.getString(
                R.string.payu_tpv_nb_info,
                Utils.getLastFourDigitFromAccount(accountNumber ?: "")
            )
            tvPaymentOptionDetails.text =
                Utils.getMaskedAccountNoForTpv(
                    R.string.payu_tpv_account_string,
                    context,
                    accountNumber ?: ""
                )
        }


        if (paymentState != null && paymentState == PaymentState.MCP) displayMCPData(
            paymentOption
        )
        else {
            tvPaymentOptionName.text = data.bankName
            bankCode = Utils.getValueFromPaymentOption<String>(
                SdkUiConstants.CP_BANK_CODE,
                data.otherParams as? HashMap<String, Any?>
            ).toString()
            when {
                data.isBankDown -> showBankDownView(
                    data
                )

                data.optionList?.isEmpty() == true -> showBankDownView(
                    data
                )

                paymentType == PaymentType.EMI && Utils.isOffersInEmi(data as EMIOption) -> showOfferView(
                    paymentType
                )


                paymentType != PaymentType.EMI && data.isOfferValid && InternalConfig.selectedOfferInfo != null -> showOfferView(
                    paymentType,
                    true
                )

                Utils.isOfferAvailable(
                    bankCode ?: "",
                    paymentType
                ) && InternalConfig.userSelectedOfferInfo != null && (selectedPosition != relativePosition) -> showOfferView(
                    paymentType
                )

                InternalConfig.userSelectedOfferInfo != null && paymentType == PaymentType.UPI_INTENT && (selectedPosition != relativePosition) -> showOfferView(
                    paymentType
                )

                else -> {
                    if (data.isOfferValid) data.isOfferValid =
                        false
                    showNormalView()
                }
            }

            var param: ImageParam? = null
            when (paymentType) {
                PaymentType.EMI -> {
                    val emiOption = data as EMIOption
                    //This shows the lowest interest rate for all tenures in the L3 bank screen in EMI
                    if (emiOption.isBankOption) {
                        tvPaymentOptionDetails.visibility = View.VISIBLE
                        tvPaymentOptionDetails.text =
                            if (emiOption.isNoCostEmi) context.getString(R.string.payu_no_interest_charged) else context.getString(
                                R.string.payu_interest_percentage,
                                emiOption.lowestInterestRate.toString()
                            )
                    }
                    if (emiOption.isNoCostEmi) {
                        tvNoCostEmi.visibility = View.VISIBLE
                        ViewUtils.updateBackgroundColor(
                            context,
                            tvNoCostEmi,
                            SdkUiInitializer.apiLayer?.config?.primaryColor,
                            R.color.one_payu_colorPrimary
                        )

                    } else {
                        tvNoCostEmi.visibility = View.GONE

                    }
                    param = ImageParam(
                        emiOption,
                        false,
                        Utils.getDefaultDrawable(emiOption.paymentType, emiOption.emiType)
                    )
                }

                else -> {
                    param = ImageParam(
                        data,
                        false,
                        Utils.getDefaultDrawable(data.paymentType)
                    )
                }
            }
            SdkUiInitializer.apiLayer?.getImageForPaymentOption(
                param,
                onFetchImageListener = object : OnFetchImageListener {
                    override fun onImageGenerated(result: ImageDetails) {
                        ImageViewUtils.setImage(ivPaymentOptionIcon, result)
                    }
                })
        }

        if(paymentOption.error!= null && paymentOption.error?.trim()?.isEmpty()?.not() == true) {
            tvError.visibility = View.VISIBLE
            tvError.text = paymentOption.error
        } else
            tvError.visibility = View.GONE

    }

    private fun numberChanged(editable: Editable?, paymentOption: PaymentOption) {
        pbPhone.visibility = View.GONE
        if (paymentState == PaymentState.MobileEligibility && Utils.isValidPhoneNumber(editable.toString())) {
            etPhone.clearFocus()
            ViewUtils.hideSoftKeyboard(pbPhone)
            //TODO need to check paymentModel use case
            val paymentModel = Utils.getPaymentModel(
                paymentOption, null
            )
            paymentModel.paymentOption?.phoneNumber = etPhone.text.toString()
            paymentModel.paymentOption?.let {
                pbPhone.visibility = View.VISIBLE
                SdkUiInitializer.apiLayer?.verifyEligibilityAPI(it, verifyServiceListener())
            }
        } else {
            ViewUtils.disableView(btnProceedToPay)
        }

    }

    private fun updateBgColors() {
        context.let {
            ViewUtils.updateBackgroundColor(
                it,
                btnProceedToPay,
                SdkUiInitializer.apiLayer?.config?.primaryColor,
                R.color.one_payu_colorPrimary
            )
            ViewUtils.updateBackgroundColor(
                it,
                pbPhone,
                SdkUiInitializer.apiLayer?.config?.primaryColor,
                R.color.one_payu_colorPrimary
            )

            ViewUtils.updateTextColor(
                it,
                btnProceedToPay,
                SdkUiInitializer.apiLayer?.config?.baseTextColor,
                R.color.one_payu_baseTextColor
            )
        }
    }

    override fun onClick(v: View?) {
        val view = bankAdapterListener?.getCurrentFocus()
        if (view != null) {
            Utils.hideKeyboard(view)
        }
        when (v?.id) {
            R.id.rlOptionDetail -> {
                if (paymentType == PaymentType.OPEN_LOOP_WALLET) {
                    if(paymentOption?.error != null)
                        tvError.visibility = View.GONE
                    proceedToPayClicked()
                } else {
                    if (paymentType == PaymentType.EMI) {
                        v.isEnabled = false
                        proceedToPayClicked()
                    }
                    setSelection(relativePosition)
                }
            }

            R.id.btnProceedToPay -> {
                if (MultipleClickHandler.isSafeOnClickListener()) {
                    v.isEnabled = false
                    proceedToPayClicked()
                }
            }
        }
    }

    private fun proceedToPayClicked(isForcedPayment: Boolean = false) {
        isOfferValid = false
        if (bankAdapterListener?.isActivityAlive() == true) {
            if (ViewUtils.isInternetAvailable(context)) {
                ViewUtils.dismissSnackBar()
                if (bindingAdapterPosition != -1) {
                    paymentOption?.let {
                        when (it.paymentType) {
                            PaymentType.EMI -> {
                                bankAdapterListener?.emiSelected(
                                    it,
                                    isForcedPayment
                                )
                                val bankName = it.bankName
                                if (bankName.equals(SdkUiConstants.CP_CREDIT_CARD) || bankName.equals(
                                        SdkUiConstants.CP_DEBIT_CARD
                                    ) || bankName.equals(SdkUiConstants.CP_CARDLESS_EMI)
                                )
                                    AnalyticsUtils.logL2ClickEvents(
                                        context,
                                        paymentType,
                                        it.bankName
                                    )
                                else AnalyticsUtils.logL3CTAClickEvent(
                                    context,
                                    it.bankName,
                                    paymentType
                                )
                            }

                            PaymentType.OPEN_LOOP_WALLET -> {
                                bankAdapterListener?.itemSelected(it, isTopItem = false)
                            }

                            else -> {
                                var paymentModel: PaymentModel? = null;
                                it.shouldSaveCard = switchSaveCard.isChecked
                                if (paymentState != null && paymentState == PaymentState.MobileEligibility) {
                                    if (validatePhoneNumber()) {
                                        paymentModel = Utils.getPaymentModel(
                                            it, PaymentFlowState().apply {
                                                paymentState = this@BankItemViewHolder.paymentState
                                            }
                                        )
                                        paymentModel.paymentOption?.phoneNumber =
                                            etPhone.text.toString()
                                    }
                                } else {
                                    AnalyticsUtils.logMakePaymentEvent(
                                        context.applicationContext,
                                        it
                                    )
                                }
                                makePayment(paymentModel)
                            }
                        }
                    }
                }
            } else {
                NetworkManager.registerReceiver(context.applicationContext)
                bankAdapterListener?.showSnackBar(
                    context.resources.getString(R.string.payu_no_internet_connection),
                    R.drawable.payu_no_internet
                )
            }
        }
    }

    private fun validatePhoneNumber(): Boolean {
        etPhone.clearFocus()
        if (!Utils.isValidPhoneNumber(etPhone.text.toString())) {
            ViewUtils.updateStrokeColor(
                etPhone.context,
                etPhoneBackground,
                R.color.payu_color_de350b
            )
            tvErrorPhone.visibility = View.VISIBLE
            tvErrorPhone.text =
                tvErrorPhone.context.getString(R.string.payu_invalid_mobile_number)
            return false
        }
        ViewUtils.updateStrokeColor(etPhone.context, etPhoneBackground)
        tvErrorPhone.visibility = View.GONE
        return true
    }

    override fun onFocusChange(v: View?, hasFocus: Boolean) {
        when (v?.id) {
            R.id.etPhone -> {
                if (hasFocus) {
                    ViewUtils.updateStrokeColor(
                        v.context,
                        etPhoneBackground,
                        SdkUiInitializer.apiLayer?.config?.primaryColor,
                        R.color.one_payu_colorPrimary
                    )
                    tvErrorPhone.visibility = View.GONE
                } else {
                    ViewUtils.updateStrokeColor(
                        v.context,
                        etPhoneBackground,
                        R.color.payu_color_338f9dbd
                    )

                }
            }
        }
    }

    ///

    private fun displayMCPData(
        paymentOption: PaymentOption
    ) {
        val cardOption = paymentOption as CardOption
        "${cardOption.convertedCurrency} ${cardOption.convertedAmount}".also {
            tvPaymentOptionName.text = it
        }
        val param = ImageParam(
            paymentOption,
            false,
            Utils.getDefaultDrawable(paymentOption.paymentType),
            cardOption.convertedCurrency
        )
        SdkUiInitializer.apiLayer?.getImageForPaymentOption(
            param,
            onFetchImageListener = object : OnFetchImageListener {
                override fun onImageGenerated(result: ImageDetails) {
                    ImageViewUtils.setImage(ivPaymentOptionIcon, result)
                }
            })
        showNormalView()
    }

    private fun setSelection(position: Int) {
        if (bankAdapterListener?.isActivityAlive() == true) {
            bankAdapterListener?.clearFocus {
                if (itemView.isFocusable) itemView.requestFocus()
            }
        }

        if (selectedPosition != position) {
            changeSelection?.invoke(null)

            selectedPosition = position
            changeSelection?.invoke(position)
            if (filteredListSize > selectedPosition && selectedPosition != -1) {
                paymentOption?.let {
                    InternalConfig.isPaymentOptionSelected = true
                    if (InternalConfig.userAccountInfoList.isNullOrEmpty() && (InternalConfig.isOfferEnabled || InternalConfig.pricingEnabledModes?.contains(CFManager.getPaymentModeNameForCF(paymentOption)) == true)) {
                        bankAdapterListener?.validateOffer(it,
                            object : ValidateOfferResultListener {
                                override fun onValidateOfferResponse(isOfferValid: Boolean) {
                                    paymentOption?.isOfferValid = isOfferValid
                                    notifyItemChanged?.invoke(position)
                                }
                            })
                    }
                }
            }
            notifyItemChanged?.invoke(position)
        } else {
            if (position != -1)
                paymentOption?.isOfferValid = false
            changeSelection?.invoke(null)
            bankAdapterListener?.itemUnSelected(false)
            tvError.visibility = View.GONE
        }
    }

    private fun handleNoSelection() {
        if (paymentType != PaymentType.EMI) {
            if (selectedPosition == -1 && paymentState != PaymentState.MCP && paymentType != PaymentType.OPEN_LOOP_WALLET) {
                bankAdapterListener?.itemUnSelected(false)
                tvError.visibility = View.GONE
            }
            btnProceedToPay.visibility = View.GONE
            tvTpvInfo.visibility = View.GONE
            rlSwitchSaveCard.visibility = View.GONE
            clExpandedView.visibility = View.GONE
            ivRightArrow.visibility = View.VISIBLE
            ivRightArrow.setImageDrawable(context.getDrawable(R.drawable.payu_arrow_right))
            clOtherOption.setBackgroundColor(
                ContextCompat.getColor(
                    context,
                    R.color.payu_color_ffffff
                )
            )
        }
    }

    private fun verifyServiceListener() = object : VerifyServiceListener {
        override fun eligibilityDetails(apiResponse: ApiResponse) {
            pbPhone.visibility = View.GONE
            when (val resourceId: Int? = Utils.getEligibilityDetails(apiResponse, paymentType)) {
                null -> {
                    ViewUtils.enableView(btnProceedToPay)
                    ViewUtils.updateStrokeColor(etPhone.context, etPhoneBackground)
                    tvErrorPhone.visibility = View.GONE
                }

                else -> {
                    ViewUtils.updateStrokeColor(
                        etPhone.context,
                        etPhoneBackground,
                        R.color.payu_color_de350b
                    )
                    tvErrorPhone.visibility = View.VISIBLE
                    tvErrorPhone.text =
                        if (resourceId == -1) apiResponse.errorMessage else context.getString(
                            resourceId
                        )
                    ViewUtils.disableView(btnProceedToPay)
                }
            }

        }

    }

    private fun handleItemSelection(paymentOption: PaymentOption) {
        if (paymentType != PaymentType.EMI) {
            val siDetails = SdkUiInitializer.apiLayer?.payUPaymentParams?.payUSIParams
            val banksSelectedPosition = paymentOption
            val paymentModel = Utils.getPaymentModel(banksSelectedPosition, null)
            paymentState = SdkUiInitializer.apiLayer?.getPaymentState(paymentModel)?.paymentState

            // To show OTM details bottomsheet
            if (paymentType == PaymentType.UPI_INTENT && SdkUiInitializer.apiLayer?.payUPaymentParams?.payUSIParams?.isPreAuthTxn == true) {
                bankAdapterListener?.itemSelected(
                    banksSelectedPosition,
                    isOfferValid = false,
                    false
                )
                selectedPosition = -1
            } else if (siDetails == null || paymentState == PaymentState.MCP || paymentState == PaymentState.MobileEligibility || (siDetails != null && (paymentType == PaymentType.UPI))) {
                bankCode = Utils.getValueFromPaymentOption<String>(
                    SdkUiConstants.CP_BANK_CODE,
                    banksSelectedPosition.otherParams as? HashMap<String, Any?>
                ).toString()
                isOfferValid = Utils.isOfferAvailable(bankCode ?: "", paymentType)
                bankAdapterListener?.itemSelected(
                    banksSelectedPosition,
                    isOfferValid,
                    false
                )
                //log Selected Bank Analytics Event for Non-MCP Flow
                if (paymentState != PaymentState.MCP)
                    AnalyticsUtils.logL2ClickEvents(
                        context.applicationContext,
                        paymentType,
                        banksSelectedPosition.bankName,
                        isOfferValid
                    )
                InternalConfig.isPaymentOptionSelected = true
                btnProceedToPay.visibility = View.VISIBLE
                if (InternalConfig.userAccountInfoList.isNullOrEmpty().not() && (paymentType == PaymentType.NB))
                    tvTpvInfo.visibility = View.VISIBLE
                if (InternalConfig.isQuickPayEnabled && InternalConfig.isQuickPayBottomSheetEnabled && !Utils.isSiTxn()) {
                    rlSwitchSaveCard.visibility = View.VISIBLE
                    switchSaveCard.isChecked = true
                } else {
                    rlSwitchSaveCard.visibility = View.GONE
                    switchSaveCard.isChecked = false
                }
                if (paymentState == PaymentState.MobileEligibility) {
                    ViewUtils.disableView(btnProceedToPay)
                    clExpandedView.visibility = View.VISIBLE
                } else {
                    ViewUtils.enableView(btnProceedToPay)
                    clExpandedView.visibility = View.GONE
                }

                tvPaymentOptionName.isSingleLine = false
                ivRightArrow.visibility = View.INVISIBLE
                ivRightArrow.setImageDrawable(context.getDrawable(R.drawable.payu_close))
                ivRightArrow.setOnClickListener {
                    changeSelection?.invoke(null)
                }

                clOtherOption.setBackgroundColor(
                    ContextCompat.getColor(
                        context,
                        R.color.payu_color_f9fafe
                    )
                )
            } else {
                makePayment()
            }
        }
    }

    private fun showBankDownView(paymentOption: PaymentOption) {
        if (paymentOption.subText.isNotEmpty())
            tvBankDown.text = paymentOption.subText
        tvBankDown.visibility = View.VISIBLE
        tvOfferText.visibility = View.GONE
        tvPaymentOptionDetails.visibility = View.GONE
        rlOptionDetail.isEnabled = false
        ViewUtils.disableViews(
            listOf(
                ivPaymentOptionIcon,
                tvPaymentOptionName,
                ivRightArrow
            )
        )
    }

    private fun showNormalView() {
        tvBankDown.visibility = View.GONE
        tvOfferText.visibility = View.GONE
        rlOptionDetail.isEnabled = true
        ViewUtils.enableViews(
            listOf(
                ivPaymentOptionIcon,
                tvPaymentOptionName
            )
        )
    }

    private fun showOfferView(
        paymentType: PaymentType?,
        isOfferValid: Boolean = false
    ) {
        if (isOfferValid && paymentType != null && paymentType != PaymentType.EMI) {
            tvOfferText.text = context.resources.getString(R.string.payu_offer_applied)
            ViewUtils.updateBackgroundColor(
                context,
                tvOfferText,
                R.color.payu_color_36b37e.toString(),
                R.color.payu_color_36b37e
            )
        } else {
            tvOfferText.text = context.resources.getString(R.string.payu_offers)
            ViewUtils.updateBackgroundColor(
                context,
                tvOfferText,
                SdkUiInitializer.apiLayer?.config?.primaryColor,
                R.color.one_payu_colorPrimary
            )
        }
        tvBankDown.visibility = View.GONE
        tvOfferText.visibility = View.VISIBLE
        rlOptionDetail.isEnabled = true
        tvPaymentOptionName.isSingleLine = false
        ViewUtils.enableViews(
            listOf(
                ivPaymentOptionIcon,
                tvPaymentOptionName
            )
        )
    }

    internal fun makePayment(paymentModel: PaymentModel? = null) {
        if (bankCode.equals(SdkUiConstants.INTENT)) {
            paymentOption?.userAgent = Utils.getUpiAnalyticsString(context)
        }
        paymentOption?.let {
            SdkUiInitializer.apiLayer?.updatePaymentState(
                Utils.getPaymentModel(
                    it,
                    PaymentFlowState().apply {
                        this.paymentState = paymentModel?.paymentFlowState?.paymentState
                    }),
                ViewUtils.getToolbar(
                    context,
                    it.additionalCharge
                )
            )
        }
    }
}



