package com.payu.ui.model.adapters

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.fragment.app.FragmentManager
import androidx.recyclerview.widget.RecyclerView
import com.payu.base.listeners.OnFetchImageListener
import com.payu.base.models.*
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.listeners.BottomSheetValidateApiListener
import com.payu.ui.model.listeners.OfferApplyListener
import com.payu.ui.model.listeners.OnOtherPaymentOptionsAdapterListener
import com.payu.ui.model.utils.*
import com.payu.ui.view.customViews.BNPLAndUPIBottomSheet

class UpiIntentAdapter(
    val offerApplyListener: OfferApplyListener,
    val bottomSheetValidateApiListener: BottomSheetValidateApiListener?,
    private val upiTopApps: ArrayList<PaymentOption>,
    val onOtherPaymentOptionsAdapterListener: OnOtherPaymentOptionsAdapterListener,
    val paymentMode: PaymentMode,
    private var childFragmentManager: FragmentManager
) :
    RecyclerView.Adapter<UpiIntentAdapter.HorizontalViewHolder>() {

    private val TAG = javaClass.simpleName
    //TODO not getting used if not needed please remove
    var bottomSheet = BNPLAndUPIBottomSheet.Builder(childFragmentManager, TAG)
    private var upiIntentBottomSheet: BNPLAndUPIBottomSheet? = null

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): HorizontalViewHolder {
        val inflater = LayoutInflater.from(parent.context)
        val view = inflater.inflate(R.layout.upi_intent_layout_item, parent, false)
        return HorizontalViewHolder(view)
    }

    override fun onBindViewHolder(holder: HorizontalViewHolder, position: Int) {
        holder.bind(position)
    }

    override fun getItemCount(): Int {
        return upiTopApps.size
    }

    inner class HorizontalViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        val tvIntentAppName: TextView = itemView.findViewById(R.id.tvIntentAppName)
        val ivIntentLogo: ImageView = itemView.findViewById(R.id.ivIntentLogo)
        val rlTopUpiAppItem: ConstraintLayout = itemView.findViewById(R.id.rlTopUpiAppItem)

        fun bind(position: Int) {

            tvIntentAppName.text = upiTopApps[position].bankName

            val param = ImageParam(
                upiTopApps[position],
                false,
                Utils.getDefaultDrawable(upiTopApps[position].paymentType)
            )

            if (upiTopApps[position].bankName.equals(SdkUiConstants.OTHERS)) {
                val drawable = itemView.context?.getDrawable(R.drawable.payu_upi_lightened)
                ivIntentLogo.setImageDrawable(drawable)
            } else {
                SdkUiInitializer.apiLayer?.getImageForPaymentOption(
                    param,
                    onFetchImageListener = object : OnFetchImageListener {
                        override fun onImageGenerated(result: ImageDetails) {
                            ImageViewUtils.setImage(ivIntentLogo, result)
                        }
                    })
            }

            rlTopUpiAppItem.setOnClickListener {
                it.context?.let { context ->
                    if (ViewUtils.isInternetAvailable(context)) {

                        // Preventing multiple clicks, using threshold of 1 second
                        if (MultipleClickHandler.isSafeOnClickListener()) {
                            context.let { it1 ->
                                AnalyticsUtils.logCheckoutL1CTAClickEvent(
                                    it1,
                                    upiTopApps[position].bankName,
                                    SdkUiConstants.CP_UPI
                                )
                            }

                            if (upiTopApps[position].bankName.equals(SdkUiConstants.OTHERS)) {
                                onOtherPaymentOptionsAdapterListener.setSelectedPaymentMode(
                                    paymentMode
                                )
                                onOtherPaymentOptionsAdapterListener.otherOptionSelected(paymentMode)
                            } else {
                                onOtherPaymentOptionsAdapterListener.updateSelectedPaymentOption(
                                    upiTopApps[position]
                                )
                                onOtherPaymentOptionsAdapterListener.updateHeaderAmount(upiTopApps[position])
                                InternalConfig.isPaymentOptionSelected = true
                                makePaymentByBottomsheet(it, position)
                            }
                        }
                    } else {
                        ViewUtils.showNetworkError(context)
                    }
                }
            }

        }
    }

    /**
     * Function to open bottomsheet when upi intent app selected in L1 and its handling
     */
    private fun makePaymentByBottomsheet(itemView: View, position: Int) {

        val bottomSheet =
            BNPLAndUPIBottomSheet.Builder(
                childFragmentManager,
                TAG
            ).setTitle(
                SdkUiConstants.NB_TEXT
                        + upiTopApps[position].bankName
                        + " " + SdkUiConstants.PAGE
            )
        bottomSheet.setMessage("").setIconParam(
            ImageParam(
                upiTopApps[position],
                false,
                Utils.getDefaultDrawable(upiTopApps[position].paymentType)
            )
        ).setPaymentOption(upiTopApps[position]).setOnDetachCallBack {
            onOtherPaymentOptionsAdapterListener.updateHeaderAmount(upiTopApps[position], resetAmount = true)
        }.setProceedListener {
            upiIntentBottomSheet?.close()
            makeUpiIntentPayment(itemView, position)
        }
        upiIntentBottomSheet = bottomSheet
            .setBottomSheetType(BottomSheetType.L1_BOTTOM_SHEET)
            .setOfferApplyListener(offerApplyListener)
            .setValidateApiListener(bottomSheetValidateApiListener!!)
            .build()
        upiIntentBottomSheet?.show()
    }

    /**
     * Funtion to make payment for the upi intent app selected
     */
    private fun makeUpiIntentPayment(
        itemView: View,
        position: Int,
        paymentModel: PaymentModel? = null
    ) {
        InternalConfig.removeOfferIfNeeded = false
        upiTopApps[position].userAgent =
            itemView.context?.let { Utils.getUpiAnalyticsString(it) } ?: ""
        SdkUiInitializer.apiLayer?.updatePaymentState(
            Utils.getPaymentModel(
                upiTopApps[position],
                PaymentFlowState().apply {
                    this.paymentState = paymentModel?.paymentFlowState?.paymentState
                }),
            itemView.context?.let {
                ViewUtils.getToolbar(
                    it,
                    upiTopApps[position].additionalCharge
                )
            }
        )
    }
}