package com.payu.ui.model.adapters

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.payu.base.models.*
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.viewmodel.PaymentOptionViewModel

class RecommendedOptionAdapter(
    private var quickOptionList: ArrayList<PaymentMode>
) : RecyclerView.Adapter<RecommendationRecyclerViewHolder>() {
    var phone: String? = SdkUiInitializer.apiLayer?.payUPaymentParams?.phone

    var onItemClickListener: ((view: View, paymentMode: PaymentMode, position: Int) -> Unit)? =
        null


    override fun onCreateViewHolder(
        parent: ViewGroup,
        viewType: Int
    ): RecommendationRecyclerViewHolder {
        val inflater = LayoutInflater.from(parent.context)
        return when (viewType) {
            TYPE_MOBILE_ELIGIBLE -> RecommendationRecyclerViewHolder.VerifiedPaymentOptionViewHolder(
                inflater.inflate(
                    R.layout.payu_recommended_option_isverified,
                    parent,
                    false
                )
            )
            else -> RecommendationRecyclerViewHolder.NonVerifiedPaymentOptionViewHolder(
                inflater.inflate(
                    R.layout.payu_recommended_not_verified,
                    parent,
                    false
                )
            )
        }
    }

    override fun onBindViewHolder(holder: RecommendationRecyclerViewHolder, position: Int) {
        val paymentMode = quickOptionList[position]
        holder.onItemClickListener = onItemClickListener
        when (holder) {
            is RecommendationRecyclerViewHolder.NonVerifiedPaymentOptionViewHolder -> paymentMode.let {
                holder.bind(
                    it
                )
            }
            is RecommendationRecyclerViewHolder.VerifiedPaymentOptionViewHolder -> paymentMode.let {
                holder.bind(
                    it
                )
            }
        }

    }

    override fun getItemCount(): Int {
        return quickOptionList.size
    }

    override fun getItemViewType(position: Int): Int {
        val paymentMode =
            quickOptionList[position]
        return when (paymentMode.type) {
            PaymentType.BNPL -> {
                if ((paymentMode.optionDetail?.isNotEmpty() == true) && (paymentMode.optionDetail?.get(
                        0
                    ) as BnplOption).isEligible == true
                ) TYPE_MOBILE_ELIGIBLE
                else
                    TYPE_MOBILE_NOT_ELIGIBLE
            }
            else -> TYPE_MOBILE_NOT_ELIGIBLE
        }

    }

    companion object {
        private const val TYPE_MOBILE_ELIGIBLE: Int = 1
        private const val TYPE_MOBILE_NOT_ELIGIBLE: Int = 2
    }


}


