package com.payu.ui.model.adapters

import android.os.Handler
import android.os.Looper
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Filter
import android.widget.Filterable
import androidx.annotation.DrawableRes
import androidx.annotation.LayoutRes
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import androidx.recyclerview.widget.RecyclerView.ViewHolder
import com.payu.base.models.InternalConfig
import com.payu.base.models.OfferInfo
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentState
import com.payu.base.models.PaymentType
import com.payu.ui.R
import com.payu.ui.model.adapters.viewholders.AddNewCardViewHolder
import com.payu.ui.model.adapters.viewholders.BankItemViewHolder
import com.payu.ui.model.adapters.viewholders.ErrorViewHolder
import com.payu.ui.model.adapters.viewholders.LoginSectionViewHolder
import com.payu.ui.model.adapters.viewholders.OfferListViewHolder
import com.payu.ui.model.adapters.viewholders.OfferViewHolder
import com.payu.ui.model.adapters.viewholders.OtmMessageViewHolder
import com.payu.ui.model.adapters.viewholders.SKUOfferListViewHolder
import com.payu.ui.model.adapters.viewholders.SearchViewHolder
import com.payu.ui.model.adapters.viewholders.SummaryViewHolder
import com.payu.ui.model.adapters.viewholders.TopBanksViewHolder
import com.payu.ui.model.adapters.viewholders.TpvAccountListViewHolder
import com.payu.ui.model.listeners.OnBankAdapterListener
import com.payu.ui.model.listeners.OnNetBankingAdapterListener
import com.payu.ui.model.listeners.OnOfferDetailsListener
import com.payu.ui.model.models.AdapterViewSections
import com.payu.ui.model.models.ListAdapterType
import com.payu.ui.model.models.ListOrder
import com.payu.ui.model.models.TilesData
import com.payu.ui.model.utils.ViewUtils


class NetBankingAdapter(
    private var paymentState: PaymentState? = null,
    private val onBankAdapterListener: OnBankAdapterListener?,
    private val onNetBankingAdapterListener: OnNetBankingAdapterListener,
    private val onOfferDetailsListener: OnOfferDetailsListener?
) : RecyclerView.Adapter<ViewHolder>(), Filterable {

    private val sections: ArrayList<AdapterViewSections> = arrayListOf()

    private var allBanksText: String? = null
    private var allBanksIcon: Int? = null
    private var showTezOmniView: Boolean = false
    private var showOfferViewInUPICollect: Boolean = false
    private var hideSearchView: Boolean? = null
    private var hideHeaderView: Boolean? = null
    private var displayTopBanks: Boolean? = null

    private var isSearchInitDone = false
    private var offerUpdated: Boolean = false
    private var showTpvAccountView: Boolean = false
    private var showTpvInfo: Boolean = false

    //bank adapter
    private var selectedPosition: Int = -1
    private var banksFilteredList: ArrayList<PaymentOption> = arrayListOf()

    private var recyclerView: RecyclerView? = null

    // offer adapter
    private var offersFilteredList: ArrayList<OfferInfo>? = arrayListOf()
    private var tncPosition = -1
    private var previousSkuId = ""

    private var adapterType: ListAdapterType? = null


    private var banksList: ArrayList<PaymentOption> = arrayListOf()
    private var offersList: ArrayList<OfferInfo> = arrayListOf()
    private var skuOffersList: ArrayList<OfferInfo> = arrayListOf()
    private var tilesDataList: ArrayList<TilesData> = arrayListOf()

    private var upiCollectView: AdapterViewSections.AddNewCard? = null
    private var emptyListView: AdapterViewSections.ErrorSection? = null

    init {
        generateAdapterType()
    }

    fun updateSection(at: Int, section: AdapterViewSections) {
        sections[at] = section
    }

    private fun generateAdapterType() {
        adapterType =
            if (banksList.isNotEmpty() && offersList.isEmpty() && skuOffersList.isEmpty())
                ListAdapterType.Bank
            else if (banksList.isEmpty() && offersList.isNotEmpty() && skuOffersList.isEmpty())
                ListAdapterType.Offer
            else
                ListAdapterType.SkuOffer
    }


    fun setBankListData(banksList: ArrayList<PaymentOption>) {
        if (banksList != this.banksList) {
            this.banksList = banksList
            this.banksFilteredList = this.banksList
        }
        generateAdapterType()
        notifyDataSetChanged()
    }

    fun setErrorOnBankListItem(paymentOption: PaymentOption) {
        val index = banksFilteredList.indexOfFirst {
            it.bankName == paymentOption.bankName
        }
        if (index != -1) {
            val relativeIndex = index + sections.size
            if (recyclerView?.isComputingLayout == false) {
                notifyItemChanged(relativeIndex)
            } else {
                recyclerView?.post { notifyItemChanged(relativeIndex) }
            }
        }
    }

    fun setUpiCollectView(item: AdapterViewSections.AddNewCard) {
        this.upiCollectView = item
    }

    fun setOfferListData(offersList: ArrayList<OfferInfo>) {
        if (offersList != this.offersList) {
            this.offersList = offersList
            this.offersFilteredList = this.offersList
        }
        generateAdapterType()
        notifyItemChanged(sections.size)
    }

    fun setSkuOfferListData(skuOffersList: ArrayList<OfferInfo>) {
        if (skuOffersList != this.skuOffersList) {
            this.skuOffersList = skuOffersList
        }
        generateAdapterType()
        notifyItemChanged(sections.size)
    }

    fun setOfferUpdated(offerUpdated: Boolean) {
        this.offerUpdated = offerUpdated
        val section = sections.firstOrNull {
            it is AdapterViewSections.SearchSection
        }
        section?.let { notifySectionChange(it) }
    }

    fun setResetBankSelection() {
        resetSelection()
    }

    fun setClearBankAdapter() {
        val oldSize = banksFilteredList.size
        this.banksList = arrayListOf()
        this.banksFilteredList = arrayListOf()
        notifyItemRangeRemoved(sections.size, oldSize)
    }

    fun setAllBanksText(allBanksText: String?) {
        this.allBanksText = allBanksText
        val section = sections.firstOrNull {
            it is AdapterViewSections.SearchSection
        }
        section?.let { notifySectionChange(section) }
    }

    fun setAllBanksIcon(icon: Int?) {
        this.allBanksIcon = icon
        val section = sections.firstOrNull {
            it is AdapterViewSections.SearchSection
        }
        section?.let { notifySectionChange(section) }
    }

    fun setShowTezOmniView(showTezOmniView: Boolean) {
        this.showTezOmniView = showTezOmniView
        val section = sections.firstOrNull {
            it is AdapterViewSections.AddNewCard
        }
        section?.let { notifySectionChange(section) }
    }

    fun setShowOfferViewInUPICollect(showOfferViewInUPICollect: Boolean) {
        this.showOfferViewInUPICollect = showOfferViewInUPICollect
        val section = sections.firstOrNull {
            it is AdapterViewSections.AddNewCard
        }
        section?.let { notifySectionChange(section) }
    }

    fun setHideSearchView(hideSearchView: Boolean) {
        this.hideSearchView = hideSearchView
        val section = sections.firstOrNull {
            it is AdapterViewSections.SearchSection
        }
        section?.let { notifySectionChange(section) }
    }

    fun setDisplayTopBanks(displayTopBanks: Boolean) {
        this.displayTopBanks = displayTopBanks
        val section = sections.firstOrNull {
            it is AdapterViewSections.TopBanks
        }
        section?.let { notifySectionChange(section) }
    }

    fun updateTopBanks(section: AdapterViewSections.TopBanks) {
        val indexOfTopBank = sections.indexOfFirst { adapterViewSections ->
            adapterViewSections is AdapterViewSections.TopBanks
        }
        if (indexOfTopBank != -1) {
            val topBankSection = sections[indexOfTopBank] as AdapterViewSections.TopBanks
            topBankSection.topBankList = section.topBankList
            notifyItemChanged(indexOfTopBank)
        } else {
            addSection(section)
        }
    }

    fun setTpvAccountInfoView(
        section: AdapterViewSections.TpvAccountView,
        showTpvAccountView: Boolean = false,
        showTpvInfo: Boolean = false
    ) {
        this.showTpvAccountView = showTpvAccountView
        this.showTpvInfo = showTpvInfo
        if (showTpvAccountView && showTpvInfo) addSection(section)
    }

    fun removeSections(section: AdapterViewSections): Boolean {
        val sectionIndex = findIndexOfSection(section)
        if (sectionIndex != -1) {
            when (section) {
                is AdapterViewSections.AddNewCard -> {
                    sections.removeAll {
                        it is AdapterViewSections.AddNewCard
                    }
                }

                is AdapterViewSections.Offer -> {
                    sections.removeAll {
                        it is AdapterViewSections.Offer
                    }
                }

                is AdapterViewSections.SearchSection -> {
                    sections.removeAll {
                        it is AdapterViewSections.SearchSection
                    }
                }

                is AdapterViewSections.Summary -> {
                    sections.removeAll {
                        it is AdapterViewSections.Summary
                    }
                }

                is AdapterViewSections.OTMMessageView -> {
                    sections.removeAll {
                        it is AdapterViewSections.OTMMessageView
                    }
                }

                is AdapterViewSections.TopBanks -> {
                    sections.removeAll {
                        it is AdapterViewSections.TopBanks
                    }
                }

                is AdapterViewSections.ErrorSection -> {
                    sections.removeAll {
                        it is AdapterViewSections.ErrorSection
                    }
                }

                is AdapterViewSections.LoginSection -> {
                    sections.removeAll {
                        it is AdapterViewSections.LoginSection
                    }
                }
            }
            notifyItemRemoved(sectionIndex)
            return true
        }
        return false
    }

    fun addSection(section: AdapterViewSections) {
        this.sections.add(section)
        sections.sortBy {
            it.preferredPosition
        }
        if (section is AdapterViewSections.Offer) {
            val firstVisiblePosition =
                (recyclerView?.layoutManager as LinearLayoutManager).findFirstVisibleItemPosition()
            if (firstVisiblePosition <= 1)
                recyclerView?.smoothScrollToPosition(findIndexOfSection(section))
            updateCurrentSelectionFromList()
        }
        notifyItemInserted(findIndexOfSection(section))
    }

    public fun findIndexOfSection(section: AdapterViewSections): Int {
        var index = -1
        when (section) {
            is AdapterViewSections.AddNewCard -> {
                index = sections.indexOfFirst { adapterViewSections ->
                    adapterViewSections is AdapterViewSections.AddNewCard
                }
            }

            is AdapterViewSections.Offer -> {
                index = sections.indexOfFirst { adapterViewSections ->
                    adapterViewSections is AdapterViewSections.Offer
                }
            }

            is AdapterViewSections.Summary -> {
                index = sections.indexOfFirst { adapterViewSections ->
                    adapterViewSections is AdapterViewSections.Summary
                }
            }

            is AdapterViewSections.OTMMessageView -> {
                index = sections.indexOfFirst { adapterViewSections ->
                    adapterViewSections is AdapterViewSections.OTMMessageView
                }
            }

            is AdapterViewSections.TopBanks -> {
                index = sections.indexOfFirst { adapterViewSections ->
                    adapterViewSections is AdapterViewSections.TopBanks
                }
            }

            is AdapterViewSections.TpvAccountView -> {
                index = sections.indexOfFirst { adapterViewSections ->
                    adapterViewSections is AdapterViewSections.TpvAccountView
                }
            }

            is AdapterViewSections.SearchSection -> {
                index = sections.indexOfFirst { adapterViewSections ->
                    adapterViewSections is AdapterViewSections.SearchSection
                }
            }

            is AdapterViewSections.ErrorSection -> {
                index = sections.indexOfFirst { adapterViewSections ->
                    adapterViewSections is AdapterViewSections.ErrorSection
                }
            }

            is AdapterViewSections.LoginSection -> {
                index = sections.indexOfFirst { adapterViewSections ->
                    adapterViewSections is AdapterViewSections.LoginSection
                }
            }

        }
        return index
    }

    private fun notifySectionChange(section: AdapterViewSections? = null) {
        section?.let {
            val index = findIndexOfSection(section)
            Handler(Looper.getMainLooper()).post { notifyItemChanged(index) }
        }
    }


    override fun getItemViewType(position: Int): Int {
        return if (position < sections.size) {
            when (sections[position]) {
                is AdapterViewSections.OTMMessageView -> ListOrder.OTMMessage.ordinal
                is AdapterViewSections.Summary -> ListOrder.Summary.ordinal
                is AdapterViewSections.Offer -> ListOrder.Offer.ordinal
                is AdapterViewSections.AddNewCard -> ListOrder.AddMoreSection.ordinal
                is AdapterViewSections.TopBanks -> ListOrder.TopBanks.ordinal
                is AdapterViewSections.SearchSection -> ListOrder.Search.ordinal
                is AdapterViewSections.ErrorSection -> ListOrder.ListErrorSection.ordinal
                is AdapterViewSections.TpvAccountView -> ListOrder.TPVAccounts.ordinal
                is AdapterViewSections.LoginSection -> ListOrder.LoginSection.ordinal
            }
        } else {
            if (emptyListView == null) {
                if (banksFilteredList.isNotEmpty() && offersList.isEmpty() && skuOffersList.isEmpty() && position < banksFilteredList.size + sections.size)
                    ListOrder.BankListItems.ordinal
                else if (banksFilteredList.isEmpty() && offersList.isNotEmpty() && skuOffersList.isEmpty() && position < offersList.size + sections.size)
                    ListOrder.OfferListItems.ordinal
                else if (banksFilteredList.isEmpty() && offersList.isEmpty() && skuOffersList.isNotEmpty() && position < skuOffersList.size + sections.size)
                    ListOrder.SKUOfferListItems.ordinal
                else {
                    ListOrder.UPICollectView.ordinal
                }
            } else {
                if(position == itemCount-1) { // last item
                    ListOrder.ListErrorSection.ordinal
                } else {
                    ListOrder.UPICollectView.ordinal
                }
            }
        }
    }

    private fun inflateAndGetView(parent: ViewGroup, @LayoutRes layoutId: Int): View {
        val inflater = LayoutInflater.from(parent.context)
        val view: View = inflater.inflate(layoutId, parent, false)
        return view
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return when (viewType) {
            ListOrder.OTMMessage.ordinal -> {
                OtmMessageViewHolder(
                    inflateAndGetView(
                        parent = parent,
                        layoutId = R.layout.otm_message_view
                    )
                )
            }
            ListOrder.Summary.ordinal -> {
                SummaryViewHolder(
                    inflateAndGetView(
                        parent = parent,
                        layoutId = R.layout.si_summary_title
                    )
                )
            }

            ListOrder.Offer.ordinal -> {
                OfferViewHolder(
                    inflateAndGetView(
                        parent = parent,
                        layoutId = R.layout.change_offer_toolbar
                    )
                )
            }

            ListOrder.AddMoreSection.ordinal, ListOrder.UPICollectView.ordinal -> {
                AddNewCardViewHolder(
                    inflateAndGetView(
                        parent = parent,
                        layoutId = R.layout.payu_add_new_card_row
                    )
                )
            }

            ListOrder.TopBanks.ordinal -> {
                TopBanksViewHolder(
                    inflateAndGetView(
                        parent = parent,
                        layoutId = R.layout.rv_list_and_title_section
                    )
                )
            }

            ListOrder.Search.ordinal -> {
                SearchViewHolder(
                    inflateAndGetView(
                        parent = parent,
                        layoutId = R.layout.layout_search_view_other_options
                    )
                )
            }

            ListOrder.OfferListItems.ordinal -> {
                OfferListViewHolder(
                    inflateAndGetView(
                        parent = parent,
                        layoutId = R.layout.offer_details_list_item
                    )
                )
            }

            ListOrder.SKUOfferListItems.ordinal -> {
                SKUOfferListViewHolder(
                    inflateAndGetView(
                        parent = parent,
                        layoutId = R.layout.sku_details_list_item
                    )
                )
            }

            ListOrder.ListErrorSection.ordinal -> {
                ErrorViewHolder(
                    inflateAndGetView(
                        parent = parent,
                        layoutId = R.layout.payu_search_error_layout
                    )
                )
            }

            ListOrder.TPVAccounts.ordinal -> {
                TpvAccountListViewHolder(
                    inflateAndGetView(
                        parent = parent,
                        layoutId = R.layout.layout_tpv_account_info
                    )
                )
            }

            ListOrder.LoginSection.ordinal -> {
                LoginSectionViewHolder(
                    inflateAndGetView(
                        parent = parent,
                        layoutId = R.layout.phone_setting_layout
                    )
                )
            }

            else -> {
                BankItemViewHolder(
                    inflateAndGetView(
                        parent = parent,
                        layoutId = R.layout.bank_option_list_item
                    )
                )
            }
        }
    }

    override fun getItemCount(): Int {
        val t = sections.size + banksFilteredList.size + (offersFilteredList?.size
            ?: 0) + (skuOffersList.size) + (if (upiCollectView == null) 0 else 1) + (if (emptyListView == null) 0 else 1)
        return t
    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        if (position < sections.size) {
            when (val item = sections[position]) {
                is AdapterViewSections.Offer -> (holder as OfferViewHolder).bind(
                    onNetBankingAdapterListener = onNetBankingAdapterListener
                )

                is AdapterViewSections.AddNewCard -> (holder as AddNewCardViewHolder).bind(
                    onNetBankingAdapterListener = onNetBankingAdapterListener,
                    showTezOmniView = showTezOmniView,
                    showOfferViewInUPICollect = showOfferViewInUPICollect,
                    item = item
                )

                is AdapterViewSections.Summary -> (holder as SummaryViewHolder).bind(item)
                is AdapterViewSections.OTMMessageView -> (holder as OtmMessageViewHolder).bind(item)
                is AdapterViewSections.TopBanks -> (holder as TopBanksViewHolder).bind(
                    item,
                    displayTopBanks = displayTopBanks,
                )

                is AdapterViewSections.SearchSection -> {
                    (holder as SearchViewHolder).bind(
                        allBanksText = allBanksText,
                        leftIcon = allBanksIcon,
                        isSearchInitDone = isSearchInitDone,
                        hideSearchView = hideSearchView,
                        hideHeaderView = hideHeaderView,
                        offerUpdated = offerUpdated,
                        resetSelection = { resetSelection() },
                        filterItems = {
                            filter.filter(it)
                        },
                        updateOfferUpdatedFlag = {
                            offerUpdated = it
                        },
                        updateSearchInitFlag = {
                            isSearchInitDone = it
                        }
                    )
                }

                is AdapterViewSections.ErrorSection -> (holder as ErrorViewHolder).bind(item = item)
                is AdapterViewSections.TpvAccountView -> (holder as TpvAccountListViewHolder).bind(
                    item = item,
                    showAccountInfo = showTpvAccountView,
                    showTpvInfo = showTpvInfo
                )
                is AdapterViewSections.LoginSection -> (holder as LoginSectionViewHolder).bind(
                    item = item,
                    onNetBankingAdapterListener = onNetBankingAdapterListener
                )
            }
        } else {
            if (getItemViewType(position) == ListOrder.BankListItems.ordinal) {
                (holder as BankItemViewHolder).bind(
                    paymentState = paymentState,
                    paymentOption = banksFilteredList[position - sections.size],
                    relativePosition = position - sections.size,
                    selectedPosition = selectedPosition,
                    defaultListSize = banksFilteredList.size,
                    filteredListSize = banksList.size,
                    changeSelection = {
                        if (it != null)
                            selectedPosition = it
                        else
                            resetSelection()
                    },
                    notifyItemChanged = {
                        notifyItemChanged(it + sections.size)
                    },
                    onBankAdapterListener = onBankAdapterListener,
                )
            } else if (getItemViewType(position) == ListOrder.OfferListItems.ordinal) {
                (holder as OfferListViewHolder).bind(
                    offerInfo = offersList[position],
                    previousSkuId = previousSkuId,
                    offerListener = onOfferDetailsListener,
                    tncPosition = tncPosition,
                    updatePreviousSkuId = {
                        previousSkuId = it
                    },
                    updateTncPosition = {
                        tncPosition = it
                    }

                )
            } else if (getItemViewType(position) == ListOrder.SKUOfferListItems.ordinal) {
                (holder as SKUOfferListViewHolder).bind(skuOffersList[position])
            } else if (getItemViewType(position) == ListOrder.UPICollectView.ordinal) {
                upiCollectView?.let {
                    (holder as AddNewCardViewHolder).bind(
                        onNetBankingAdapterListener = onNetBankingAdapterListener,
                        showTezOmniView = showTezOmniView,
                        showOfferViewInUPICollect = showOfferViewInUPICollect,
                        item = it
                    )
                }
            } else if (getItemViewType(position) == ListOrder.ListErrorSection.ordinal) {
                emptyListView?.let {
                    (holder as ErrorViewHolder).bind(item = it)
                }
            }
        }
    }

    private fun resetSelection() {
        InternalConfig.isPaymentOptionSelected = false
        onBankAdapterListener?.removeOffer()
        if (selectedPosition != -1) {
            val oldSelectedRelativePosition = selectedPosition + sections.size
            val oldSelectedPosition = selectedPosition
            resetView(oldSelectedRelativePosition)
            banksFilteredList[oldSelectedPosition].isOfferValid = false
            selectedPosition = -1 //reset the position
            notifyItemChanged(oldSelectedRelativePosition)
        }
    }

    private fun updateCurrentSelectionFromList() {
        if (selectedPosition != -1) {
            val relativePosition = selectedPosition + sections.size
            notifyItemChanged(relativePosition)
        }
    }

    private fun resetView(oldSelectedPosition: Int) {
        val bankViewHolder = recyclerView?.findViewHolderForAdapterPosition(oldSelectedPosition)
        bankViewHolder?.let {
            if (it is BankItemViewHolder) {
                (it.etPhone).text?.clear()
                (it.tvErrorPhone).visibility = View.GONE
                val clPhone = (it.etPhoneBackground)
                recyclerView?.context?.let { ctxt ->
                    ViewUtils.updateStrokeColor(
                        ctxt,
                        clPhone,
                        R.color.payu_color_338f9dbd
                    )
                }
            }
        }
    }

    override fun onAttachedToRecyclerView(recyclerView: RecyclerView) {
        super.onAttachedToRecyclerView(recyclerView)
        this.recyclerView = recyclerView
    }

    override fun getFilter(): Filter {
        return object : Filter() {

            override fun performFiltering(charSequence: CharSequence): FilterResults {
                when (adapterType) {
                    ListAdapterType.Bank -> {
                        val charString = charSequence.toString().trim()
                        val filterResults = FilterResults()
                        if (charString.isEmpty()) {
                            filterResults.values = banksList
                        } else {
                            val filteredList = ArrayList<PaymentOption>()
                            for (row in banksList) {
                                //match the charString with bank name
                                if (row.bankName.lowercase().contains(charString.lowercase())) {
                                    filteredList.add(row)
                                }
                            }
                            filterResults.values = filteredList
                        }
                        Handler(Looper.getMainLooper()).post {
                            resetSelection()
                        }
                        return filterResults
                    }

                    ListAdapterType.Offer -> {
                        val charString = charSequence.toString().trim()
                        offersFilteredList = if (charString.isEmpty()) {
                            offersList
                        } else {
                            val filteredList = ArrayList<OfferInfo>()
                            offersList.forEach { row ->
                                //match the charString with bank name
                                if (row.title?.lowercase()?.contains(charString.lowercase()) == true
                                    || row.description?.lowercase()
                                        ?.contains(charString.lowercase()) == true
                                ) {
                                    filteredList.add(row)
                                }
                            }
                            filteredList
                        }
                        val filterResults = FilterResults()
                        filterResults.values = offersFilteredList
                        return filterResults
                    }

                    else -> {
                        return FilterResults()
                    }
                }
            }

            override fun publishResults(
                charSequence: CharSequence?,
                filterResults: FilterResults
            ) {
                when (adapterType) {
                    ListAdapterType.Bank -> {
                        val oldSize = banksFilteredList.size
                        banksFilteredList = filterResults.values?.let {
                            it as ArrayList<PaymentOption>
                        } ?: banksList
                        val section =
                            AdapterViewSections.ErrorSection(
                                errorText = null
                            )
                        if (banksFilteredList.size == 0) {
                            if (upiCollectView == null) {
                                notifyItemRangeRemoved(sections.size, oldSize)
                                removeSections(section = section)
                                section.errorText = charSequence.toString()
                                addSection(section)
                            } else {
                                emptyListView = AdapterViewSections.ErrorSection(
                                    errorText = charSequence.toString()
                                )
                                notifyItemRangeRemoved(sections.size, oldSize)
                            }
                        } else {
                            if (upiCollectView == null) {
                                removeSections(section = section)
                                notifyItemRangeRemoved(sections.size, oldSize)
                            } else {
                                emptyListView = null
                                notifyItemRangeRemoved(sections.size, if (oldSize == 0) 1 else oldSize)
                            }
                            notifyItemRangeInserted(sections.size, banksFilteredList.size)
                        }
                    }

                    ListAdapterType.Offer -> {
                        offersFilteredList = filterResults.values as ArrayList<OfferInfo>
                        val section =
                            AdapterViewSections.ErrorSection(
                                errorText = null
                            )
                        if (offersFilteredList?.size == 0) {
                            removeSections(section = section)
                            section.errorText = charSequence.toString()
                            addSection(section)
                        } else removeSections(section = section)
                        notifyDataSetChanged()
                    }
                }
            }
        }
    }

}