package com.payu.ui.view.fragments.handlers

import android.view.View
import android.widget.TextView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.lifecycle.LifecycleOwner
import com.payu.ui.R
import com.payu.ui.viewmodel.CardBaseViewModel

class VerifyErrorHandler(private val cardBaseViewModel: CardBaseViewModel) {
    private var tvVerifyError: TextView? = null
    private var layoutVerifyError: ConstraintLayout? = null

    private var viewModel: CardBaseViewModel? = cardBaseViewModel

    fun init(view: View) {
        tvVerifyError = view.findViewById(R.id.tvVerifyError)
        layoutVerifyError = view.findViewById(R.id.layoutVerifyError)
    }

    fun addVerifyObserver(lifecycleOwner: LifecycleOwner) {
        viewModel?.showEligibleError?.observe(
            lifecycleOwner
        ) {
            if (it.isNullOrEmpty()) layoutVerifyError?.visibility = View.GONE
            else {
                layoutVerifyError?.visibility = View.VISIBLE
                tvVerifyError?.text = it
            }
        }
    }

    fun clear(){
        viewModel = null
    }
}