package com.payu.ui.view.fragments.handlers

import android.content.Context
import android.view.View
import android.view.View.GONE
import android.view.View.VISIBLE
import android.widget.EditText
import android.widget.ImageView
import android.widget.RelativeLayout
import android.widget.TextView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.content.ContextCompat
import androidx.core.widget.addTextChangedListener
import androidx.lifecycle.LifecycleOwner
import com.payu.base.listeners.OnFetchImageListener
import com.payu.base.models.ImageDetails
import com.payu.base.models.ImageParam
import com.payu.base.models.PaymentOption
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.utils.ImageViewUtils
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.ViewUtils
import com.payu.ui.model.widgets.MonitoringEditText
import com.payu.ui.view.CustomTextWatcher
import com.payu.ui.view.fragments.InputWatcher
import com.payu.ui.viewmodel.CardBaseViewModel
import com.payu.ui.viewmodel.EmiViewModel


open class CardUIHandler(private val cardBaseViewModel: CardBaseViewModel) : InputWatcher,View.OnFocusChangeListener {

    private var tvCardNumberLabel: TextView? = null
    private var etCardNumber : MonitoringEditText? = null
    private var etBajajCardNumber: EditText ? = null
    private var rlCardNumber: ConstraintLayout ? = null
    private var ivIssuerImage: ImageView? = null
    private var tvOfferText: TextView? = null
    private val cardDivider = 5
    private var cardTextWatcher: CustomTextWatcher? = null
    private var bajajCardTextWatcher: CustomTextWatcher? = null
    private var ivCameraImage : ImageView ? = null
    private var selectedPaymentOption: PaymentOption ? = null
    private val cardSeparator = " "

    internal fun initCardUI(view: View,isBajajCardNumber: Boolean = false){
        tvCardNumberLabel = view.findViewById(R.id.tvCardNumberLabel)
        etCardNumber = view.findViewById(R.id.et_add_card)
        rlCardNumber = view.findViewById(R.id.rlCardNumber)
        ivIssuerImage = view.findViewById(R.id.iv_issuer_image)
        tvOfferText = view.findViewById(R.id.tvOfferText)
        ivCameraImage = view.findViewById(R.id.iv_camera_image)
        etBajajCardNumber = view.findViewById(R.id.et_bajaj_card_no)
        if (isBajajCardNumber){
            etBajajCardNumber?.visibility = VISIBLE
            etCardNumber?.visibility = GONE
            ivIssuerImage?.visibility = GONE
        }
        etCardNumber?.let {
            cardTextWatcher = CustomTextWatcher(
                it,
                cardDivider,
                cardSeparator[0],
                this
            )
        }
        etBajajCardNumber?.let {
            bajajCardTextWatcher = CustomTextWatcher(
                it,
                cardDivider,
                cardSeparator[0],
                this
            )
        }
        etCardNumber?.addTextChangedListener(cardTextWatcher)
        etBajajCardNumber?.addTextChangedListener(bajajCardTextWatcher)
        initFocus(etCardNumber)
        initFocus(etBajajCardNumber)
        etCardNumber?.onFocusChangeListener = this

    }
    private fun updateCardNumberView(it: Boolean) {
        var alpha = 1f
        if (it) {
            alpha = 0.5f
            rlCardNumber?.setBackgroundResource(R.drawable.payu_rounded_corner_image_for_edittext)
            tvOfferText?.visibility = GONE
            etCardNumber?.text = null
        }
        etCardNumber?.alpha = alpha
        ivIssuerImage?.alpha = alpha
        tvCardNumberLabel?.alpha = alpha
        ivCameraImage?.alpha = alpha
    }

    internal fun addCardObserver(
        context: Context
    ) {
        cardBaseViewModel.cardNumberLabel.observe(context as LifecycleOwner) {
           tvCardNumberLabel?.text = it
        }
        cardBaseViewModel.cardError.observe(context as LifecycleOwner) {
            if (it == null) {
                if (etCardNumber?.hasFocus() == true)
                    ViewUtils.updateStrokeColor(
                        context,
                        rlCardNumber,
                        SdkUiInitializer.apiLayer?.config?.primaryColor,
                        R.color.one_payu_colorPrimary
                    )
                else ViewUtils.updateStrokeColor(context,rlCardNumber)
                tvOfferText?.visibility = GONE
            } else {
                ViewUtils.updateStrokeColor(
                    context,
                    rlCardNumber,
                    R.color.payu_color_de350b
                )
                tvOfferText?.text = it
                tvOfferText?.visibility = VISIBLE
                tvOfferText?.setTextColor(
                    ContextCompat.getColor(
                        context,
                        R.color.payu_color_de350b
                    )
                )
            }
        }
        cardBaseViewModel.cardScheme.observe(
            context as LifecycleOwner
        ) {
            if (null != it) {

                val param = ImageParam(
                    selectedPaymentOption!!,
                    true,
                    R.drawable.payu_cards_placeholder
                )
                SdkUiInitializer.apiLayer?.getImageForPaymentOption(
                    param,
                    object : OnFetchImageListener {
                        override fun onImageGenerated(result: ImageDetails) {
                            ImageViewUtils.setImage(ivIssuerImage, result)
                        }
                    })
            } else {
                ivIssuerImage?.setImageResource(R.drawable.payu_cards_placeholder)
            }
        }
        cardBaseViewModel.disableCardNumber.observe(
            context as LifecycleOwner
        ) {
            etCardNumber?.isEnabled = !it
            ivCameraImage?.isEnabled = !it
            updateCardNumberView(it)
        }
        cardBaseViewModel.highlightCardNumber.observe(context as LifecycleOwner) {
            if (it) {
                ViewUtils.updateStrokeColor(
                    context,
                    rlCardNumber,
                    SdkUiInitializer.apiLayer?.config?.primaryColor,
                    R.color.one_payu_colorPrimary
                )
            } else {
                ViewUtils.updateStrokeColor(context, rlCardNumber)
            }
        }
        cardBaseViewModel.cardNumberValid.observe(context as LifecycleOwner) {
            if (it) {
                rlCardNumber?.setBackgroundResource(R.drawable.payu_rounded_corner_image_for_edittext)
                cardBaseViewModel.validateOffer(SdkUiConstants.CP_EMI)
            }
        }
        cardBaseViewModel.selectedOption.observe(context as LifecycleOwner) {
            selectedPaymentOption = it
        }
        cardBaseViewModel.cardOffer.observe(context as LifecycleOwner) {
            if (!it.isNullOrEmpty()) {
                rlCardNumber?.setBackgroundResource(R.drawable.payu_rounded_corner_image_for_edittext)
                tvOfferText?.text = it
                tvOfferText?.visibility = VISIBLE
                tvOfferText?.setTextColor(
                    ContextCompat.getColor(
                        context,
                        R.color.payu_color_36b37e
                    )
                )
            } else {
                tvOfferText?.visibility = GONE
            }
        }
    }

    override fun onInputReceived(input: String, inputType: Int) {
        when (inputType) {
            R.id.et_add_card -> {
                cardBaseViewModel.cardNumber = input
            }

            R.id.et_bajaj_card_no -> {
                (cardBaseViewModel as EmiViewModel).bajajCardNumber = input
            }
        }
    }
    private fun initFocus(view: View?) {
        view?.requestFocus()
        if (view?.id == R.id.et_add_card)
            cardBaseViewModel.cardNumberFocused(true)
        if (view != null) {
            ViewUtils.showSoftKeyboard(view)
        }
    }

    override fun onFocusChange(v: View?, hasFocus: Boolean) {
        cardBaseViewModel.cardNumberFocused(hasFocus)
    }
}