package com.payu.ui.view.fragments

import android.content.Context
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import android.widget.ImageView
import android.widget.TextView
import androidx.fragment.app.Fragment
import androidx.lifecycle.ViewModelProvider
import com.payu.ui.R
import com.payu.ui.model.utils.SdkUiConstants.PAYU_PAYMENT_STATUS
import com.payu.ui.model.models.PaymentStatus
import com.payu.ui.viewmodel.PaymentOptionViewModel

private class ResultFragment : Fragment() {
    private var paymentStatus: PaymentStatus? = null
    private var paymentOptionViewModel: PaymentOptionViewModel? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        arguments?.let {
            paymentStatus = it.getSerializable(PAYU_PAYMENT_STATUS) as PaymentStatus?
        }
    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        val view = inflater.inflate(R.layout.fragment_result, container, false)
        initViewModel()
        updateView(view)
        return view
    }

    private fun initViewModel() {

        /**
         * We will create ViewModel instance in the fragment using the activity scope so
         * that it will be available for all the fragment of the activity including activity itself.
         * */

        paymentOptionViewModel = activity?.run {
            ViewModelProvider(this)[PaymentOptionViewModel::class.java]
        } ?: throw Exception("Invalid Activity")

        paymentOptionViewModel?.hideBottomFooter?.value = true
        paymentOptionViewModel?.hideBackNavigation?.value = true
        paymentOptionViewModel?.expandToolbar?.value = true
    }

    private fun updateView(view: View) {
        when (paymentStatus) {
            PaymentStatus.SUCCESS -> showSuccessView(view)
            PaymentStatus.FAILED -> showFailedView(view)
            PaymentStatus.CANCELLED -> showCancelledView(view)
            else -> {}
        }

    }

    private fun showSuccessView(view: View) {
        view.findViewById<TextView>(R.id.tvResultStatus).text =
            resources.getString(R.string.payu_congratulations)
        view.findViewById<TextView>(R.id.tvResultText).text =
            resources.getString(R.string.payu_your_order_was_completed_successfully)
        view.findViewById<ImageView>(R.id.ivResult)
            .setImageDrawable(resources.getDrawable(R.drawable.payu_payment_success))
        handleButton(view)
    }

    private fun showFailedView(view: View) {
        view.findViewById<TextView>(R.id.tvResultStatus).text =
            resources.getString(R.string.payu_your_order_was_not_completed)
        view.findViewById<TextView>(R.id.tvResultText).text =
            resources.getString(R.string.payu_we_were_unable_to_confirm_your_payment)
        view.findViewById<ImageView>(R.id.ivResult)
            .setImageDrawable(resources.getDrawable(R.drawable.payu_payment_fail))
        handleButton(view)
    }

    private fun showCancelledView(view: View) {
        view.findViewById<TextView>(R.id.tvResultStatus).text =
            resources.getString(R.string.payu_payment_cancelled)
        view.findViewById<TextView>(R.id.tvResultText).text =
            resources.getString(R.string.payu_you_have_canceled_the_payment)
        view.findViewById<ImageView>(R.id.ivResult)
            .setImageDrawable(resources.getDrawable(R.drawable.payu_payment_fail))
        handleButton(view)
    }

    private fun handleButton(view: View) {
        view.findViewById<Button>(R.id.btnContinueShopping).setOnClickListener {
            paymentOptionViewModel?.continueShoppingClicked(paymentStatus!!)
        }
    }

    companion object {
        /**
         * Use this factory method to create a new instance of
         * this fragment using the provided parameters.
         *
         * @param paymentStatus status of transaction
         * @return A new instance of fragment ResultFragment.
         */
        @JvmStatic
        fun newInstance(paymentStatus: PaymentStatus) =
            ResultFragment().apply {
                arguments = Bundle().apply {
                    putSerializable(PAYU_PAYMENT_STATUS, paymentStatus)
                }
            }
    }
}
