package com.payu.ui.view.fragments

import android.graphics.drawable.Drawable
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.EditText
import android.widget.ImageView
import android.widget.RelativeLayout
import android.widget.ScrollView
import android.widget.TextView
import androidx.appcompat.content.res.AppCompatResources
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.content.res.ResourcesCompat
import androidx.core.view.isVisible
import androidx.fragment.app.Fragment
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.payu.base.listeners.VerifyServiceListener
import com.payu.base.models.ApiResponse
import com.payu.base.models.BnplOption
import com.payu.base.models.BottomSheetType
import com.payu.base.models.InternalConfig
import com.payu.base.models.PaymentMode
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentType
import com.payu.base.models.UPIOption
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.adapters.HorizontalTilesAdapter
import com.payu.ui.model.adapters.OtherPaymentOptionsAdapter
import com.payu.ui.model.adapters.QuickOptionsAdapter
import com.payu.ui.model.adapters.RecommendedOptionAdapter
import com.payu.ui.model.listeners.BottomSheetValidateApiListener
import com.payu.ui.model.listeners.BottomSheetValidateResultListener
import com.payu.ui.model.listeners.BottomSheetVerificationListener
import com.payu.ui.model.listeners.OfferApplyListener
import com.payu.ui.model.listeners.OnOtherPaymentOptionsAdapterListener
import com.payu.ui.model.listeners.ValidateOfferResultListener
import com.payu.ui.model.listeners.VerificationResultListener
import com.payu.ui.model.managers.ClwBottomSheetHandler
import com.payu.ui.model.managers.OfferFilterManager
import com.payu.ui.model.models.VerificationResult
import com.payu.ui.model.utils.AnalyticsConstant
import com.payu.ui.model.utils.AnalyticsUtils
import com.payu.ui.model.utils.AnalyticsUtils.getCTANameValueForPaymentType
import com.payu.ui.model.utils.MultipleClickHandler
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.Utils
import com.payu.ui.model.utils.ViewUtils
import com.payu.ui.model.widgets.RoundedCornerBottomSheet
import com.payu.ui.view.customViews.BNPLAndUPIBottomSheet
import com.payu.ui.view.customViews.OfferAppliedDialog
import com.payu.ui.viewmodel.PaymentOptionViewModel

class PaymentOptionFragment : Fragment(), View.OnClickListener, BottomSheetValidateApiListener,
    QuickOptionsAdapter.OnQuickOptionAdapterListener, OfferApplyListener,
    OnOtherPaymentOptionsAdapterListener {

    private val TAG = "PaymentOptionFragment"
    private var paymentOptionViewModel: PaymentOptionViewModel? = null
    private var rlQuickOptions: ConstraintLayout? = null
    private var llQuickOptions: ConstraintLayout? = null
    private var llUnlockSavedOptionsGlobalVault: ConstraintLayout? = null
    private var llOtherOptions: ConstraintLayout? = null
    private var tvUnlockSavedOptionsResultInfo: ImageView? = null
    private var ivGlobalSettings: ImageView? = null
    private var clUnlockSavedOptions: ConstraintLayout? = null
    private var rvQuickOptions: RecyclerView? = null
    private var rvOtherOptions: RecyclerView? = null
    private var svCheckoutOptions: ScrollView? = null
    private var rlCheckoutOptions: ConstraintLayout? = null
    private var tvViewAll: TextView? = null
    private var tvSISummary: TextView? = null
    private var tvOfferTitle: TextView? = null
    private var tvOfferDetails: TextView? = null
    private var tvOfferDisc: TextView? = null
    private var tvRemoveOfferButton: TextView? = null
    private var changeOfferOption: ConstraintLayout? = null
    private var fetchApiCalledTimeStamp: Long? = null
    private var roundedCornerBottomSheet: RoundedCornerBottomSheet? = null
    private var rlGlobalVaultTitle: RelativeLayout? = null
    private var tvUnlockSavedOptionsResult: TextView? = null
    private var rvRecommendedOptions: RecyclerView? = null

    private var tvGlobalVaultPhoneNumber: TextView? = null
    private var llRecommendationList: ConstraintLayout? = null
    private var moreOptionsListObserved: ArrayList<PaymentMode>? = ArrayList()
    private var moreOptionsList: ArrayList<PaymentMode> = ArrayList()
    private var gvrlPhoneSettingLayout: ConstraintLayout? = null
    private var rlGvUnlockSavedOptions: RelativeLayout? = null
    private var ivGvUnlockSavedOptionsResultInfo: ImageView? = null
    private var tilesCount: Int = 0
    private var savedOptionCount: Int = 0
    private var loggedIn: Boolean = false
    private var unlockedOptionShown: Boolean = false
    private var savedOptionsViewAllState: Boolean = false
    private var onValidateOfferResultListener: ValidateOfferResultListener? = null
    private var bsResultListener: BottomSheetValidateResultListener? = null
    private var quickOptionList: ArrayList<PaymentMode> = ArrayList()
    private var quickOptionsAdapter: QuickOptionsAdapter? = null
    private var ivManageOption: ImageView? = null
    private var tvTpvInfo: TextView? = null
    private var clTpvSummaryLayout: ConstraintLayout? = null
    private var clSISummaryLayout: ConstraintLayout? = null
    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?
    ): View? {
        return inflater.inflate(R.layout.checkout_payment_options, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        svCheckoutOptions = view.findViewById(R.id.svCheckoutOptions)
        llQuickOptions = view.findViewById(R.id.ll_quick_options)
        rlQuickOptions = view.findViewById(R.id.rlQuickOptionLayout)
        llUnlockSavedOptionsGlobalVault = view.findViewById(R.id.llSavedOptionsGlobalVaultResult)
        llOtherOptions = view.findViewById(R.id.ll_other_options)
        clUnlockSavedOptions = view.findViewById(R.id.clUnlockSavedOptions)
        rvQuickOptions = view.findViewById(R.id.rv_quick_options)
        rvQuickOptions?.layoutManager =
            LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false)
        rvOtherOptions = view.findViewById(R.id.rv_other_options)
        rvOtherOptions?.layoutManager = LinearLayoutManager(context)
        tvUnlockSavedOptionsResultInfo = view.findViewById(R.id.tvGvUnlockSavedOptionsResultInfo)
        tvUnlockSavedOptionsResultInfo?.setOnClickListener(this)
        ivGlobalSettings = view.findViewById(R.id.ivGvSettings)
        ivGlobalSettings?.setOnClickListener(this)
        rlGlobalVaultTitle = view.findViewById(R.id.rlGlobalVaultTitle)
        tvUnlockSavedOptionsResult = view.findViewById(R.id.tvUnlockSavedOptionsResult)
        rlGvUnlockSavedOptions?.setOnClickListener(this)
        ivGvUnlockSavedOptionsResultInfo?.setOnClickListener(this)
        rlCheckoutOptions = view.findViewById(R.id.rlCheckoutOptions)
        tvViewAll = view.findViewById(R.id.tvViewAll)
        tvViewAll?.setOnClickListener(this)
        rlCheckoutOptions?.visibility = View.GONE //hide rlCheckoutOptions initially
        tvSISummary = view.findViewById(R.id.tv_si_summary_title)
        tvOfferTitle = view.findViewById(R.id.tvOfferTitle)
        tvOfferDetails = view.findViewById(R.id.tvOfferDetails)
        tvOfferDisc = view.findViewById(R.id.tvOfferDisc)
        tvRemoveOfferButton = view.findViewById(R.id.tvRemoveOfferButton)
        changeOfferOption = view.findViewById(R.id.changeOfferOption)
        tvRemoveOfferButton?.setOnClickListener(this)
        rvRecommendedOptions = view.findViewById(R.id.rvrecommendedoptions)
        tvGlobalVaultPhoneNumber = view.findViewById(R.id.tvGlobalVaultPhoneNumber)
        tvGlobalVaultPhoneNumber?.setOnClickListener(this)
        llRecommendationList = view.findViewById(R.id.inrecommendedoption)
        llRecommendationList?.setOnClickListener(this)
        tvOfferDetails?.setOnClickListener(this)
        rvRecommendedOptions?.layoutManager =
            LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false)
        gvrlPhoneSettingLayout = view.findViewById(R.id.phonesettinglayout)
        ivManageOption = view.findViewById(R.id.ivManageOption)
        tvTpvInfo = view.findViewById(R.id.tvTpvInfo)
        clTpvSummaryLayout = view.findViewById(R.id.tpv_summary_layout)
        clSISummaryLayout = view.findViewById(R.id.siSummary)
        ivManageOption?.setOnClickListener {
            val payuSavedOptionFragment = SavedOptionFragment.newInstance(
                paymentOptionViewModel?.quickOptions?.value,
            )
            paymentOptionViewModel?.loadFragment(payuSavedOptionFragment, null)
        }
        initViewModel()
        addObservers()
    }

    private fun showSavedCards() {
        if (activity != null && !requireActivity().isDestroyed && !requireActivity().isFinishing) {
            val payUSavedCardsFragment = PayUSavedCardsFragment.newInstance(
                paymentOptionViewModel?.quickOptions?.value,
                true,
                context?.getString(R.string.payu_view_all)!!
            )
            paymentOptionViewModel?.loadFragment(payUSavedCardsFragment, null)
            AnalyticsUtils.logCheckoutL1CTAClickEvent(
                requireActivity().applicationContext,
                SdkUiConstants.CP_MANAGE_CARDS,
                SdkUiConstants.CP_QUICK_OPTIONS
            )
        }

    }

    override fun onClick(v: View?) {
        when (v?.id) {
            R.id.tvViewAll -> {
                if (activity != null && !requireActivity().isDestroyed && !requireActivity().isFinishing) {
                    savedOptionsViewAllState =
                        tvViewAll?.text.toString() == context?.getString(R.string.payu_view_all)
                    paymentOptionViewModel?.quickOptions?.value?.let {
                        savedOptionsListViewHandler(
                            savedOptionsViewAllState,
                            it
                        )
                    }
                    AnalyticsUtils.logCheckoutL1CTAClickEvent(
                        requireActivity().applicationContext,
                        SdkUiConstants.CP_VIEW_ALL,
                        SdkUiConstants.CP_QUICK_OPTIONS
                    )
                }
                paymentOptionViewModel?.showChangeOfferView(false)
            }

            R.id.tvRemoveOfferButton -> {
                InternalConfig.userSelectedOfferInfo = null
                paymentOptionViewModel?.showChangeOfferView(false)
                paymentOptionViewModel?.updateRecommendedAndQuickPaymentListBasedOnOffers()
            }

            R.id.tvGvUnlockSavedOptionsResultInfo -> {
                paymentOptionViewModel?.showBottomSheetGlobalVaultInfo()
            }

            R.id.tvGlobalVaultPhoneNumber,
            R.id.ivGvSettings -> {
                paymentOptionViewModel?.showBottomSheetGlobalVaultSettings()

            }

            R.id.tvOfferDetails -> {
                paymentOptionViewModel?.showSkuBottomSheet(true)
            }
        }
    }

    private fun initViewModel() {

        /**
         * We will create ViewModel instance in the fragment using the activity scope so
         * that it will be available for all the fragment of the activity including activity itself.
         * */

        paymentOptionViewModel = activity?.run {
            ViewModelProvider(this)[PaymentOptionViewModel::class.java]
        } ?: throw Exception("Invalid Activity")
        paymentOptionViewModel?.setScreenName(SdkUiConstants.CP_L1_CHECKOUT_SCREEN)
    }

    private fun addObservers() {

        paymentOptionViewModel?.quickOptions?.observe(
            viewLifecycleOwner
        ) { quickOptionsList ->
            this.quickOptionList.clear()
            ivManageOption?.isVisible = Utils.isListHasItemsWithoutSodexoAndClw(quickOptionsList)
            if (quickOptionsList.isNullOrEmpty()) {
                rlQuickOptions?.visibility = View.GONE
                rvQuickOptions?.visibility = View.GONE
                tvViewAll?.visibility = View.GONE
                rlGlobalVaultTitle?.visibility = View.GONE

            } else {
                rlQuickOptions?.visibility = View.VISIBLE
                rvQuickOptions?.visibility = View.VISIBLE
                this.quickOptionList.addAll(quickOptionsList)
                rlGlobalVaultTitle?.visibility = View.VISIBLE
                if (InternalConfig.userSelectedOfferInfo != null) quickOptionsAdapter = null
                savedOptionsListViewHandler(savedOptionsViewAllState, quickOptionsList)
                AnalyticsUtils.logGvDataShown(
                    requireContext(),
                    AnalyticsConstant.CP_GV_DATA_SHOWN,
                    tilesCount,
                    loggedIn,
                    unlockedOptionShown,
                    savedOptionCount
                )
                AnalyticsUtils.logGVDataForKibana(
                    requireContext(),
                    AnalyticsConstant.CP_GV_DATA_SHOWN,
                    tilesCount,
                    savedOptionCount,
                    unlockedOptionShown,
                    loggedIn
                )
            }
            if (!Utils.getGlobalVaultStoredUserToken(requireContext()).first.isNullOrEmpty()) {
                val storedVal = Utils.getGlobalVaultStoredUserToken(requireContext())
                tvGlobalVaultPhoneNumber?.text = storedVal.second
//                gvrlPhoneSettingLayout?.visibility = View.VISIBLE
                loggedIn = true
                if (!quickOptionsList.isNullOrEmpty())
                    savedOptionCount = quickOptionsList.size
            }
        }

        paymentOptionViewModel?.fetchApiCalledTimeStamp?.observe(viewLifecycleOwner) {
            fetchApiCalledTimeStamp = it
        }

        paymentOptionViewModel?.otherOptions?.observe(
            viewLifecycleOwner
        ) { otherOptionsList ->

            if (otherOptionsList == null) {
                llOtherOptions?.visibility = View.GONE
                //TODO move with saved option and moreOptions common check
//                if (activity != null && !requireActivity().isFinishing && !requireActivity().isDestroyed) {
//                    activity?.finish() //finish the activity if no payment option are enabled
//                }

            } else {
                llOtherOptions?.visibility = View.VISIBLE
                moreOptionsList.clear()
                moreOptionsList.addAll(otherOptionsList)
                rlCheckoutOptions?.visibility = View.VISIBLE
                rvOtherOptions?.adapter =
                    OtherPaymentOptionsAdapter(
                        otherOptionList = otherOptionsList,
                        childFragmentManager = childFragmentManager,
                        onOtherPaymentOptionsAdapterListener = this,
                        offerApplyListener = this,
                        bottomSheetValidateApiListener = this
                    )
                context?.let {
                    AnalyticsUtils.logCheckoutScreenLoadedEvent(it, fetchApiCalledTimeStamp)
                }

            }
        }

        paymentOptionViewModel?.refreshPaymentModesForOffers?.observe(viewLifecycleOwner) { value ->
            rvOtherOptions?.adapter?.notifyDataSetChanged()
        }

        paymentOptionViewModel?.siHeaderSummary?.observe(viewLifecycleOwner) { value ->
            clSISummaryLayout?.visibility = View.VISIBLE
            tvSISummary?.visibility = View.VISIBLE
            tvSISummary?.text = value
        }

        paymentOptionViewModel?.moreOptionsListLiveData?.observe(viewLifecycleOwner) { value ->
            this.moreOptionsListObserved = value
        }
        paymentOptionViewModel?.showChangeOfferView?.observe(viewLifecycleOwner) { value ->
            if (value || InternalConfig.selectedOfferInfo?.isValid == true) {
                InternalConfig.userSelectedOfferInfo?.let {
                    val filteredMoreOption =
                        OfferFilterManager.filterPaymentMode(it, moreOptionsListObserved)
                    if (filteredMoreOption.isNotEmpty()) {
                        paymentOptionViewModel?.showMoreOptionList(filteredMoreOption)
                    } else {
                        paymentOptionViewModel?.updateL1ForEmptyList(false)
                    }
                }
                changeOfferOption?.visibility = View.VISIBLE
                val offerKeySet = HashSet<String>()
                InternalConfig.selectedOfferInfo?.offerMap?.values?.forEach {
                    it.offerKey?.let { it1 -> offerKeySet.add(it1) }
                }
                val length = offerKeySet.size
                if (length > 1) {
                    tvOfferTitle?.text = requireContext().getString(
                        R.string.payu_offer_applied_text,
                        length.toString()
                    )
                    tvOfferDisc?.visibility = View.GONE
                } else if (length == 1) {
                    val offerKey = InternalConfig.selectedOfferInfo?.offerMap?.keys?.first()
                    tvOfferTitle?.text =
                        InternalConfig.selectedOfferInfo?.offerMap?.get(offerKey)?.title
                    tvOfferDisc?.visibility = View.VISIBLE
                    tvOfferDisc?.text =
                        InternalConfig.selectedOfferInfo?.offerMap?.get(offerKey)?.description
                } else changeOfferOption?.visibility = View.GONE
                if (InternalConfig.selectedOfferInfo?.isSkuOffer == true) tvOfferDetails?.visibility =
                    View.VISIBLE else tvOfferDetails?.visibility = View.GONE
            } else {
                paymentOptionViewModel?.resetMorePaymentOptionsList()
                changeOfferOption?.visibility = View.GONE
                if (!InternalConfig.isRetryTxn)
                    paymentOptionViewModel?.showMoreOptionList(
                        moreOptionsListObserved
                    )
            }

        }

        paymentOptionViewModel?.hideBottomSheet?.observe(viewLifecycleOwner) {
            if (it) {
                roundedCornerBottomSheet?.dismiss()
                InternalConfig.isPaymentOptionSelected = false
            }
        }


        paymentOptionViewModel?.gvLoadGlobalVaultData?.observe(viewLifecycleOwner) {
            if (it) {
                tvUnlockSavedOptionsResult?.visibility = View.VISIBLE
                llUnlockSavedOptionsGlobalVault?.visibility = View.VISIBLE
            } else {
                tvUnlockSavedOptionsResult?.visibility = View.GONE
                llUnlockSavedOptionsGlobalVault?.visibility = View.GONE
            }
        }


        paymentOptionViewModel?.gvPayuNoSavedOptions?.observe(viewLifecycleOwner) {
            if (it) {
                tvUnlockSavedOptionsResult?.visibility = View.VISIBLE
                tvUnlockSavedOptionsResult?.text =
                    context?.getString(R.string.payu_no_saved_options)
                llUnlockSavedOptionsGlobalVault?.visibility = View.VISIBLE
            } else {
                llUnlockSavedOptionsGlobalVault?.visibility = View.GONE
                rlQuickOptions?.visibility = View.VISIBLE
                rvQuickOptions?.visibility = View.VISIBLE
                tvUnlockSavedOptionsResult?.visibility = View.GONE
            }

        }

        paymentOptionViewModel?.logoutFromGlobalVault?.observe(viewLifecycleOwner) {
            paymentOptionViewModel?.showUnlockSavedOptionsGlobalVault()
            llUnlockSavedOptionsGlobalVault?.visibility = View.GONE
            tvUnlockSavedOptionsResult?.visibility = View.GONE
            tvUnlockSavedOptionsResultInfo?.visibility = View.GONE
            val eventData = HashMap<String, Any>()
            AnalyticsUtils.logData(requireContext(), AnalyticsConstant.CP_LOGOUT_CLICKED, eventData)
        }
        paymentOptionViewModel?.manage?.observe(viewLifecycleOwner) {
            if (it) {
                showSavedCards()
            }
        }
        paymentOptionViewModel?.recommendedOptions?.observe(viewLifecycleOwner) {
            it?.let { list ->
                showRecommendedOptions(list)
            }
        }

        paymentOptionViewModel?.showUnlockOption?.observe(viewLifecycleOwner) {
            if (it) {
                rlGlobalVaultTitle?.visibility = View.GONE
                llUnlockSavedOptionsGlobalVault?.visibility = View.GONE
                unlockedOptionShown = true
            }
        }

        paymentOptionViewModel?.showLoginPhoneLayout?.observe(viewLifecycleOwner) {
            if (it) {
                gvrlPhoneSettingLayout?.visibility = View.VISIBLE
            } else {
                gvrlPhoneSettingLayout?.visibility = View.GONE
            }
        }

        paymentOptionViewModel?.showClwLoadAndPayBottomSheet?.observe(viewLifecycleOwner) {
            if (it.first.getContentIfNotHandled() == true) {
                val sodexoCardOption = it.second
                val onPaymentInitiated: (Double) -> Unit = { loadAmount ->
                    if (MultipleClickHandler.isSafeOnClickListener()) {
                        sodexoCardOption?.let {
                            sodexoCardOption.loadAmount = loadAmount.toString()
                            paymentOptionViewModel?.makePayment(sodexoCardOption)
                        }
                    }
                }
                sodexoCardOption?.balance?.let {
                    SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDoubleOrNull()
                        ?.let { it1 ->

                            val clwBottomSheetHandler = ClwBottomSheetHandler(
                                context, onPaymentInitiated, sodexoCardOption.bankName,
                                it, it1.toString()
                            )

                            val roundedCornerBottomSheet = RoundedCornerBottomSheet.newInstance(
                                R.layout.load_and_pay_bottom_sheet,
                                clwBottomSheetHandler
                            )
                            childFragmentManager?.let {
                                roundedCornerBottomSheet?.show(
                                    childFragmentManager,
                                    SdkUiConstants.CP_BOTTOM_SHEET_FRAGMENT
                                )
                            }
                        }
                }
            }
        }

        paymentOptionViewModel?.showOfferApplied?.observe(viewLifecycleOwner) {
            (it.getContentIfNotHandled())?.let { it1 ->
                paymentOptionViewModel?.showChangeOfferView(
                    shouldShowChangeOffer = it1
                )
            }
        }

        paymentOptionViewModel?.showOfferAppliedDialog?.observe(viewLifecycleOwner) {
            if (it.getContentIfNotHandled() == true) {
                onValidateOfferResultListener?.onValidateOfferResponse(true)
                bsResultListener?.onValidateResultListener(true)
                val offerAppliedDialog = OfferAppliedDialog(requireContext())
                offerAppliedDialog.showOfferDialog(paymentOptionViewModel?.selectedPaymentOption)
            }

        }

        paymentOptionViewModel?.showErrorWithSnackBar?.observe(viewLifecycleOwner) {
            if (it.first.getContentIfNotHandled() == true) {
                ViewUtils.showSnackBar(
                    it.second
                        ?: requireContext().getString(R.string.payu_please_try_another_payment),
                    R.drawable.verification, requireActivity(),
                    R.color.payu_color_FCE9E9
                )
            }
        }


        paymentOptionViewModel?.showOfferError?.observe(viewLifecycleOwner) {
            if (it.first.getContentIfNotHandled() == true) {
                onValidateOfferResultListener?.onValidateOfferResponse(false)
                InternalConfig.selectedOfferInfo?.let {
                    ViewUtils.showSnackBar(
                        InternalConfig.selectedOfferInfo?.failureReason
                            ?: requireContext().getString(R.string.payu_offer_not_applicable_on_this),
                        R.drawable.verification, requireActivity(),
                        R.color.payu_color_FCE9E9
                    )
                }
            }
        }
        paymentOptionViewModel?.isOfferAvailable?.observe(viewLifecycleOwner) {
            for (paymentMode in moreOptionsList) {
                paymentMode.type?.let {
                    paymentMode.isOfferValid =
                        (InternalConfig.userSelectedOfferInfo != null) && Utils.isOfferAvailableInPaymentType(
                            it
                        )
                }
            }

        }
        paymentOptionViewModel?.showTpvTiles?.observe(viewLifecycleOwner) {
            if (it) {
                llRecommendationList?.visibility = View.VISIBLE
                clTpvSummaryLayout?.visibility = View.VISIBLE
                tvTpvInfo?.text = requireContext().getString(R.string.payu_tpv_info_summary)
                val tilesDataList = paymentOptionViewModel?.getTilesList() ?: arrayListOf()
                val horizontalTilesAdapter = HorizontalTilesAdapter(tilesDataList)
                rvRecommendedOptions?.adapter = horizontalTilesAdapter
            }
        }

        paymentOptionViewModel?.showConsentPopup?.observe(viewLifecycleOwner){
            if(it.getContentIfNotHandled() == true)
                showConsentBottomSheet()
        }
    }

    private fun showQuickOptions(quickOptionsList: ArrayList<PaymentMode>) {
        clUnlockSavedOptions?.visibility = View.GONE
        rlQuickOptions?.visibility = View.VISIBLE
        rvQuickOptions?.layoutManager =
            LinearLayoutManager(context, LinearLayoutManager.VERTICAL, false)
        if (quickOptionsAdapter == null)
            quickOptionsAdapter = QuickOptionsAdapter(
                quickOptionsList,
                this
            ) else quickOptionsAdapter?.quickOptionList = quickOptionsList
        rvQuickOptions?.adapter = quickOptionsAdapter
    }


    private fun showRecommendedOptions(
        list: ArrayList<PaymentMode>?,
    ) {
        if (Utils.isSiTxn() || (SdkUiInitializer.apiLayer?.config?.enableREOptions == false && InternalConfig.isQuickPayEnabled.not() && InternalConfig.isUserPersonalizedOffersAvailable.not()))
            return

        val reList = ArrayList<PaymentMode>()
        val loginTextAndSubtitle = paymentOptionViewModel?.getLoginTileTexts()
        if (isUnlockOptionsVisible() && loginTextAndSubtitle != null) {
            val paymentMode = PaymentMode()
            paymentMode.name = loginTextAndSubtitle.first
            paymentMode.l1OptionSubText = loginTextAndSubtitle.second
            val optionDetail: ArrayList<PaymentOption> = ArrayList()
            val recommendedSavedOptions = PaymentOption()
            optionDetail.add(recommendedSavedOptions)
            paymentMode.optionDetail = optionDetail
            paymentMode.isGlobalVaultPaymentMode = true
            paymentMode.unlockOptionsTile = true
            reList.add(paymentMode)
        }

        if (list != null && SdkUiInitializer.apiLayer?.config?.enableREOptions == true) {
            reList.addAll(list)
        }
        if (reList.isEmpty()) llRecommendationList?.visibility = View.GONE
        else {
            llRecommendationList?.visibility = View.VISIBLE
            tilesCount = reList.size - 1
        }
        val adapter = paymentOptionViewModel?.let {
            RecommendedOptionAdapter(
                reList
            )
        }
        rvRecommendedOptions?.adapter = adapter
        adapter?.onItemClickListener = { view, paymentMode, position ->
            activity?.let {
                if (ViewUtils.isInternetAvailable(it)) {
                    val bottomSheet =
                        BNPLAndUPIBottomSheet.Builder(
                            childFragmentManager,
                            TAG
                        ).setTitle(paymentMode.name).setBottomSheetType(BottomSheetType.L1_BOTTOM_SHEET).setOfferApplyListener(this)
                    if (paymentMode.type != null) {
                        getCTANameValueForPaymentType(paymentMode.type!!)?.let {
                            AnalyticsUtils.logTilesData(
                                this.requireContext(),
                                it,
                                AnalyticsConstant.CP_TILES_VIEW_CLICKED,
                                loggedIn,
                                position
                            )
                        }

                        getCTANameValueForPaymentType(paymentMode.type!!)?.let {
                            AnalyticsUtils.logTilesDataForKibana(
                                this.requireContext(),
                                it,
                                AnalyticsConstant.CP_TILES_VIEW_CLICKED,
                                position,
                                loggedIn
                            )
                        }
                    } else {
                        AnalyticsUtils.logTilesData(
                            this.requireContext(),
                            AnalyticsConstant.CP_UNLOCK_SAVED_OPTION,
                            AnalyticsConstant.CP_TILES_VIEW_CLICKED,
                            loggedIn,
                            position
                        )

                        AnalyticsUtils.logTilesDataForKibana(
                            this.requireContext(),
                            AnalyticsConstant.CP_UNLOCK_SAVED_OPTION,
                            AnalyticsConstant.CP_TILES_VIEW_CLICKED,
                            position,
                            loggedIn
                        )
                    }
                    when (paymentMode.type) {
                        PaymentType.UPI -> {
                            val paymentOption = paymentMode.optionDetail?.get(0)
                            val upiIcon: Drawable? = context?.resources?.let {
                                ResourcesCompat.getDrawable(
                                    it, R.drawable.powered_by_upi, null
                                )
                            }
                            val upiOption: UPIOption =
                                paymentMode.optionDetail?.get(0) as UPIOption
                            bottomSheet.setUPI("", null, false).setEditView(true)
                                .setHint(context?.getString(R.string.payu_enter_vpa_id)!!)
                                .setVerifyListener(object :
                                    BottomSheetVerificationListener {
                                    override fun onClick(
                                        v: View?,
                                        verificationResultListener: VerificationResultListener
                                    ) {
                                        ViewUtils.hideSoftKeyboardFromToken(
                                            requireActivity(),
                                            v
                                        )
                                        val vpa = v?.findViewById<EditText>(R.id.etPhoneAndUPI)
                                        upiOption.vpa = vpa?.text.toString()
                                        upiOption.category = null
                                        SdkUiInitializer.apiLayer?.verifyEligibilityAPI(
                                            upiOption,
                                            object : VerifyServiceListener {
                                                override fun eligibilityDetails(apiResponse: ApiResponse) {
                                                    val verificationResult =
                                                        apiResponse.status?.let {
                                                            VerificationResult(
                                                                it,
                                                                apiResponse.errorMessage,
                                                                apiResponse.successMessage
                                                            )
                                                        }
                                                    if (verificationResult != null) {
                                                        verificationResultListener.onResult(
                                                            verificationResult
                                                        )
                                                    }
                                                }
                                            })
                                    }
                                }).setProceedListener {
                                    ViewUtils.hideSoftKeyboard(requireActivity())
                                    SdkUiInitializer.apiLayer?.updatePaymentState(
                                        Utils.getPaymentModel(
                                            upiOption,
                                            null
                                        ), ViewUtils.getToolbar(
                                            requireContext(),
                                            upiOption.additionalCharge
                                        )
                                    )
                                    getCTANameValueForPaymentType(PaymentType.UPI)?.let { it1 ->
                                        AnalyticsUtils.logTilesData(
                                            requireContext(),
                                            it1,
                                            AnalyticsConstant.CP_TILES_PROCEED_CLICKED,
                                            loggedIn,
                                            position
                                        )
                                        AnalyticsUtils.logTilesDataForKibana(
                                            requireContext(),
                                            it1,
                                            AnalyticsConstant.CP_TILES_PROCEED_CLICKED,
                                            position,
                                            loggedIn
                                        )
                                    }
                                }.setIcon(upiIcon!!)
                            bottomSheet
                                .setPaymentOption(paymentOption)
                                .setValidateApiListener(this)
                                .build().show()
                        }

                        PaymentType.WALLET, PaymentType.NB -> {
                            val paymentOption = paymentMode.optionDetail?.get(0)
                            bottomSheet.setMessage(paymentMode.l1OptionSubText!!)
                                .setIcon(paymentOption?.imageURL).setProceedListener {
                                    ViewUtils.hideSoftKeyboard(requireActivity())
                                    paymentOption?.let {
                                        Utils.getPaymentModel(
                                            it,
                                            null
                                        )
                                    }?.let {
                                        SdkUiInitializer.apiLayer?.updatePaymentState(
                                            it, ViewUtils.getToolbar(
                                                requireContext(),
                                                paymentOption.additionalCharge
                                            )
                                        )
                                    }
                                    paymentMode.type?.let { type ->
                                        getCTANameValueForPaymentType(type)?.let { ctaName ->
                                            AnalyticsUtils.logTilesData(
                                                requireContext(),
                                                ctaName,
                                                AnalyticsConstant.CP_TILES_PROCEED_CLICKED,
                                                loggedIn,
                                                position
                                            )
                                            AnalyticsUtils.logTilesDataForKibana(
                                                requireContext(),
                                                ctaName,
                                                AnalyticsConstant.CP_TILES_PROCEED_CLICKED,
                                                position,
                                                loggedIn
                                            )
                                        }
                                    }
                                }
                            bottomSheet
                                .setPaymentOption(paymentOption)
                                .setValidateApiListener(this)
                                .build().show()
                        }

                        PaymentType.BNPL -> {
                            val paymentOption = paymentMode.optionDetail?.get(0) as BnplOption
                            val phoneNumber = paymentOptionViewModel?.getLoggedInPhoneNumber() ?: paymentOptionViewModel?.vaultVerificationPhoneNumber
                            phoneNumber?.let {
                                paymentOption.imageURL?.let { it1 ->
                                    bottomSheet.setNumber(
                                        it, paymentOption.isEligible == true
                                    ).setEditView(paymentOption.isEligible == true).setIcon(it1)
                                        .setVerifyListener(object :
                                            BottomSheetVerificationListener {
                                            override fun onClick(
                                                v: View?,
                                                verificationResultListener: VerificationResultListener
                                            ) {
                                                ViewUtils.hideSoftKeyboard(requireActivity())
                                                val vpa =
                                                    v?.findViewById<EditText>(R.id.etPhoneAndUPI)
                                                paymentOption.phoneNumber = vpa?.text.toString()
                                                SdkUiInitializer.apiLayer?.verifyEligibilityAPI(
                                                    paymentOption,
                                                    object : VerifyServiceListener {
                                                        override fun eligibilityDetails(
                                                            apiResponse: ApiResponse
                                                        ) {
                                                            val list =
                                                                apiResponse.paymentOptionList?.get(
                                                                    0
                                                                ) as BnplOption
                                                            if (list.isEligible != true) apiResponse.errorMessage =
                                                                requireContext().getString(R.string.payu_mobile_not_eligible_error)
                                                            val verificationResult =
                                                                VerificationResult(
                                                                    list.isEligible == true,
                                                                    apiResponse.errorMessage,
                                                                    apiResponse.successMessage
                                                                )
                                                            verificationResultListener.onResult(
                                                                verificationResult
                                                            )
                                                        }
                                                    })
                                            }
                                        }).setProceedListener {
                                            ViewUtils.hideSoftKeyboard(requireActivity())
                                            val paymentOption1 =
                                                paymentMode.optionDetail?.get(0)
                                            paymentOption1?.category = null
                                            paymentOption1?.let { it1 ->
                                                Utils.getPaymentModel(
                                                    it1,
                                                    null
                                                )
                                            }?.let { it2 ->
                                                SdkUiInitializer.apiLayer?.updatePaymentState(
                                                    it2, ViewUtils.getToolbar(
                                                        requireContext(),
                                                        paymentOption1.additionalCharge
                                                    )
                                                )
                                            }
                                            getCTANameValueForPaymentType(PaymentType.BNPL)?.let { it2 ->
                                                AnalyticsUtils.logTilesData(
                                                    requireContext(),
                                                    it2,
                                                    AnalyticsConstant.CP_TILES_PROCEED_CLICKED,
                                                    loggedIn,
                                                    position
                                                )
                                                AnalyticsUtils.logTilesDataForKibana(
                                                    requireContext(),
                                                    it2,
                                                    AnalyticsConstant.CP_TILES_PROCEED_CLICKED,
                                                    position,
                                                    loggedIn
                                                )
                                            }
                                        }
                                }
                            }
                            bottomSheet
                                .setPaymentOption(paymentOption)
                                .setValidateApiListener(this)
                                .setOfferApplyListener(this)
                                .build().show()
                        }

                        PaymentType.CARD -> {
                            val fragment =
                                AddCardFragment.newInstance(SdkUiConstants.CP_CARDS)
                            paymentOptionViewModel?.loadFragment(fragment, null)
                        }

                        else -> {
                            paymentOptionViewModel?.initiateSMSReader(this.requireActivity())
                            paymentOptionViewModel?.showBottomSheetGlobalVaultSendOTP()
                        }
                    }
                } else {
                    ViewUtils.showNetworkError(it)
                }
            }
        }
    }

    private fun savedOptionsListViewHandler(
        flag: Boolean,
        quickOptionsList: ArrayList<PaymentMode>
    ) {
        if (quickOptionsList.size <= SdkUiConstants.QUICK_OPTION_COUNT) {
            //View All -> Will hide since list is less than 2
            showQuickOptions(quickOptionsList)
            tvViewAll?.visibility = View.GONE
        } else if (flag) {
            //View Less -> Collapse to  show only limited listed items
            showQuickOptions(quickOptionsList)
            tvViewAll?.text = context?.getString(R.string.payu_view_less)
            tvViewAll?.visibility = View.VISIBLE
        } else {
            //View All -> Expands to shows the all saved options
            showQuickOptions(quickOptionsList.take(SdkUiConstants.QUICK_OPTION_COUNT) as ArrayList<PaymentMode>)
            tvViewAll?.text = context?.getString(R.string.payu_view_all)
            tvViewAll?.visibility = View.VISIBLE
        }
    }

    override fun validate(
        paymentOption: PaymentOption?,
        bsResultListener: BottomSheetValidateResultListener
    ) {
        this.bsResultListener = bsResultListener
        paymentOption?.let {
            val pg = Utils.getValueFromPaymentOption<String>(
                SdkUiConstants.CP_PG,
                paymentOption.otherParams as HashMap<String, Any?>
            )
            var bankCode = Utils.getValueFromPaymentOption<String>(
                SdkUiConstants.CP_BANK_CODE,
                paymentOption.otherParams as HashMap<String, Any?>
            )

            val upiOption = paymentOption as? UPIOption
            if (upiOption?.category.equals(SdkUiConstants.INTENT)) {
                bankCode = upiOption?.appName
            }

            val category = Utils.getCategoryForOffer(pg)
            paymentOptionViewModel?.validateOffer(category, bankCode)
        }
    }

    override fun validate(
        paymentOption: PaymentOption,
        onValidateOfferResultListener: ValidateOfferResultListener
    ) {
        this.onValidateOfferResultListener = onValidateOfferResultListener
        val pg = Utils.getValueFromPaymentOption<String>(
            SdkUiConstants.CP_PG,
            paymentOption.otherParams as? HashMap<String, Any?>
        )
        val bankCode = Utils.getValueFromPaymentOption<String>(
            SdkUiConstants.CP_BANK_CODE,
            paymentOption.otherParams as? HashMap<String, Any?>
        )
        val category = Utils.getCategoryForOffer(pg)
        paymentOptionViewModel?.validateOffer(category, bankCode)
    }

    override fun showOfferView(showOffer: Boolean) {
        paymentOptionViewModel?.showChangeOfferView(showOffer)
    }

    override fun onItemClick(paymentMode: PaymentMode) {
        paymentOptionViewModel?.quickOptionSelected(paymentMode)
    }

    override fun updateHeaderAmount(paymentOption: PaymentOption?) {
        if (paymentOption != null) {
            paymentOptionViewModel?.updateHeaderAmount(
                additionalCharge = paymentOption.additionalCharge,
                gstPercentageValue = paymentOption.gstPercentageValue
            )
        } else paymentOptionViewModel?.resetHeaderAmount()
    }

    override fun removeOffer(isAutoApply: Boolean) {
        paymentOptionViewModel?.removeOffer(isAutoApply)
    }

    private fun isUnlockOptionsVisible(): Boolean {
        return (Utils.getGlobalVaultStoredUserToken(
            requireContext()
        ).first.isNullOrEmpty() && (InternalConfig.isQuickPayEnabled || InternalConfig.isUserPersonalizedOffersAvailable))
    }

    override fun setSelectedPaymentMode(paymentMode: PaymentMode) {
        paymentOptionViewModel?.selectedPaymentMode = paymentMode
    }

    override fun otherOptionSelected(paymentMode: PaymentMode) {
        paymentOptionViewModel?.otherOptionSelected(paymentMode)
    }

    override fun updateSelectedPaymentOption(paymentOption: PaymentOption) {
        if (paymentOption.paymentType == PaymentType.UPI_INTENT) {
            paymentOptionViewModel?.updateSelectedPaymentOption(paymentOption)
        }
    }

    override fun validateOffer() {
        paymentOptionViewModel?.validateOffer()
    }

    override fun showOfferNotAvailableSnackBar() {
        paymentOptionViewModel?.showOfferNotAvailableSnackBar()
    }

    private fun showConsentBottomSheet() {
        if (paymentOptionViewModel?.isUserConsentRequiredForOffers() == true) {
            var bs: BNPLAndUPIBottomSheet? = null
            val builder = BNPLAndUPIBottomSheet.Builder(
                childFragmentManager,
                TAG
            ).setTitle(getString(R.string.payu_unlock_your_personalised_rewards)).setShowSecondaryAction(true).setPrimaryButtonText(
                getString(
                    R.string.payu_confirm
                )).setSecondaryButtonText(getString(R.string.payu_skip))
                .setConsentBottomSheet(true)
            AppCompatResources.getDrawable(requireContext(), R.drawable.payu_rewards)?.let {
                builder.setIcon(it)
            }
            builder.setCancelListener {
                Utils.storeUserConsent(requireContext(), false)
            }
            builder.setOnDetachCallBack {
                bs?.close()
            }
            builder.setProceedButtonAction { isConsentGiven ->
                val consent = isConsentGiven as? Boolean? ?: false
                Utils.storeUserConsent(requireContext(), isConsentGiven as Boolean)
                if(consent)
                    paymentOptionViewModel?.invalidateOffers(true)
            }
            bs = builder.build(false)
            bs.show()
        }
    }

    override fun updateHeaderAmount(paymentOption: PaymentOption, resetAmount: Boolean) {
        if (resetAmount) paymentOptionViewModel?.resetHeaderAmount()
        else paymentOptionViewModel?.updateHeaderAmount(
            additionalCharge = paymentOption.additionalCharge,
            gstPercentageValue = paymentOption.gstPercentageValue
        )
    }

    override fun onDestroyView() {
        svCheckoutOptions = null
        rlQuickOptions = null
        llQuickOptions = null
        llUnlockSavedOptionsGlobalVault = null
        llOtherOptions = null
        tvUnlockSavedOptionsResultInfo = null
        ivGlobalSettings = null
        clUnlockSavedOptions = null
        rvQuickOptions = null
        rvOtherOptions = null
        svCheckoutOptions = null
        rlCheckoutOptions = null
        tvViewAll = null
        tvSISummary = null
        tvOfferTitle = null
        tvOfferDetails = null
        tvOfferDisc = null
        tvRemoveOfferButton = null
        changeOfferOption = null
        roundedCornerBottomSheet = null
        rlGlobalVaultTitle = null
        tvUnlockSavedOptionsResult = null
        rvRecommendedOptions = null
        tvGlobalVaultPhoneNumber = null
        llRecommendationList = null
        moreOptionsListObserved = null
        gvrlPhoneSettingLayout = null
        rlGvUnlockSavedOptions = null
        ivGvUnlockSavedOptionsResultInfo = null
        onValidateOfferResultListener = null
        bsResultListener = null
        quickOptionsAdapter = null
        ivManageOption = null
        tvTpvInfo = null
        clTpvSummaryLayout = null
        clSISummaryLayout = null

        super.onDestroyView()
    }

}