package com.payu.ui.view.customViews

import android.content.res.ColorStateList
import android.graphics.BlendMode
import android.graphics.BlendModeColorFilter
import android.graphics.Color
import android.graphics.PorterDuff
import android.graphics.drawable.Drawable
import android.os.Build
import android.os.Handler
import android.text.InputFilter
import android.text.InputType
import android.view.View
import android.widget.Button
import android.widget.CheckBox
import android.widget.EditText
import android.widget.ImageView
import android.widget.ProgressBar
import android.widget.RelativeLayout
import android.widget.TextView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.content.ContextCompat
import androidx.core.widget.addTextChangedListener
import androidx.fragment.app.FragmentManager
import androidx.lifecycle.MutableLiveData
import com.payu.base.listeners.OnFetchImageListener
import com.payu.base.models.BottomSheetType
import com.payu.base.models.ImageDetails
import com.payu.base.models.ImageParam
import com.payu.base.models.InternalConfig
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentType
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.listeners.BottomSheetValidateApiListener
import com.payu.ui.model.listeners.BottomSheetValidateResultListener
import com.payu.ui.model.listeners.BottomSheetVerificationListener
import com.payu.ui.model.listeners.OfferApplyListener
import com.payu.ui.model.listeners.VerificationResultListener
import com.payu.ui.model.models.VerificationResult
import com.payu.ui.model.utils.ImageViewUtils
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.Utils
import com.payu.ui.model.utils.ViewUtils
import com.payu.ui.model.widgets.RoundedCornerBottomSheet
import java.util.regex.Pattern


class BNPLAndUPIBottomSheet(
    private val fragmentManager: FragmentManager, val tag: String,
    private val roundedCornerBottomSheet: RoundedCornerBottomSheet
) {


    fun show() {
        roundedCornerBottomSheet.show(fragmentManager, tag)
    }

    fun close() {
        roundedCornerBottomSheet.dismissAllowingStateLoss()
    }


    class Builder(private val fragmentManager: FragmentManager, val tag: String) :
        RoundedCornerBottomSheet.OnBottomSheetListener, VerificationResultListener,
        View.OnFocusChangeListener, BottomSheetValidateResultListener {
        private lateinit var clPhoneAndUPIView: ConstraintLayout
        private lateinit var clEditAndView: ConstraintLayout
        private lateinit var clUPISuccessView: ConstraintLayout
        private lateinit var clPhoneAndUPIEditView: ConstraintLayout
        private lateinit var progressBar: ProgressBar
        private lateinit var tvVerifyBtn: TextView
        private lateinit var tvPhoneAndUPI: TextView
        private lateinit var tvBnplTitle: TextView
        private lateinit var tvUpiName: TextView
        private lateinit var tvOfferView: TextView
        private lateinit var tvMessage: TextView
        private lateinit var tvNumberLabel: TextView
        private lateinit var tvErrorPhoneNumber: TextView
        private lateinit var ivToolTipPhoneAndUPI: ImageView
        private lateinit var ivBnpl: ImageView
        private lateinit var ivEditPhoneAndUPI: ImageView
        private lateinit var viewGreenTickPhone: View
        private lateinit var etPhoneAndUPI: EditText
        private lateinit var btnProceedToPay: Button
        private lateinit var tvCancel: TextView
        private var rlSwitchSaveCard: RelativeLayout? = null
        private var switchSaveCard: CheckBox? = null
        private var offer: String? = null
        private var title: String? = null
        private var number: String? = null
        private var upiId: String? = null
        private var isNumber: Boolean = false
        private var upiUserName: String? = null
        private var hint: String? = null
        private var isVerified = MutableLiveData<Boolean>()
        private var verifyBtnListener: BottomSheetVerificationListener? = null
        private var proceedBtnListener: View.OnClickListener? = null
        private var proceedButtonAction: ((Any) -> Unit)? = null
        private var cancelBtnListener: View.OnClickListener? = null
        private var imageURL: String? = null
        private var imageDrawable: Drawable? = null
        private var message: String? = null
        private val pattern = Pattern.compile(SdkUiConstants.VPA_REGEX)
        private var showEditView: Boolean = true
        private var imageParam: ImageParam? = null
        private var validateApiListener: BottomSheetValidateApiListener? = null
        private var paymentOption: PaymentOption? = null
        private var bottomSheetType: BottomSheetType? = null
        private var offerApplyListener: OfferApplyListener? = null
        private var onDetachCallBack: (() -> Unit)? = null
        private var isConsentBottomSheet: Boolean? = null
        private var showSecondaryAction: Boolean? = null
        private var primaryButtonText: String? = null
        private var secondaryButtonText: String? = null

        fun setVerifyListener(listener: BottomSheetVerificationListener): Builder {
            this.verifyBtnListener = listener
            return this
        }

        fun setProceedListener(listener: View.OnClickListener): Builder {
            this.proceedBtnListener = listener
            return this
        }

        fun setProceedButtonAction(proceedButtonAction: ((Any)->Unit)?): Builder {
            this.proceedButtonAction = proceedButtonAction
            return this
        }

        fun setCancelListener(listener: View.OnClickListener): Builder {
            this.cancelBtnListener = listener
            return this
        }

        fun setIcon(imageURL: String?): Builder {
            this.imageURL = imageURL
            return this
        }

        fun setIcon(drawable: Drawable): Builder {
            this.imageDrawable = drawable
            return this
        }

        fun setMessage(message: String): Builder {
            this.message = message
            return this
        }

        fun setOfferString(offer: String?): Builder {
            this.offer = offer
            return this
        }

        fun setHint(hint: String): Builder {
            this.hint = hint
            return this
        }

        fun setTitle(title: String): Builder {
            this.title = title
            return this
        }


        fun setNumber(number: String, isVerified: Boolean = false): Builder {
            this.number = number
            isNumber = true
            this.isVerified.value = isVerified
            return this
        }

        fun setValidateApiListener(listener: BottomSheetValidateApiListener): Builder {
            this.validateApiListener = listener
            return this
        }

        fun setPaymentOption(paymentOption: PaymentOption?): Builder {
            this.paymentOption = paymentOption
            return this
        }

        fun setUPI(
            upiId: String,
            upiUserName: String? = null,
            isVerified: Boolean = false
        ): Builder {
            this.upiId = upiId
            this.upiUserName = upiUserName
            this.isVerified.value = isVerified
            return this
        }

        fun setEditView(showEditView: Boolean): Builder {
            this.showEditView = showEditView
            return this
        }

        fun setIconParam(imageParam: ImageParam): Builder {
            this.imageParam = imageParam
            return this
        }

        fun setBottomSheetType(bottomSheetType: BottomSheetType): Builder {
            this.bottomSheetType = bottomSheetType
            return this
        }

        fun setOfferApplyListener(offerApplyListener: OfferApplyListener): Builder {
            this.offerApplyListener = offerApplyListener
            return this
        }

        fun setOnDetachCallBack(onDetachCallBack: (() -> Unit)): Builder {
            this.onDetachCallBack = onDetachCallBack
            return this
        }

        fun setConsentBottomSheet(consentBottomSheet: Boolean): Builder {
            this.isConsentBottomSheet = consentBottomSheet
            return this
        }

        fun setShowSecondaryAction(showSecondaryAction: Boolean): Builder {
            this.showSecondaryAction = showSecondaryAction
            return this
        }

        fun setPrimaryButtonText(primaryButtonText: String): Builder {
            this.primaryButtonText = primaryButtonText
            return this
        }

        fun setSecondaryButtonText(secondaryButtonText: String): Builder {
            this.secondaryButtonText = secondaryButtonText
            return this
        }


        fun build(isCancelableOnClickOutside: Boolean = true): BNPLAndUPIBottomSheet {

            val roundedCornerBottomSheet = RoundedCornerBottomSheet.newInstance(
                R.layout.bnpl_bottom_sheet_layout
            )
            roundedCornerBottomSheet.setListener(this)
            roundedCornerBottomSheet.isCancelable = isCancelableOnClickOutside
            return BNPLAndUPIBottomSheet(fragmentManager, tag, roundedCornerBottomSheet)

        }

        override fun getInflatedView(
            view: View,
            roundedCornerBottomSheet: RoundedCornerBottomSheet
        ) {
            clPhoneAndUPIView = view.findViewById(R.id.clPhoneAndUPIView)
            tvNumberLabel = view.findViewById(R.id.tvNumberLabel)
            progressBar = view.findViewById(R.id.pbPhoneAndUPI)
            tvVerifyBtn = view.findViewById(R.id.tvVerifyBtn)
            ivToolTipPhoneAndUPI = view.findViewById(R.id.ivToolTipPhoneAndUPI)
            etPhoneAndUPI = view.findViewById(R.id.etPhoneAndUPI)
            ivBnpl = view.findViewById(R.id.ivBnpl)
            tvMessage = view.findViewById(R.id.tvMessage)
            ivEditPhoneAndUPI = view.findViewById(R.id.ivEditPhoneAndUPI)
            tvBnplTitle = view.findViewById(R.id.tvBnplTitle)
            tvErrorPhoneNumber = view.findViewById(R.id.tvErrorPhoneNumber)
            tvUpiName = view.findViewById(R.id.tvUpiName)
            tvOfferView = view.findViewById(R.id.tvOfferView)
            btnProceedToPay = view.findViewById(R.id.btnProceedToPay)
            tvCancel = view.findViewById(R.id.tvCancel)
            clUPISuccessView = view.findViewById(R.id.clUPISuccessView)
            clEditAndView = view.findViewById(R.id.clEditAndView)
            clPhoneAndUPIEditView = view.findViewById(R.id.clPhoneAndUPIEditView)
            tvPhoneAndUPI = view.findViewById(R.id.tvPhoneAndUPI)
            viewGreenTickPhone = view.findViewById(R.id.viewGreenTickPhone)
            rlSwitchSaveCard = view.findViewById(R.id.rlSwitchSaveCard)
            switchSaveCard = view.findViewById(R.id.switchSaveCard)
            etPhoneAndUPI.onFocusChangeListener = this
            title?.let {
                tvBnplTitle.text = it
            }
            hint?.let { etPhoneAndUPI.hint = it }
            imageURL?.let {
                SdkUiInitializer.apiLayer?.getBitmapImageFormURL(it,
                    onFetchImageListener = object : OnFetchImageListener {
                        override fun onImageGenerated(result: ImageDetails) {
                            ImageViewUtils.setImage(ivBnpl, result)
                        }
                    })
            }
            imageParam?.let {
                SdkUiInitializer.apiLayer?.getImageForPaymentOption(
                    it,
                    onFetchImageListener = object : OnFetchImageListener {
                        override fun onImageGenerated(result: ImageDetails) {
                            ImageViewUtils.setImage(ivBnpl, result)
                        }
                    })
            }
            imageDrawable?.let {
                ivBnpl.setImageDrawable(it)
            }

            ViewUtils.updateBackgroundColor(
                btnProceedToPay.context,
                btnProceedToPay,
                SdkUiInitializer.apiLayer?.config?.primaryColor,
                R.color.one_payu_colorPrimary
            )
            if (InternalConfig.isOfferEnabled) {
                Handler().postDelayed({
                    if (PaymentType.UPI != paymentOption?.paymentType)
                        validateApiListener?.validate(paymentOption, this)
                }, 300)
            }

            SdkUiInitializer.apiLayer?.config?.primaryColor?.let {
                setColorFilter(progressBar.indeterminateDrawable, Color.parseColor(it))
            } ?: kotlin.run {
                setColorFilter(
                    progressBar.indeterminateDrawable,
                    progressBar.context.resources.getColor(R.color.one_payu_colorPrimary)
                )
            }


            ViewUtils.updateButtonTextColor(
                btnProceedToPay,
                SdkUiInitializer.apiLayer?.config?.baseTextColor
            )

            if (message != null) {
                showMessageView()
            } else if (upiId != null) {
                showSuccessUPIView()
            } else {
                showSuccessPhoneView()

            }
            rlSwitchSaveCard?.let {
                if (InternalConfig.isQuickPayEnabled && InternalConfig.isQuickPayBottomSheetEnabled && !Utils.isSiTxn()) {
                    it.visibility = View.VISIBLE
                    switchSaveCard?.isChecked = true
                } else {
                    it.visibility = View.GONE
                    switchSaveCard?.isChecked = false
                }
            }
            addListeners(view, roundedCornerBottomSheet)

            if (isConsentBottomSheet == true)
                showAsConsentRequestSheet()
            if(showSecondaryAction == true)
                tvCancel.visibility = View.VISIBLE
            else
                tvCancel.visibility = View.GONE

            secondaryButtonText?.let {
                tvCancel.text = it
            }

            primaryButtonText?.let {
                btnProceedToPay.text = it
            }

            cancelBtnListener?.let { listener ->
                tvCancel.setOnClickListener {
                    listener.onClick(it)
                    handleBottomSheetClose()
                }
            }
        }

        private fun showAsConsentRequestSheet() {
            tvCancel.visibility = View.VISIBLE
            clPhoneAndUPIEditView?.visibility = View.GONE
            tvNumberLabel?.visibility = View.GONE
            rlSwitchSaveCard?.let {
                if ((InternalConfig.isOfferEnabled && Utils.getUserConsent(context = it.context) == null)) {
                    it.visibility = View.VISIBLE
                    switchSaveCard?.isChecked = false
                } else {
                    it.visibility = View.GONE
                    switchSaveCard?.isChecked = false
                }
            }
            switchSaveCard?.let {
                it.text = it.context.getString(R.string.payu_rewards_consent_message)
                val primaryColor = SdkUiInitializer.apiLayer?.config?.primaryColor
                it.buttonTintList = if (primaryColor != null) {
                    ColorStateList.valueOf(Color.parseColor(primaryColor))
                } else {
                    ColorStateList.valueOf(
                        ContextCompat.getColor(
                            it.context,
                            R.color.payu_color_ffffff
                        )
                    )
                }
            }
            switchSaveCard?.setOnCheckedChangeListener { buttonView, isChecked ->
                if(::btnProceedToPay.isInitialized) {
                    if (isChecked) {
                        ViewUtils.enableView(btnProceedToPay)
                    } else {
                        ViewUtils.disableView(btnProceedToPay)
                    }
                }
            }
        }

        private fun showMessageView() {
            clPhoneAndUPIEditView.visibility = View.GONE
            tvVerifyBtn.visibility = View.GONE
            clPhoneAndUPIView.visibility = View.GONE
            tvErrorPhoneNumber.visibility = View.GONE
            clUPISuccessView.visibility = View.GONE
            tvOfferView.visibility = View.GONE
            progressBar.visibility = View.GONE
            tvNumberLabel.visibility = View.GONE
            tvMessage.visibility = View.VISIBLE
            isVerified.value = true
            message?.let {
                tvMessage.text = it
            }
            showOfferView()

        }


        private fun setColorFilter(drawable: Drawable, color: Int) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
                drawable.colorFilter = BlendModeColorFilter(color, BlendMode.SRC_ATOP)
            } else {
                drawable.setColorFilter(color, PorterDuff.Mode.SRC_ATOP)
            }

        }

        private fun addListeners(v: View?, roundedCornerBottomSheet: RoundedCornerBottomSheet) {

            tvVerifyBtn.setOnClickListener {
                if (ViewUtils.isInternetAvailable(btnProceedToPay.context)) {
                    showProgressView()
                    verifyBtnListener?.onClick(v, this@Builder)
                } else {
                    ViewUtils.showSnackBar(
                        fragmentManager.findFragmentByTag(tag)?.context?.resources?.getString(R.string.payu_no_internet_connection),
                        R.drawable.payu_no_internet,
                        fragmentManager.findFragmentByTag(tag)?.activity
                    )
                }
            }

            etPhoneAndUPI.addTextChangedListener {
                if (etPhoneAndUPI.inputType == InputType.TYPE_CLASS_NUMBER && it.toString().length < 10
                    || etPhoneAndUPI.inputType == (InputType.TYPE_TEXT_VARIATION_EMAIL_ADDRESS + 1) && !pattern.matcher(
                        etPhoneAndUPI.text.toString()
                    ).matches()
                ) {
                    ViewUtils.disableView(tvVerifyBtn)

                } else {
                    ViewUtils.enableView(tvVerifyBtn)
                }
                if (isNumber) {
                    number = etPhoneAndUPI.text.toString()
                } else {
                    upiId = etPhoneAndUPI.text.toString()
                }
            }

            btnProceedToPay.setOnClickListener {
                roundedCornerBottomSheet.dismissAllowingStateLoss()
                if (ViewUtils.isInternetAvailable(btnProceedToPay.context)) {

                    this.paymentOption?.let { paymentOption ->
                        paymentOption.shouldSaveCard = switchSaveCard?.isChecked == true
                    }
                    proceedBtnListener?.onClick(it)
                    proceedButtonAction?.invoke(switchSaveCard?.isChecked ?: false)
                } else {
                    ViewUtils.showSnackBar(
                        fragmentManager.findFragmentByTag(tag)?.context?.resources?.getString(R.string.payu_no_internet_connection),
                        R.drawable.payu_no_internet,
                        fragmentManager.findFragmentByTag(tag)?.activity
                    )
                }
            }
            ivEditPhoneAndUPI.setOnClickListener { showEditView() }
            fragmentManager.findFragmentByTag(tag)?.viewLifecycleOwner?.let {
                isVerified.observe(it) { verified ->
                    if (verified) ViewUtils.enableView(btnProceedToPay)
                    else ViewUtils.disableView(btnProceedToPay)
                }
            }
        }

        private fun showOfferView() {
            offer?.let {
                tvOfferView.visibility = View.VISIBLE
                tvOfferView.text = it
            }
        }

        private fun showProgressView() {
            showEditView()
            tvVerifyBtn.visibility = View.GONE
            ivToolTipPhoneAndUPI.visibility = View.GONE
            if (!SdkUiInitializer.apiLayer?.config?.primaryColor.isNullOrEmpty())
                ViewUtils.changeProgressBarColor(
                    progressBar,
                    SdkUiInitializer.apiLayer?.config?.primaryColor
                )
            progressBar.visibility = View.VISIBLE
        }

        override fun handleBottomSheetClose() {
            onDetachCallBack?.invoke()
        }

        override fun bottomSheetDetach() {
            when (bottomSheetType) {
                BottomSheetType.L2_TOP_BANKS, BottomSheetType.L1_BOTTOM_SHEET -> {
                    InternalConfig.selectedOfferInfo?.let {
                        if (InternalConfig.selectedOfferInfo?.isAutoApply == true && InternalConfig.removeOfferIfNeeded) {
                            offerApplyListener?.removeOffer(true)
                        }
                    }
                    InternalConfig.isPaymentOptionSelected = false
                    InternalConfig.removeOfferIfNeeded = true
                }

                else -> {}

            }
        }

        override fun bottomSheetAttach() {
        }

        private fun showEditView() {
            clPhoneAndUPIEditView.visibility = View.VISIBLE
            tvVerifyBtn.visibility = View.VISIBLE
            tvNumberLabel.visibility = View.VISIBLE
            clPhoneAndUPIView.visibility = View.GONE
            tvErrorPhoneNumber.visibility = View.GONE
            clUPISuccessView.visibility = View.GONE
            tvOfferView.visibility = View.GONE
            progressBar.visibility = View.GONE
            tvMessage.visibility = View.GONE
            isVerified.value = false
            number?.let {
                tvNumberLabel.text =
                    tvNumberLabel.context.getString(R.string.payu_registered_mobile_number)
                etPhoneAndUPI.filters = arrayOf(InputFilter.LengthFilter(10))
                etPhoneAndUPI.inputType =
                    InputType.TYPE_CLASS_NUMBER or InputType.TYPE_NUMBER_VARIATION_NORMAL
                etPhoneAndUPI.setText(it)
                if (it.isEmpty()) {
                    ViewUtils.disableView(tvVerifyBtn)
                } else {
                    ViewUtils.enableView(tvVerifyBtn)
                }
            }
            upiId?.let {
                etPhoneAndUPI.inputType =
                    InputType.TYPE_CLASS_TEXT or InputType.TYPE_TEXT_VARIATION_EMAIL_ADDRESS
                tvNumberLabel.text = tvNumberLabel.context.getString(R.string.payu_upi_id)
                etPhoneAndUPI.filters = arrayOf(InputFilter.LengthFilter(50))
                upiId = etPhoneAndUPI.text.toString()
                etPhoneAndUPI.setText(upiId)
                if (!it.isEmpty() && pattern.matcher(etPhoneAndUPI.text.toString()).matches()) {
                    ViewUtils.enableView(tvVerifyBtn)
                } else {
                    ViewUtils.disableView(tvVerifyBtn)
                }
                ViewUtils.showSoftKeyboard(etPhoneAndUPI)
            }

        }

        private fun showSuccessPhoneView() {
            clPhoneAndUPIEditView.visibility = View.GONE
            tvNumberLabel.visibility = View.GONE
            clPhoneAndUPIView.visibility = View.VISIBLE
            viewGreenTickPhone.visibility = View.VISIBLE
            clUPISuccessView.visibility = View.GONE
            tvMessage.visibility = View.GONE
            if ((isVerified.value != null && !isVerified.value!!) || number == null) {
                showEditView()
            } else {
                tvPhoneAndUPI.text = number?.formatAsPhone()
            }
            showOfferView()
        }

        private fun showSuccessUPIView() {
            clPhoneAndUPIEditView.visibility = View.GONE
            tvNumberLabel.visibility = View.GONE
            clPhoneAndUPIView.visibility = View.VISIBLE
            viewGreenTickPhone.visibility = View.GONE
            tvMessage.visibility = View.GONE
            clUPISuccessView.visibility = View.VISIBLE
            if (showEditView) ivEditPhoneAndUPI.visibility = View.VISIBLE
            else ivEditPhoneAndUPI.visibility = View.GONE
            if ((isVerified.value != null && !isVerified.value!!) || upiId == null || upiUserName == null) {
                showEditView()
            } else {
                tvPhoneAndUPI.text = upiId
                tvUpiName.text = upiUserName
                if (InternalConfig.isOfferEnabled)
                    Handler().postDelayed({
                        validateApiListener?.validate(paymentOption, this)
                    }, 300)
            }
            showOfferView()

        }

        private fun setError(message: String) {
            clPhoneAndUPIView.visibility = View.GONE
            clUPISuccessView.visibility = View.GONE
            progressBar.visibility = View.GONE
            tvVerifyBtn.visibility = View.GONE
            tvErrorPhoneNumber.text = message
            ivToolTipPhoneAndUPI.contentDescription = message
            ViewUtils.updateStrokeColor(
                clPhoneAndUPIEditView.context,
                clPhoneAndUPIEditView,
                R.color.payu_color_de350b
            )
            tvNumberLabel.visibility = View.VISIBLE
            clPhoneAndUPIEditView.visibility = View.VISIBLE
            ivToolTipPhoneAndUPI.visibility = View.VISIBLE
            tvErrorPhoneNumber.visibility = View.VISIBLE
            showOfferView()
        }

        override fun onResult(result: VerificationResult) {
            if (result.status) {
                isVerified.value = true
                if (result.result.isEmpty()) {
                    showSuccessPhoneView()
                } else {
                    upiUserName = result.result
                    showSuccessUPIView()
                }

            } else {
                setError(result.errorMessage)
                etPhoneAndUPI.clearFocus()
                ViewUtils.hideSoftKeyboard(etPhoneAndUPI)
            }
        }

        private fun String.formatAsPhone(): String {
            if (length > 6) {
                return "${substring(0, 5)}-${substring(5, length)}"
            }
            return this
        }

        override fun onFocusChange(v: View?, hasFocus: Boolean) {
            when (v?.id) {
                R.id.etPhoneAndUPI -> {
                    if (hasFocus) {
                        ViewUtils.updateStrokeColor(
                            v.context,
                            clPhoneAndUPIEditView,
                            SdkUiInitializer.apiLayer?.config?.primaryColor,
                            R.color.one_payu_colorPrimary
                        )
                        tvErrorPhoneNumber.visibility = View.GONE
                        ivToolTipPhoneAndUPI.visibility = View.GONE
                        progressBar.visibility = View.GONE
                        tvVerifyBtn.visibility = View.VISIBLE
                    } else {
                        ViewUtils.updateStrokeColor(
                            v.context,
                            clPhoneAndUPIEditView,
                            R.color.payu_color_338f9dbd
                        )
                    }
                }
            }
        }

        override fun onValidateResultListener(isOfferValid: Boolean) {
            if (isOfferValid) tvOfferView.visibility = View.VISIBLE
        }
    }

}