package com.payu.ui.view

import android.text.Editable
import android.text.TextUtils
import android.text.TextWatcher
import android.util.Log
import android.widget.EditText
import com.payu.ui.R
import com.payu.ui.model.utils.Utils
import com.payu.ui.view.fragments.InputWatcher
import java.util.*


class CustomTextWatcher(
    _editText: EditText,
    _divider: Int,
    _separator: Char,
    _inputWatcher: InputWatcher?
) : TextWatcher {
    var editText: EditText? = _editText
    var divider: Int = _divider
    var separator: Char = _separator
    var previousLength: Int = 0
    var inputWatcher: InputWatcher? = null
    var amexCardRegex: String = "^3[47][\\d]+"
    var isAmexCard: Boolean = false
    var beforeLength: Int = 0

    init {
        inputWatcher = _inputWatcher
    }


    override fun afterTextChanged(s: Editable?) {
        if (editText?.id != R.id.etExpiry) {
            if (s!!.length > 0) {
                if (!separator.equals(0.toChar())) {
                    val numbersOnly = s.toString().replace("\\s".toRegex(), "")
                    if (editText?.id == (R.id.et_add_card)) {
                        isAmexCard = numbersOnly.matches(Regex(amexCardRegex))
                    }
                    // current code pattern miss-match, then handle cursor position and format the code
                    handleEditInput(numbersOnly)
                } else {
                    //Calling for Cvv edit text
                    inputWatcher?.onInputReceived(s.toString(), editText?.id!!)
                }
            } else {
                previousLength = 0
                inputWatcher?.onInputReceived(s.toString(), editText?.id!!)
            }
        } else {
            editText?.removeTextChangedListener(this)
            //Handle Expiry Logic
            if (beforeLength > 0 && beforeLength > s!!.length) {
                handleDeletedEntry(s)
            } else {
                handleNormalEditing(s!!)
            }
            inputWatcher?.onInputReceived(editText?.text.toString(), editText?.id!!)

            editText?.addTextChangedListener(this)
        }
    }

    fun handleDeletedEntry(s: Editable) {
        val slashIndex = s.indexOf("/", 0, true)
        if (-1 == slashIndex) {
            //Deleted slash.Insert it if length >2
            if (s.length > 2) {
                if (isValidMonth(s.substring(0, 2))) {
                    val value = insertSlash(s.toString())
                    //Valid month append '/' at the end
                    editText?.setText(value)
                    editText?.setSelection(value.length)
                } else {
                    //Invalid month clear the value
                    editText?.text?.clear()
                }
            }
        }
    }

    fun handleNormalEditing(s: Editable) {
        if (s.length == 5) {
            if (!isValidMonth(s.substring(0, 2))) {
                s.replace(0, 2, "")
            }
        } else if (s.length == 3) {
            if (isValidMonth(s.substring(0, 2))) {
                val value = insertSlash(s.toString())
                //Valid month append '/' at the end
                editText?.setText(value)
                editText?.setSelection(value.length)
            } else {
                //Invalid month clear the value
                editText?.text?.clear()
            }
        } else if (s.length < 3) {
            //Month is invalid hence clear the entry
            if (!isValidMonth(s.toString()))
                editText?.text?.clear()

        }
    }

    fun insertSlash(s: String): String {
        val value = StringBuilder()
        var length = 0
        for (i in s) {
            if (length == 2)
                value.append("/")
            value.append(i)
            length++
        }
        return value.toString()
    }

    private fun isValidMonth(s: String): Boolean {
        if (Utils.isValidNumberFormat(s) && s.length == 1)
            return Integer.parseInt(s) < 2
        if (Utils.isValidNumberFormat(s) && s.length == 2)
            return Integer.parseInt(s) < 13
        return false
    }

    fun isValidYear(s: String): Boolean {
        val currentYear = Calendar.getInstance().get(Calendar.YEAR) / 100
        return Integer.parseInt(s) > currentYear
    }

    private fun handleEditInput(numbersOnly: String) {
        val code: String? = formatNumbersAsCode(numbersOnly)
        var cursorStart: Int? = editText?.selectionStart
        editText?.removeTextChangedListener(this)
        editText?.setText(code)
        val codeLen = code?.length

        if (cursorStart != codeLen && codeLen!! > 0) { // middle-string operation
            if (isAmexCard) {
                if (cursorStart == 5 || cursorStart == 12) {
                    if (codeLen > previousLength) { // insert, move cursor to next
                        cursorStart++
                    } else if (codeLen < previousLength) { // delete, move cursor to previous
                        cursorStart--
                    }
                } else if (cursorStart == 15) { //Paste card number scenario
                    cursorStart = codeLen
                }
            } else if (cursorStart!! > 0 && cursorStart % divider == 0) {
                if (codeLen > previousLength) { // insert, move cursor to next
                    cursorStart++
                } else if (codeLen < previousLength) { // delete, move cursor to previous
                    cursorStart--
                }
            }
            editText?.setSelection(cursorStart!!)
        } else { // end-string operation
            editText?.setSelection(editText?.text?.length!!)
        }
        editText?.addTextChangedListener(this)
        previousLength = codeLen!!
        inputWatcher?.onInputReceived(code, editText?.id!!)

    }

    fun formatNumbersAsCode(s: CharSequence): String {
        if (TextUtils.isEmpty(s) || s.toString().equals(separator.toString(), true)) {
            return ""
        }
        val len = s.length
        val tmp = StringBuilder()
        for (i in 0 until len) {
            tmp.append(s[i])
            if (isAmexCard) {
                if (((i + 1 == 4) || (i + 1 == 10)) && (i + 1 != len)) {
                    tmp.append(separator)
                }
            } else if ((i + 1) % (divider - 1) == 0 && i + 1 != len) {
                tmp.append(separator)
            }
        }
        return tmp.toString()
    }

    override fun beforeTextChanged(p0: CharSequence?, p1: Int, p2: Int, p3: Int) {
        beforeLength = p0?.length ?: 0
    }

    override fun onTextChanged(p0: CharSequence?, p1: Int, p2: Int, p3: Int) {
    }


}