package com.payu.ui.model.utils

import android.graphics.Bitmap
import android.graphics.drawable.Drawable
import android.view.View
import android.widget.ImageView
import com.payu.base.models.DrawableType
import com.payu.base.models.ImageDetails

object ImageViewUtils {

    fun setImage(imageView: ImageView?, result: ImageDetails?) {
        if (imageView == null || result == null) return
        if (result.type == DrawableType.Bitmap)
            imageView.setImageBitmap(result.image as Bitmap)
        else if (result.type == DrawableType.PictureDrawable) {
            imageView.setLayerType(View.LAYER_TYPE_SOFTWARE, null)
            imageView.setImageDrawable(result.image as Drawable)
        }
    }
}