package com.payu.ui.model.utils

import android.annotation.SuppressLint
import android.content.Context
import android.os.Build
import android.provider.Settings
import android.provider.Settings.Secure.ANDROID_ID
import com.payu.payuanalytics.analytics.factory.AnalyticsFactory
import com.payu.payuanalytics.analytics.model.AnalyticsConfig
import com.payu.payuanalytics.analytics.model.AnalyticsType
import com.payu.payuanalytics.analytics.model.ClevertapAnalytics
import com.payu.payuanalytics.analytics.model.PayUAnalytics
import com.payu.ui.BuildConfig
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.utils.AnalyticsConstant.CP_EVENTS_INDEX
import org.json.JSONObject
import kotlin.collections.ArrayList
import kotlin.collections.HashMap

object AnalyticsHandler {

    var eventIndex = 0

    fun logAnalytics(context: Context, eventName: String, eventData: HashMap<String, Any>) {
        val txnId = SdkUiInitializer.apiLayer?.payUPaymentParams?.transactionId
        val merchantKey = SdkUiInitializer.apiLayer?.payUPaymentParams?.key
        //Prepare final event map
        val eventMap = HashMap<String, Any>()
        eventMap[SdkUiConstants.CP_EVENT_NAME] = eventName
        // identity will be unique for every txn and merchant
        eventMap[SdkUiConstants.CP_IDENTITY] = txnId.plus(merchantKey)
        eventMap[SdkUiConstants.CP_TYPE] = SdkUiConstants.CP_EVENT
        merchantKey?.let {
            eventData[SdkUiConstants.CP_MERCHANT_IDENTIFIER] = it
        }
        SdkUiInitializer.apiLayer?.config?.merchantName?.let {
            eventData[SdkUiConstants.CP_MERCHANT_NAME] = it
        }
        eventData[SdkUiConstants.CP_DEVICE] = SdkUiConstants.CP_ANDROID
        eventData[SdkUiConstants.CP_DEVICE_NAME] = Build.MANUFACTURER.plus(" " + Build.MODEL)
        eventData[SdkUiConstants.CP_DEVICE_VERSION] = Build.VERSION.RELEASE
        eventData[SdkUiConstants.CP_SDK_VERSION] = BuildConfig.VERSION_NAME
        getDeviceID(context)?.let { eventData[SdkUiConstants.CP_DEVICE_ID] = it }
        txnId?.let {
            eventData[SdkUiConstants.CP_TXNID] = it
        }
        SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.let {
            eventData[SdkUiConstants.CP_AMOUNT] = it
        }
        if (SdkUiInitializer.apiLayer?.config?.enforcePaymentList != null) {
            val enforcePaymentListString =
                getEnforcedPaymentTypeString(SdkUiInitializer.apiLayer?.config?.enforcePaymentList)
            enforcePaymentListString?.let {
                eventData[SdkUiConstants.CP_ENFORCED] = it
            }
        }
        eventMap[SdkUiConstants.CP_EVENT_DATA] = eventData
        val clevertapAnalytics = AnalyticsFactory(context, AnalyticsConfig().apply {
            initiatorIdentifier = SdkUiConstants.CP_IDENTIFIER_PACKAGE_UI
            ctAccountId =   Utils.getWizRocketID().first + "-" + Utils.getWizRocketID().second + "-" + Utils.getWizRocketID().third
            ctPassCode =  Utils.getWizRocketPass().first + "-" + Utils.getWizRocketPass().second + "-" + Utils.getWizRocketPass().third
        }).getAnalyticsClass(AnalyticsType.CLEVERTAP) as ClevertapAnalytics
        clevertapAnalytics.log(JSONObject(eventMap as? Map<*, *>?).toString())
    }


    private fun getEnforcedPaymentTypeString(list: ArrayList<HashMap<String, String>>?): String? {
        val paymentTypeString: String = ""
        if (list.isNullOrEmpty())
            return null
        for (map in list) {
            map[SdkUiConstants.CP_PAYMENT_TYPE_CT]?.let { paymentTypeString.plus(it + ",") }
        }
        return paymentTypeString
    }

    @SuppressLint("HardwareIds")
    fun getDeviceID(applicationContext: Context): String? {
        return Settings.Secure.getString(applicationContext.contentResolver, ANDROID_ID)
    }

    fun logKibanaData(context: Context, analyticsJson: JSONObject) {
        eventIndex++
        analyticsJson.put(CP_EVENTS_INDEX, eventIndex)
        val payuAnalytics =
            AnalyticsFactory(context).getAnalyticsClass(AnalyticsType.PAYU_ANALYTICS) as PayUAnalytics
        payuAnalytics.log(analyticsJson.toString())
    }


}