package com.payu.ui.model.managers

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.content.IntentFilter
import com.payu.ui.model.utils.ViewUtils

object NetworkManager {

    private const val CONNECTIVITY_CHANGE = "android.net.conn.CONNECTIVITY_CHANGE"
    private var networkChangeReceiver: NetworkChangeReceiver? = null

    fun registerReceiver(context: Context?) {
        networkChangeReceiver = NetworkChangeReceiver()
        context?.registerReceiver(
            networkChangeReceiver,
            IntentFilter(CONNECTIVITY_CHANGE)
        )
    }

    fun unRegisterReceiver(context: Context?) {
        if (networkChangeReceiver != null) {
            context?.unregisterReceiver(networkChangeReceiver)
            networkChangeReceiver = null
        }
    }

    class NetworkChangeReceiver : BroadcastReceiver() {
        override fun onReceive(context: Context?, intent: Intent?) {
            if (ViewUtils.isInternetAvailable(context!!)) {
                unRegisterReceiver(context)
                ViewUtils.dismissSnackBar()
            }
        }
    }
}