package com.payu.ui.model.managers

import android.os.Handler
import android.os.Looper
import com.payu.base.models.ErrorResponse
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.listeners.PayUHashGenerationListener
import com.payu.ui.model.utils.ErrorConstants
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.viewmodel.PaymentOptionViewModel
import java.util.*

class HashManager(val listener: PayUHashGenerationListener):TimerTask(),PayUHashGenerationListener {
    private val timeOut:Long = 10 * 1000 // 10 seconds
    private var timer:Timer?=null
    companion object{
        @Volatile
        private var isEnded = false
    }


    fun requestHash(map: HashMap<String, String?>) {
        isEnded = false
        timer=Timer()
        timer?.schedule(this, timeOut)
        SdkUiInitializer.checkoutProListener?.generateHash(map,this)
    }

    override fun onHashGenerated(map: HashMap<String, String?>) {
        if(!isEnded){
            timer?.cancel()
            listener.onHashGenerated(map)
        }
    }

    override fun run() {
        if (!isEnded){
            Handler(Looper.getMainLooper()).post{
                SdkUiInitializer.checkoutProListener?.onError(ErrorConstants.TIMEOUT)
//                if(listener is PaymentOptionViewModel){
//
//                    listener.flowComplete.value = true
//                }
            }
        }

        isEnded = true
    }

    override fun cancel(): Boolean {
        return super.cancel()
    }
}