package com.payu.ui.model.adapters.viewholders

import android.view.View
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.payu.ui.R
import com.payu.ui.model.models.AdapterViewSections

class ErrorViewHolder(view: View) : RecyclerView.ViewHolder(view) {
    private var tvSearchErrorText: TextView? = view.findViewById(R.id.tvSearchErrorText)

    fun bind(item: AdapterViewSections.ErrorSection) {
        val context = itemView.context
        tvSearchErrorText?.text = context.getString(R.string.payu_no_results_found_related_to, item.errorText)
    }
}