package com.payu.ui.model.adapters.viewholders

import android.content.Context
import android.view.View
import android.widget.ImageView
import android.widget.TextView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.view.isVisible
import androidx.recyclerview.widget.RecyclerView
import com.payu.ui.R
import com.payu.ui.model.listeners.OnNetBankingAdapterListener
import com.payu.ui.model.models.AdapterViewSections

class AddNewCardViewHolder(view: View) : RecyclerView.ViewHolder(view) {
    private var rlHeaderAddNewCard: ConstraintLayout? =
        view.findViewById(R.id.rlHeaderAddNewCard)
    private var ivRightArrow: ImageView? = view.findViewById(R.id.ivRightArrow)
    private var tvAccessSavedOption: TextView? = view.findViewById(R.id.tvAccessSavedOption)
    private var ivAddIcon: ImageView? = view.findViewById(R.id.ivAddIcon)
    private var tvAccessSavedOptionDetails: TextView? =
        view.findViewById(R.id.tvAccessSavedOptionDetails)
    private var tvOfferText: TextView? = view.findViewById(R.id.tvOfferText)

    fun bind(item: AdapterViewSections.AddNewCard, showTezOmniView: Boolean , showOfferViewInUPICollect: Boolean, onNetBankingAdapterListener: OnNetBankingAdapterListener) {
        tvAccessSavedOption?.text = item.title
        tvAccessSavedOptionDetails?.text = item.detailsText
        tvAccessSavedOptionDetails?.isVisible = item.showDetails
        ivRightArrow?.isVisible = item.showRightIcon
        tvOfferText?.isVisible = item.showOffer
        ivAddIcon?.isVisible = item.showAddIcon
        if (showTezOmniView) tvAccessSavedOptionDetails?.visibility = View.VISIBLE
        tvOfferText?.visibility = if (showOfferViewInUPICollect)
            View.VISIBLE else View.GONE
        item.addIconRes?.let {
            ivAddIcon?.setImageResource(it)
        }
        rlHeaderAddNewCard?.setOnClickListener {
            onNetBankingAdapterListener.addNewCard()
        }
        if (item.showRightIcon && item.rightIcon != null) {
            ivRightArrow?.setImageResource(item.rightIcon)
        }
    }
}
