package com.payu.ui.model.adapters

import android.os.SystemClock
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.ProgressBar
import android.widget.RelativeLayout
import android.widget.TextView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.recyclerview.widget.RecyclerView
import com.payu.base.listeners.OnFetchImageListener
import com.payu.base.models.*
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.utils.*
import com.payu.ui.model.utils.SdkUiConstants.CP_NULL
import com.payu.ui.viewmodel.PaymentOptionViewModel

class SavedCardsListAdapter(
    val savedOptionsListener: SavedOptionsListener,
    var savedCardsList: ArrayList<PaymentMode>,
    var isBankDown: Boolean = false
) :
    RecyclerView.Adapter<SavedCardsListAdapter.ViewHolder>() {

    var showDeleteIcon: Boolean = false

    // variable to track event time
    private var mLastClickTime: Long = 0

    inner class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {

        val ivCardIssuerIcon: ImageView = itemView.findViewById(R.id.ivCardIssuerIcon)
        val tvBankName: TextView = itemView.findViewById(R.id.tvBankName)
        val tvOfferText: TextView = itemView.findViewById(R.id.tvOfferText)
        val tvCardNumber: TextView = itemView.findViewById(R.id.tvCardNumber)
        val tvCardScheme: TextView = itemView.findViewById(R.id.tvCardScheme)
        val rlOtherOption: ConstraintLayout = itemView.findViewById(R.id.clOtherOption)
        val ivRightArrow: ImageView = itemView.findViewById(R.id.ivRightArrow)
        val tvBankDown: TextView = itemView.findViewById(R.id.tvBankDown)
        val tvLowBalance: TextView = itemView.findViewById(R.id.tvLowBalance)
        val progressBar: ProgressBar = itemView.findViewById(R.id.progressBar)
        val amount = SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDouble()

        init {
            ivRightArrow.setOnClickListener(object : View.OnClickListener {
                override fun onClick(v: View?) {
                    // Preventing multiple clicks, using threshold of 1 second
                    if (SystemClock.elapsedRealtime() - mLastClickTime < 1000) {
                        return
                    }
                    mLastClickTime = SystemClock.elapsedRealtime()
                    if (showDeleteIcon) {
                        savedOptionsListener.onDeleteClicked(
                            adapterPosition,
                            (savedCardsList[adapterPosition].optionDetail!![0] as SavedCardOption)
                        )
                    }
                }

            })

            rlOtherOption.setOnClickListener {
                savedOptionsListener.quickOptionSelected(savedCardsList[adapterPosition])
            }

        }

        fun bind(position: Int) {
            val paymentOption = savedCardsList[position].optionDetail?.first()
            ivRightArrow.setImageResource(R.drawable.payu_arrow_right)
            rlOtherOption.isEnabled = true
            rlOtherOption.setOnClickListener {
                savedCardsList[position].optionDetail?.get(0)
                    ?.let { it1 ->
                        if (paymentOption?.paymentType != PaymentType.CARD) savedOptionsListener.validateOffer(
                            it1
                        )
                    }

                if (savedCardsList[position].type == PaymentType.SODEXO) {
                    it.context?.let {
                        AnalyticsUtils.logCardsL2ClickEvents(
                            it,
                            SdkUiConstants.CP_SAVED_CARD_SODEXO,
                            savedCardsList[position].isOfferValid
                        )
                    }
                    val sodexoCardOption =
                        savedCardsList[position].optionDetail?.get(0) as SodexoCardOption
                    if (sodexoCardOption.fetchedStatus != 1) {
                        progressBar.visibility = View.VISIBLE
                        tvCardNumber.text =
                            it.context?.getString(R.string.payu_fetching_card_number_and_balance)
                        savedOptionsListener.fetchSodexoBalance()
                    } else {

                        savedOptionsListener.showBottomSheet(
                            savedCardsList[position].type,
                            savedCardsList[position].optionDetail?.get(0)
                        )
                    }
                } else {
                    it.context?.let {
                        AnalyticsUtils.logCardsL2ClickEvents(
                            it,
                            SdkUiConstants.CP_SAVED_CARD,
                            savedCardsList[position].isOfferValid
                        )
                    }
                    savedOptionsListener.showBottomSheet(
                        savedCardsList[position].type,
                        savedCardsList[position].optionDetail?.get(0)
                    )
                }

            }
            progressBar.visibility = View.GONE
            val param = ImageParam(paymentOption!!, true, R.drawable.payu_cards_placeholder)

            SdkUiInitializer.apiLayer?.getImageForPaymentOption(
                param,
                onFetchImageListener = object : OnFetchImageListener {
                    override fun onImageGenerated(result: ImageDetails) {
                        ImageViewUtils.setImage(ivCardIssuerIcon, result)
                    }
                })

            when (savedCardsList[position].type) {
                PaymentType.CARD -> {
                    val cardOption = paymentOption as CardOption
                    tvCardNumber.text = Utils.getFormattedString(
                        cardOption.cardNumber,
                        cardOption.cardBinInfo?.cardScheme
                    )
                    tvLowBalance.visibility = View.GONE
                    if (!cardOption.bankName.isNullOrEmpty() && !cardOption.bankName.trim()
                            .equals(CP_NULL, true)
                    )
                        tvBankName.text = cardOption.bankName
                    else
                        tvBankName.visibility = View.GONE

                    tvCardScheme.text = cardOption.cardBinInfo?.cardType?.getTypeName()
                    tvCardScheme.visibility = View.VISIBLE

                    if (showDeleteIcon)
                        showDeleteCardView(this)
                    else {
                        when {
                            savedCardsList[position].isBankDown ->
                                showBankDownView(this, position)

                            Utils.isOfferSelected() && cardOption.cardBinInfo?.cardScheme?.name?.let {
                                Utils.isOfferAvailableForCards(
                                    cardOption.cardBinInfo?.issuingBank,
                                    it,
                                    cardOption.cardBinInfo?.cardType
                                )
                            } == true ->
                                showOfferView(this, position)

                            else ->
                                showNormalView(this)
                        }
                    }
                }

                PaymentType.SODEXO -> {
                    tvOfferText.visibility = View.GONE
                    val cardOption = paymentOption as SodexoCardOption
                    if (cardOption.bankName.trim().isNotEmpty())
                        tvBankName.text = cardOption.bankName
                    else
                        tvBankName.visibility = View.GONE
                    if (!savedCardsList[position].isBankDown) {
                        when (cardOption.fetchedStatus) {
                            -1 -> {
                                tvBankName.visibility = View.GONE
                                tvCardNumber.text =
                                    itemView.context?.getString(R.string.payu_fetching_card_number_and_balance)
                                progressBar.visibility = View.VISIBLE
                            }

                            0 -> {

                                tvBankName.visibility = View.GONE
                                tvCardNumber.text =
                                    itemView.context?.getString(R.string.payu_couldnt_fetch_details)

                            }

                            else -> {
                                tvBankName.visibility = View.VISIBLE
                                tvOfferText.visibility = View.GONE
                                if (!cardOption.cardNumber.isNullOrBlank()) {
                                    tvBankName.text =
                                        cardOption.bankName + " " + cardOption.cardNumber.takeLast(8)
                                    tvCardNumber.text = "Balance: ₹" + cardOption.balance

                                    if (cardOption.balance.toDouble() < amount!!) run {
                                        showLowBalanceSodexo(this)
                                    }
                                }
                            }
                        }
                    } else
                        showBankDownView(this, position)
                }

                else -> {
                    tvCardScheme.visibility = View.GONE
                }
            }

        }
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val inflater = LayoutInflater.from(parent.context)
        val view: View = inflater.inflate(R.layout.payu_saved_card_item, parent, false)

        return ViewHolder(view)
    }

    override fun getItemCount(): Int {
        return savedCardsList.size
    }

    override fun getItemId(position: Int): Long {
        return position.toLong()
    }

    override fun getItemViewType(position: Int): Int {
        return position
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        holder.bind(position)
    }

    interface SavedOptionsListener {
        fun onDeleteClicked(deleteIndex: Int, savedCardOption: SavedCardOption)
        fun validateOffer(paymentOption: PaymentOption)
        fun quickOptionSelected(paymentMode: PaymentMode)
        fun showBottomSheet(type: PaymentType?, paymentOption: PaymentOption?)
        fun fetchSodexoBalance()
    }

    private fun showBankDownView(holder: SavedCardsListAdapter.ViewHolder, position: Int) {
        holder.tvBankDown.visibility = View.GONE
        isBankDown = true
        ViewUtils.showSpanView(
            holder.itemView.context,
            holder.tvCardNumber.text.toString(),
            R.drawable.ic_frame,
            holder.tvCardNumber
        )
        holder.tvOfferText.visibility = View.GONE
        holder.rlOtherOption.isEnabled = false

        ViewUtils.disableView(holder.ivCardIssuerIcon)
        ViewUtils.disableView(holder.tvBankName)
        ViewUtils.disableView(holder.tvCardScheme)
        ViewUtils.disableView(holder.ivRightArrow)

    }

    private fun showLowBalanceSodexo(holder: SavedCardsListAdapter.ViewHolder) {
        holder.tvLowBalance.visibility = View.VISIBLE
        holder.tvBankDown.visibility = View.GONE
        holder.tvOfferText.visibility = View.GONE
        holder.rlOtherOption.isEnabled = false
        ViewUtils.disableView(holder.ivCardIssuerIcon)
        ViewUtils.disableView(holder.tvBankName)
        ViewUtils.disableView(holder.tvCardScheme)
        ViewUtils.disableView(holder.ivRightArrow)

    }

    private fun showOfferView(holder: SavedCardsListAdapter.ViewHolder, position: Int) {
        holder.tvBankDown.visibility = View.GONE
        holder.tvOfferText.visibility = View.VISIBLE
        holder.rlOtherOption.isEnabled = true
        ViewUtils.enableView(holder.ivCardIssuerIcon)
        ViewUtils.enableView(holder.tvBankName)
        ViewUtils.enableView(holder.tvCardScheme)
        ViewUtils.enableView(holder.ivRightArrow)
    }

    private fun showNormalView(holder: SavedCardsListAdapter.ViewHolder) {
        holder.tvBankDown.visibility = View.GONE
        holder.tvOfferText.visibility = View.GONE
        holder.rlOtherOption.isEnabled = true
        ViewUtils.enableView(holder.ivCardIssuerIcon)
        ViewUtils.enableView(holder.tvBankName)
        ViewUtils.enableView(holder.tvCardScheme)
        ViewUtils.enableView(holder.ivRightArrow)
    }

    private fun showDeleteCardView(holder: SavedCardsListAdapter.ViewHolder) {
        holder.tvBankDown.visibility = View.GONE
        holder.tvOfferText.visibility = View.GONE
        holder.rlOtherOption.isEnabled = false
        holder.ivRightArrow.setImageResource(R.drawable.payu_delete)
        ViewUtils.enableView(holder.ivCardIssuerIcon)
        ViewUtils.enableView(holder.tvBankName)
        ViewUtils.enableView(holder.tvCardScheme)
        ViewUtils.enableView(holder.ivRightArrow)
    }
}