package com.payu.ui.model.adapters

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import androidx.recyclerview.widget.RecyclerView
import com.payu.ui.R


class LoadMoneyAdapter(
    private val items: ArrayList<String>,
    private val onMoneyAdded: (Double) -> Unit
) :
    RecyclerView.Adapter<LoadMoneyAdapter.ViewHolder>() {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val inflater = LayoutInflater.from(parent.context)
        val view = inflater.inflate(R.layout.load_money_items, parent, false)
        return ViewHolder(view)
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        holder.btnRecharge.text = items[position]
    }

    override fun getItemCount(): Int {
        return items.size
    }

    inner class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        var btnRecharge: Button = itemView.findViewById(R.id.btnRecharge)

        init{
            btnRecharge.setOnClickListener{
                onMoneyAdded(items[bindingAdapterPosition].substring(1).toDouble())
            }
        }
    }
}