package com.payu.ui.model.adapters

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.AdapterView.OnItemSelectedListener
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.payu.base.models.EMIOption
import com.payu.base.models.PaymentOption
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.utils.Utils
import com.payu.ui.model.utils.ViewUtils
import com.payu.ui.viewmodel.CardBaseViewModel

class EmiTenuresAdapter(
    var emiTenureList: ArrayList<PaymentOption>?,
    val onTenureSelectedListener: (emiOption: EMIOption?, tenureText: String, totalAmountText: String) -> Unit
) :
    RecyclerView.Adapter<EmiTenuresAdapter.ViewHolder>() {

    var selectedPosition: Int = -1

    fun setList(emiTenureList: ArrayList<PaymentOption>) {
        this.emiTenureList = emiTenureList
        notifyDataSetChanged()
    }

    inner class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {

        val tvPayEmiAmount: TextView = itemView.findViewById(R.id.tvPayEmiAmount)
        val ivEmiCircle: ImageView = itemView.findViewById(R.id.ivEmiCircle)
        val tvInterestCharged: TextView = itemView.findViewById(R.id.tvInterestCharged)
        val tvTotalAmount: TextView = itemView.findViewById(R.id.tvTotalAmount)
        val tvNoCostEmi: TextView = itemView.findViewById(R.id.tvNoCostEmi)

        init {
            itemView.setOnClickListener {
                selectedPosition = bindingAdapterPosition
                ivEmiCircle.setImageResource(R.drawable.payu_circle_selected)
                onTenureSelectedListener.invoke(
                    emiTenureList?.get(bindingAdapterPosition) as? EMIOption?,
                    tvPayEmiAmount.text.toString(), tvTotalAmount.text.toString()
                )
            }
        }

        fun bind(position: Int) {
            if (selectedPosition == position) ivEmiCircle.setImageResource(R.drawable.payu_circle_selected) else ivEmiCircle.setImageResource(
                R.drawable.payu_circle_unselected
            )
            val emiOptionData = emiTenureList?.get(position) as? EMIOption?
            emiOptionData?.let { emiOption ->
                val emiValue = String.format("%.2f", emiOption.emiValue)
                if (emiOption.nceDiscount?.total != null && emiOption.nceDiscount?.total != 0.0) {
                    tvNoCostEmi.visibility = View.VISIBLE
                    itemView.context?.let {
                        ViewUtils.updateBackgroundColor(
                            it,
                            tvNoCostEmi,
                            SdkUiInitializer.apiLayer?.config?.primaryColor,
                            R.color.one_payu_colorPrimary
                        )
                    }

                    tvInterestCharged.text =
                        itemView.context?.getString(R.string.payu_no_interest_charged)
                    tvPayEmiAmount.text =
                        itemView.context?.getString(
                            R.string.payu_pay_emi_amount_without_interest,
                            Utils.formatAmount(emiValue),
                            emiOption.months.toString()
                        )
                } else {
                    tvNoCostEmi.visibility = View.GONE
                    tvPayEmiAmount.text =
                        itemView.context?.getString(
                            R.string.payu_pay_emi_amount,
                            Utils.formatAmount(emiValue),
                            emiOption.months.toString()
                        )
                    tvInterestCharged.text = itemView.context?.getString(
                        R.string.payu_total_interest_charged,
                        emiOption.interestRate.toString()
                    )
                }
                if (emiOption.totalPayableAmount.toInt() == 0) {
                    val totalAmt = String.format(
                        "%.2f",
                        ((SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDouble()
                            ?: 0.0).plus(
                            emiOption.interestCharged
                        ))
                    )
                    tvTotalAmount.text = itemView.context?.getString(
                        R.string.payu_pay_amount,
                        Utils.formatAmount(totalAmt.toString())
                    )
                } else tvTotalAmount.text = itemView.context?.getString(
                    R.string.payu_pay_amount,
                    Utils.formatAmount((emiOption.totalPayableAmount).toString())
                )
            }
        }
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val inflater = LayoutInflater.from(parent.context)
        val view: View = inflater.inflate(R.layout.layout_emi_tenures_list_item, parent, false)

        return ViewHolder(view)
    }

    override fun getItemCount(): Int {
        return emiTenureList?.size ?: 0
    }

    override fun getItemId(position: Int): Long {
        return position.toLong()
    }

    override fun getItemViewType(position: Int): Int {
        return position
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        holder.bind(position)
    }
}
