package com.payu.ui

import android.app.Activity
import android.content.Intent
import androidx.fragment.app.FragmentActivity
import com.payu.base.models.ErrorResponse
import com.payu.base.models.InternalConfig
import com.payu.ppiscanner.PayUQRScanner
import com.payu.ppiscanner.PayUScannerConfig
import com.payu.ppiscanner.interfaces.PayUScannerListener
import com.payu.ppiscanner.interfaces.ScannerHashGeneratedListener
import com.payu.ppiscanner.model.OutletTxnDetails
import com.payu.ui.model.listeners.PayUHashGenerationListener
import com.payu.ui.model.utils.AnalyticsUtils
import com.payu.ui.model.utils.CPCallbackType
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.Utils
import com.payu.ui.view.activities.CheckoutActivity

object SdkUiInitializerHelper {

    fun openQrScannerOrCheckout(activity: Activity) {
        if (SdkUiInitializer.apiLayer?.config?.isQrScan == true) {
            // open Scanner flow
            val key = SdkUiInitializer.apiLayer?.payUPaymentParams?.key
            val isProduction = SdkUiInitializer.apiLayer?.payUPaymentParams?.isProduction ?: false
            val amount = SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDouble()
            val scannerConfig = PayUScannerConfig(
                key = key,
                isProduction = isProduction,
                amount = amount,
                merchantLogoUrl = SdkUiInitializer.apiLayer?.config?.merchantLogoUrl,
                merchantLogoDrawable = SdkUiInitializer.apiLayer?.config?.merchantLogo,
                txnId = SdkUiInitializer.apiLayer?.payUPaymentParams?.transactionId,
                primaryColor = SdkUiInitializer.apiLayer?.config?.primaryColor,
                baseTextColor = SdkUiInitializer.apiLayer?.config?.baseTextColor
            )
            PayUQRScanner.openScannerActivity(
                activity,
                scannerConfig,
                object : PayUScannerListener {
                    override fun onSuccess(result: OutletTxnDetails) {
                        updateData(result)
                        openCheckoutActivity(activity)
                    }

                    override fun onFailure(errorCode: Int, errorMessage: String) {
                        AnalyticsUtils.logCPCallbackEventKibana(activity.applicationContext, CPCallbackType.Error)
                        SdkUiInitializer.checkoutProListener?.onError(
                            ErrorResponse(
                                errorMessage,
                                errorCode
                            )
                        )
                    }

                    override fun generateHash(
                        map: HashMap<String, String?>,
                        scannerHashGeneratedListener: ScannerHashGeneratedListener
                    ) {
                        SdkUiInitializer.checkoutProListener?.generateHash(
                            map,
                            object : PayUHashGenerationListener {
                                override fun onHashGenerated(map: HashMap<String, String?>) {
                                    scannerHashGeneratedListener.onHashGenerated(map)
                                }
                            })
                    }

                })
        } else {
            openCheckoutActivity(activity)
        }
    }

    private fun updateData(result: OutletTxnDetails) {
        InternalConfig.outletId = result.id
//        SdkUiInitializer.apiLayer?.config?.merchantName = result.outletName ?: ""
        result.amount?.let { amount ->
            SdkUiInitializer.apiLayer?.payUPaymentParams?.let {
                val newBuilder = Utils.clonePayUPaymentParams(it)
                newBuilder.setAmount(amount.toString())
                SdkUiInitializer.apiLayer?.payUPaymentParams = newBuilder.build()
            }
        }

    }


    /**
    In this method activity is cast to Fragment activity,
    to use its lifecycle awareness and viewmodel store owner benefits,
    this is not cast as appcompat activity because flutter doesnt support appcompat activity.
     */
    private fun openCheckoutActivity(activity: Activity) {
        if (isQuickPayFlow(activity)) {
            CheckOutUi(activity as FragmentActivity)
        } else {
            val intent = Intent(activity, CheckoutActivity::class.java)
            activity.startActivityForResult(intent, SdkUiConstants.REQUEST_CODE_SDK_INIT)
        }
    }

    private fun isQuickPayFlow(activity: Activity): Boolean {
        return (activity is FragmentActivity && Utils.isSiTxn()
            .not() && SdkUiInitializer.apiLayer?.payUPaymentParams?.beneficiaryDetailList.isNullOrEmpty())
    }
}