package com.payu.ui.viewmodel

import android.app.Application
import android.text.InputType
import androidx.lifecycle.MutableLiveData
import com.payu.base.listeners.OnFetchImageListener
import com.payu.base.listeners.VerifyServiceListener
import com.payu.base.models.ApiResponse
import com.payu.base.models.BnplOption
import com.payu.base.models.EMIOption
import com.payu.base.models.ImageDetails
import com.payu.base.models.ImageParam
import com.payu.base.models.InternalConfig
import com.payu.base.models.PaymentFlowState
import com.payu.base.models.PaymentModel
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentState
import com.payu.base.models.PaymentType
import com.payu.base.models.UPIOption
import com.payu.base.models.WalletOption
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.utils.AnalyticsUtils
import com.payu.ui.model.utils.MultipleClickHandler
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.Utils
import com.payu.ui.model.utils.ViewUtils

class WalletViewModel(application: Application, mParam: Map<String, Any>) :
    BaseViewModel(application), VerifyServiceListener {

    var paymentOption: PaymentOption? = null
    var paymentType: PaymentType? = null
    var paymentFlowState: PaymentFlowState? = null
    var emiOptionList: ArrayList<PaymentOption>? = null
    val walletHeaderTitle: MutableLiveData<String> = MutableLiveData()
    val walletFooterTitle: MutableLiveData<String> = MutableLiveData()
    val phoneNumberLabel: MutableLiveData<String> = MutableLiveData()
    val editTextInputType: MutableLiveData<Int> = MutableLiveData()
    val editTextInputLength: MutableLiveData<Int> = MutableLiveData()
    val showWalletFooter: MutableLiveData<Boolean> = MutableLiveData()
    val walletIcon: MutableLiveData<ImageDetails> = MutableLiveData()
    val enablePayBtn: MutableLiveData<Boolean> = MutableLiveData()
    val enableVerify: MutableLiveData<Boolean> = MutableLiveData()
    val showLoaderInEditText: MutableLiveData<Boolean> = MutableLiveData()
    val showVerifiedImage: MutableLiveData<Boolean> = MutableLiveData()
    val showVerifyNumber: MutableLiveData<Boolean> = MutableLiveData()
    val showPhonePickerDialog: MutableLiveData<Boolean> = MutableLiveData()
    val phoneFieldColor: MutableLiveData<Any> = MutableLiveData()
    val verifiedText: MutableLiveData<String> = MutableLiveData()
    val verifiedTextColor: MutableLiveData<Int> = MutableLiveData()
    val showVerifiedText: MutableLiveData<Boolean> = MutableLiveData()
    val phoneNumberText: MutableLiveData<String> = MutableLiveData()
    var siHeaderSummary: MutableLiveData<String> = MutableLiveData()
    var showPhonePicker: Boolean = false
    var isShowingPhonePicker: Boolean = false
    var isValidMobileNumber: Boolean = false
    var applicationContext = application
    val isSIMode: MutableLiveData<Boolean> = MutableLiveData()
    val shakeVerfiedText: MutableLiveData<Boolean> = MutableLiveData()
    val showGpayMessage: MutableLiveData<Boolean> = MutableLiveData()
    var textErrorMessage: MutableLiveData<String> = MutableLiveData()
    var textErrorMessageColor: MutableLiveData<Int> = MutableLiveData()
    val vpa: MutableLiveData<String> = MutableLiveData()
    var prevVpa: String? = null
    var items: ArrayList<String> = ArrayList()
    var lastItems: ArrayList<String> = ArrayList()
    var vpaVerified: String = ""
    var updateAdapter: MutableLiveData<Boolean> = MutableLiveData()
    var setSelection: MutableLiveData<Int> = MutableLiveData()
    internal var showErrorSnackBar :MutableLiveData<Boolean> = MutableLiveData()
    private var isNewNumber: Boolean = false
    val callValidateOffer: MutableLiveData<Boolean> = MutableLiveData()

    init {
        val paymentModel = mParam[SdkUiConstants.CP_PAYMENT_MODEL] as PaymentModel
        paymentOption = paymentModel.paymentOption
        selectedPaymentOption = paymentModel.paymentOption
        paymentType = paymentOption?.paymentType
        paymentFlowState = paymentModel.paymentFlowState
        emiOptionList = paymentModel.paymentOptionList
        shouldShowPhonePicker()
        if (paymentOption != null)
            updateViews(paymentOption, paymentType, paymentFlowState?.paymentState)
        showConsent()
    }
    fun getUpiAutorecommendedHandles(s: String, beforeTxt: String): ArrayList<String> {
        val newItems: ArrayList<String> = ArrayList()
        var idx = s.lastIndexOf('@')
        if (s.contains("@")) {
            var x = s.substring(idx)

            if (s.length >= beforeTxt.length && s.startsWith(beforeTxt)) {
                for (item in lastItems) {
                    if (item.startsWith(x)) {
                        newItems.add(item)
                    }
                }
            } else {
                for (item in items) {
                    if (item.startsWith(x)) {
                        newItems.add(item)
                    }
                }

            }

        }
        lastItems.clear()
        lastItems.addAll(newItems)
        return newItems
    }

    fun setAutorecommendedHandlesVisibility(s: String, beforeTxt: String) {
        var idx = s.lastIndexOf('@')
        if (s.contains("@")) {
            var newItems = getUpiAutorecommendedHandles(s, beforeTxt)

            updateAdapter.value = newItems != null && newItems.size > 0

            if (newItems != null && newItems.contains(s.subSequence(idx, s.length).toString())) {
                verifyNumberClicked(s)

                if ((s.subSequence(0, s.length - 1).toString().equals(beforeTxt) || s.startsWith(
                        beforeTxt
                    ))
                )
                    setSelection.value = s.length
            }
        }
    }

    private fun updateViews(
        paymentOption: PaymentOption?,
        paymentType: PaymentType?,
        paymentState: PaymentState?
    ) {
        enablePayBtn.value = false

        when (paymentType) {

            PaymentType.WALLET -> {
                phoneNumberText.value = SdkUiInitializer.apiLayer?.payUPaymentParams?.phone
                walletHeaderTitle.value = paymentOption?.bankName
                walletFooterTitle.value = paymentOption?.bankName
                SdkUiInitializer.apiLayer?.getImageForPaymentOption(
                    ImageParam(paymentOption!!, false, R.drawable.payu_wallet),
                    onFetchImageListener = object : OnFetchImageListener {
                        override fun onImageGenerated(result: ImageDetails) {
                            walletIcon.value = result
                        }
                    })
                siHeaderSummary.value = Utils.getCustomeNoteDetails(
                    PaymentType.WALLET,
                    SdkUiInitializer.apiLayer?.config?.customNoteDetails
                )
                if (paymentOption?.otherParams != null) {
                    val hashMap: HashMap<String, String> =
                        paymentOption.otherParams as HashMap<String, String>
                    if (hashMap[SdkUiConstants.CP_BANK_CODE] == SdkUiConstants.CP_TWID) {
                        showVerifyNumber.value = false
                        enablePayBtn.value =
                            SdkUiInitializer.apiLayer?.payUPaymentParams?.phone?.let {
                                Utils.isValidPhoneNumber(
                                    it
                                )
                            }
                    }
                }
            }

            PaymentType.UPI -> {
                if (paymentOption is UPIOption) {
                    val upiOption = paymentOption as UPIOption
                    items.addAll(upiOption.upiHandles)
                    lastItems.addAll(upiOption.upiHandles)
                    walletHeaderTitle.value =
                        applicationContext.getString(R.string.payu_pay_by_upi_id)
                    walletFooterTitle.value = ""
                    phoneNumberText.value = ""
                    SdkUiInitializer.apiLayer?.getImageForPaymentOption(
                        ImageParam(paymentOption!!, false, R.drawable.payu_bhim_upi),
                        onFetchImageListener = object : OnFetchImageListener {
                            override fun onImageGenerated(result: ImageDetails) {
                                walletIcon.value = result
                            }
                        })
                    siHeaderSummary.value = Utils.getCustomeNoteDetails(
                        PaymentType.UPI,
                        SdkUiInitializer.apiLayer?.config?.customNoteDetails
                    )
                }else handleErrorCase(applicationContext.getString(R.string.payu_please_try_another_payment))
            }
            PaymentType.EMI -> {
                phoneNumberText.value = SdkUiInitializer.apiLayer?.payUPaymentParams?.phone
                walletHeaderTitle.value = paymentOption?.bankName
                walletFooterTitle.value = paymentOption?.bankName
                SdkUiInitializer.apiLayer?.getImageForPaymentOption(
                    ImageParam(paymentOption!!, false, R.drawable.payu_emi_zest_money),
                    onFetchImageListener = object : OnFetchImageListener {
                        override fun onImageGenerated(result: ImageDetails) {
                            walletIcon.value = result
                        }
                    })
            }
            PaymentType.BNPL -> {
                phoneNumberText.value = SdkUiInitializer.apiLayer?.payUPaymentParams?.phone
                walletHeaderTitle.value = SdkUiConstants.ENTER_CREDENTIALS
                walletFooterTitle.value = paymentOption?.bankName
                SdkUiInitializer.apiLayer?.getImageForPaymentOption(
                    ImageParam(paymentOption!!, false, R.drawable.payu_wallet),
                    onFetchImageListener = object : OnFetchImageListener {
                        override fun onImageGenerated(result: ImageDetails) {
                            walletIcon.value = result
                        }
                    })
                siHeaderSummary.value = Utils.getCustomeNoteDetails(
                    PaymentType.BNPL,
                    SdkUiInitializer.apiLayer?.config?.customNoteDetails
                )
            }
        }
        showWalletFooter.value = true
        textErrorMessage.value = null
        showGpayMessage.value = false

        when (paymentState) {
            PaymentState.MobileEligibility -> {
                editTextInputType.value = InputType.TYPE_CLASS_NUMBER
                editTextInputLength.value = 10
                phoneNumberLabel.value = Utils.phoneNumberLabel(paymentType)
                if (paymentType?.name?.equals(PaymentType.EMI.name) == true) phoneNumberLabel.value =
                    applicationContext.getString(
                        R.string.payu_mobile_number_registered_with_bank,
                        paymentOption?.bankName
                    )
                else phoneNumberLabel.value =
                    applicationContext.getString(R.string.payu_phone_number)
            }
            PaymentState.VPAEligibility -> {
                editTextInputType.value = InputType.TYPE_TEXT_VARIATION_EMAIL_ADDRESS
                editTextInputLength.value = 100
                phoneNumberLabel.value =
                    applicationContext.getString(R.string.payu_upi_id)
            }
            PaymentState.VpaAndMobileEligibility -> {
                editTextInputType.value = InputType.TYPE_TEXT_VARIATION_EMAIL_ADDRESS
                editTextInputLength.value = 100
                phoneNumberLabel.value =
                    applicationContext.getString(R.string.payu_upi_id_or_phone_number)
            }
        }
    }

    fun verifyNumberClicked(number: String) {
        vpaVerified = number
        updateAdapter.value = false
        val trimmedNumber = number.trim()
        if (trimmedNumber.isEmpty())
            return

        when (paymentType) {
            PaymentType.WALLET -> {
                val hashMap: HashMap<String, String> =
                    paymentOption?.otherParams as HashMap<String, String>
                if (hashMap[SdkUiConstants.CP_BANK_CODE] != SdkUiConstants.CP_TWID) {
                    showLoaderInEditText.value = true
                    showVerifyNumber.value = false

                    val walletOption = paymentOption as WalletOption
                    walletOption.phoneNumber = trimmedNumber
                    SdkUiInitializer.apiLayer?.verifyEligibilityAPI(walletOption, this)
                }
            }
            PaymentType.UPI -> {
                if (Utils.isValidVPA(trimmedNumber)) {
                    showLoaderInEditText.value = true
                    showVerifyNumber.value = false
                    if (paymentOption is UPIOption) {
                        val upiOption = paymentOption as UPIOption
                        upiOption.vpa = trimmedNumber
                        SdkUiInitializer.apiLayer?.verifyEligibilityAPI(upiOption, this)
                    } else handleErrorCase(applicationContext.getString(R.string.payu_please_try_another_payment))
                } else {
                    handleErrorCase(applicationContext.getString(R.string.payu_invalid_vpa))
                    AnalyticsUtils.logVerifyVpa(
                        applicationContext,
                        SdkUiConstants.CP_VERIFY_VPA,
                        false
                    )
                }
            }
            PaymentType.BNPL -> {
                showLoaderInEditText.value = true
                showVerifyNumber.value = false
                paymentOption?.phoneNumber = trimmedNumber
                paymentOption?.let { SdkUiInitializer.apiLayer?.verifyEligibilityAPI(it, this) }
            }
        }
    }

    fun numberEntered(number: String) {
        InternalConfig.isPaymentOptionSelected = false
        showVerifiedImage.value = false
        showVerifyNumber.value = true
        enablePayBtn.value = false
        showVerifiedText.value = false
        isNewNumber = prevVpa != null
        prevVpa = number
        when (paymentFlowState?.paymentState) {
            PaymentState.VPAEligibility -> {
                val siParams = Utils.getSIParams()
                if (siParams != null) {
                    enableVerify.value = number.trim().isNotEmpty()
                    verifiedText.value =
                        applicationContext.getString(R.string.payu_vpa_supported_text)
                    showVerifiedText.value = true
                    verifiedTextColor.value = R.color.payu_color_0065ff
                    updateAdapter.value = number.contains('@')
                } else {
                    showVerifyNumber.value = false
                    if (number.trim().isNotEmpty()) {
                        textErrorMessage.value = ""
                        showVerifyNumber.value = number.contains('@')
                        enableVerify.value = number.contains('@')
                        showGpayMessage.value = false
                        updateAdapter.value = number.contains('@')
                    } else {
                        showGpayMessage.value = false
                    }
                    updateAdapter.value = number.contains('@')
                    enableVerify.value = number.trim().isNotEmpty()
                }
            }
            PaymentState.VpaAndMobileEligibility -> {
                val siParams = Utils.getSIParams()
                if (siParams != null) {
                    enableVerify.value = number.trim().isNotEmpty()
                    verifiedText.value =
                        applicationContext.getString(R.string.payu_vpa_supported_text)
                    showVerifiedText.value = true
                    verifiedTextColor.value = R.color.payu_color_0065ff
                    updateAdapter.value = number.contains('@')
                } else {
                    showVerifyNumber.value = false
                    if (number.trim().isNotEmpty()) {
                        textErrorMessage.value = ""
                        showVerifyNumber.value = number.contains('@')
                        enableVerify.value = number.contains('@')
                        showGpayMessage.value =
                            !number.contains('@') && Utils.isValidNumber(number)
                        updateAdapter.value = number.contains('@')
                        if (Utils.isValidPhoneNumber(number)) {
                            enablePayBtn.value = true
                            callValidateOffer.value = true
                        }
                    } else {
                        showGpayMessage.value = false
                    }
                    updateAdapter.value = number.contains('@')
                    enableVerify.value = number.trim().isNotEmpty()
                }
            }
            PaymentState.MobileEligibility -> {
                when (paymentType) {
                    PaymentType.UPI -> {
                        showVerifyNumber.value = false
                        if (number.trim().isNotEmpty()) {
                            textErrorMessage.value = ""
                            showVerifyNumber.value = false
                            enableVerify.value = !number.contains('@')
                            showGpayMessage.value =
                                !number.contains('@') && Utils.isValidNumber(number)
                            updateAdapter.value = false
                            if (Utils.isValidPhoneNumber(number)) {
                                enablePayBtn.value = true
                                callValidateOffer.value = true
                            }
                        } else {
                            showGpayMessage.value = false
                        }
                        updateAdapter.value = false
                        enableVerify.value = Utils.isValidPhoneNumber(number)
                    }

                    PaymentType.WALLET -> {
                        enableVerify.value = Utils.isValidPhoneNumber(number)
                    }
                    PaymentType.EMI -> {
                        val emiOption = emiOptionList?.get(0) as? EMIOption
                        emiOption?.isEligible?.let { updateUi(emiOption, number, it) }
                    }
                    PaymentType.BNPL -> {
                        val bnplOption = paymentOption as? BnplOption
                        bnplOption?.isEligible?.let { updateUi(bnplOption, number, it) }
                    }
                }
            }
            PaymentState.Mobile -> {
                showVerifyNumber.value = false
                enablePayBtn.value = Utils.isValidPhoneNumber(number)
            }
        }


    }

    private fun updateUi(paymentOption: PaymentOption, number: String, isEligible: Boolean) {
        showVerifyNumber.value = false
        enablePayBtn.value = false
        paymentOption.phoneNumber = number.trim()
        isValidMobileNumber = number.isNotEmpty() && Utils.isValidPhoneNumber(number.trim())
        if (isValidMobileNumber) {
            when {
                isNewNumber -> {
                    showLoaderInEditText.value = true
                    SdkUiInitializer.apiLayer?.verifyEligibilityAPI(
                        paymentOption, this
                    )
                }
                else -> {
                    if (isEligible) {
                        enablePayBtn.value = true
                        phoneFieldColor.value = R.color.one_payu_colorPrimary
                        showVerifiedText.value = false
                    } else {
                        showVerifiedText.value = true
                        verifiedText.value =
                            applicationContext.getString(R.string.payu_mobile_not_eligible_error)
                        isValidMobileNumber = false
                        enablePayBtn.value = false
                        phoneFieldColor.value = R.color.design_default_color_error
                    }
                }
            }
            hideSoftKeyboard.value = true
        }
    }

    fun handleEntered(handle: String) {
        var newVpa =
            prevVpa?.subSequence(0, prevVpa.toString().lastIndexOf('@')).toString() + handle
        vpa.value = newVpa
    }

    override fun eligibilityDetails(apiResponse: ApiResponse) {
        when (paymentType) {
            PaymentType.EMI -> {
                if ((apiResponse.paymentOptionList?.get(0) as EMIOption).isEligible == true) {
                    showVerifiedText.value = false
                    isValidMobileNumber = true
                    enablePayBtn.value = true
                    paymentOption = (apiResponse.paymentOptionList?.get(0) as EMIOption)
                } else {
                    showVerifiedText.value = true
                    verifiedText.value =
                        applicationContext.getString(R.string.payu_mobile_not_eligible_error)
                    isValidMobileNumber = false
                    enablePayBtn.value = false
                    phoneFieldColor.value = R.color.design_default_color_error
                }
                showVerifyNumber.value = false
                showLoaderInEditText.value = false
            }
            PaymentType.UPI -> {
                when (apiResponse.status) {
                    true -> {
                        showVerifyNumber.value = false
                        showLoaderInEditText.value = false
                        showVerifiedImage.value = true
                        showVerifiedText.value = true
                        callValidateOffer.value = true
                        verifiedText.value = apiResponse.successMessage
                        verifiedTextColor.value = R.color.payu_color_36b37e
                        enablePayBtn.value = true
                        AnalyticsUtils.logVerifyVpa(
                            applicationContext,
                            SdkUiConstants.CP_VERIFY_VPA,
                            true
                        )
                    }

                    false -> {
                        if (Utils.getSIParams() != null) {
                            shakeVerfiedText.value = true
                            val errorMessage = apiResponse.errorMessage.ifEmpty {
                                applicationContext.getString(R.string.payu_invalid_vpa)
                            }
                            verifiedText.value = errorMessage
                            handleErrorCase(errorMessage)
                            showVerifiedText.value = true
                            showVerifyNumber.value = true
                            showLoaderInEditText.value = false
                            showVerifiedImage.value = false
                            enablePayBtn.value = false
                        } else {
                            handleErrorCase(apiResponse.errorMessage)
                            AnalyticsUtils.logVerifyVpa(
                                applicationContext,
                                SdkUiConstants.CP_VERIFY_VPA,
                                false
                            )

                        }
                    }
                }
                if (prevVpa != null && !prevVpa.equals(vpaVerified)) {
                    verifyNumberClicked(prevVpa!!)
                }
                hideSoftKeyboard.value = true
                phoneFieldColor.value = R.color.payu_color_338f9dbd
            }
            PaymentType.WALLET -> {
                when (apiResponse.status) {
                    true -> {
                        showVerifyNumber.value = false
                        showLoaderInEditText.value = false
                        showVerifiedImage.value = true
                        showVerifiedText.value = true
                        verifiedText.value = apiResponse.successMessage
                        verifiedTextColor.value = R.color.payu_color_36b37e
                        enablePayBtn.value = true
                        paymentOption?.bankCode?.let {
                            AnalyticsUtils.logVerify(
                                applicationContext,
                                SdkUiConstants.CP_VERIFY,
                                PaymentType.WALLET,
                                it,
                                true
                            )
                        }
                    }

                    false -> {
                        handleErrorCase(apiResponse.errorMessage)
                        paymentOption?.bankCode?.let {
                            AnalyticsUtils.logVerify(
                                applicationContext,
                                SdkUiConstants.CP_VERIFY,
                                PaymentType.WALLET,
                                it,
                                false
                            )
                        }
                    }
                }


            }
            PaymentType.BNPL -> {
                val bnplOption = apiResponse.paymentOptionList?.get(0) as? BnplOption
                when (bnplOption?.isEligible) {
                    true -> {
                        showVerifiedText.value = false
                        verifiedTextColor.value = R.color.payu_color_36b37e
                        phoneFieldColor.value = R.color.one_payu_colorPrimary
                        enablePayBtn.value = true
                        paymentOption?.bankCode?.let {
                            AnalyticsUtils.logVerify(
                                applicationContext,
                                SdkUiConstants.CP_VERIFY,
                                PaymentType.BNPL,
                                it,
                                true
                            )
                        }
                    }

                    false -> {
                        showVerifiedText.value = true
                        verifiedText.value =
                            applicationContext.getString(R.string.payu_mobile_not_eligible_error)
                        isValidMobileNumber = false
                        enablePayBtn.value = false
                        phoneFieldColor.value = R.color.payu_color_de350b
                        verifiedTextColor.value = R.color.payu_color_de350b
                        paymentOption?.bankCode?.let {
                            AnalyticsUtils.logVerify(
                                applicationContext,
                                SdkUiConstants.CP_VERIFY,
                                PaymentType.BNPL,
                                it,
                                false
                            )
                        }
                    }
                }
                showVerifyNumber.value = false
                showLoaderInEditText.value = false
            }
        }
    }

    fun handleErrorCase(errorMessage: String) {
        showVerifyNumber.value = true
        showLoaderInEditText.value = false//
        showVerifiedImage.value = false
        enablePayBtn.value = false
        showVerifiedText.value = true//
        verifiedText.value = errorMessage
        verifiedTextColor.value = R.color.payu_color_de350b
        phoneFieldColor.value = R.color.payu_color_de350b
    }

    fun numberFocusChanged(hasFocus: Boolean) {
        if (hasFocus) {
            if (ViewUtils.isSimSupport(applicationContext) && showPhonePicker) {
                hideSoftKeyboard.value = true
                showPhonePickerDialog.value = (paymentType == PaymentType.WALLET)
            } else hideSoftKeyboard.value = false

            if (SdkUiInitializer.apiLayer?.config?.primaryColor.isNullOrEmpty())
                phoneFieldColor.value = R.color.one_payu_colorPrimary
            else
                phoneFieldColor.value = SdkUiInitializer.apiLayer?.config?.primaryColor

        } else {
            hideSoftKeyboard.value = true
            phoneFieldColor.value = R.color.payu_color_338f9dbd
        }
    }

    fun payButtonClicked(number: String, showSavePaymentSwitch: Boolean) {
        if(MultipleClickHandler.isSafeOnClickListener().not())
            return

        val trimmedNumber = number.trim()
        if (paymentOption != null) {
            when (paymentType) {
                PaymentType.WALLET -> {
                    val walletOption = paymentOption as WalletOption
                    walletOption.phoneNumber = trimmedNumber
                    SdkUiInitializer.apiLayer?.updatePaymentState(
                        Utils.getPaymentModel(
                            walletOption,
                            paymentFlowState
                        ), ViewUtils.getToolbar(
                            applicationContext,
                            walletOption.additionalCharge
                        )
                    )
                }
                PaymentType.UPI -> {
                    if (paymentOption is UPIOption) {
                        val upiOption = paymentOption as UPIOption
                        upiOption.shouldSaveCard = showSavePaymentSwitch
                        if (number.contains('@'))
                            upiOption.vpa = trimmedNumber
                        else {
                            val map = HashMap<String, Any?>()
                            map[SdkUiConstants.CP_BANK_CODE] = SdkUiConstants.CP_TEZOMNI
                            map[SdkUiConstants.CP_PG] = SdkUiConstants.CP_UPI
                            upiOption.phoneNumber = trimmedNumber
                            upiOption.otherParams = map
                        }

                        SdkUiInitializer.apiLayer?.updatePaymentState(
                            Utils.getPaymentModel(
                                upiOption,
                                paymentFlowState
                            ), ViewUtils.getToolbar(
                                applicationContext,
                                upiOption.additionalCharge
                            )
                        )
                    } else handleErrorCase(applicationContext.getString(R.string.payu_please_try_another_payment))
                }

                PaymentType.EMI -> {
                    val emiOption = paymentOption as EMIOption
                    emiOption.phoneNumber = trimmedNumber
                    SdkUiInitializer.apiLayer?.updatePaymentState(
                        Utils.getPaymentModel(
                            emiOption,
                            paymentFlowState
                        ), ViewUtils.getToolbar(
                            applicationContext,
                            emiOption.additionalCharge
                        )
                    )
                }

                PaymentType.BNPL -> {
                    paymentOption?.phoneNumber = trimmedNumber
                    paymentOption?.let {
                        Utils.getPaymentModel(
                            it,
                            paymentFlowState
                        )
                    }?.let {
                        SdkUiInitializer.apiLayer?.updatePaymentState(
                            it, ViewUtils.getToolbar(
                                applicationContext,
                                paymentOption?.additionalCharge
                            )
                        )
                    }
                }

            }
        } else {
            showErrorSnackBar.value = true
        }

    }

    fun shouldShowPhonePicker() {
        showPhonePicker = paymentFlowState?.paymentState == PaymentState.MobileEligibility
    }

    fun phoneNumberPicked(number: String) {
        showPhonePicker = false
        phoneNumberText.value = number.trim().takeLast(10) //take last 10 digits for indian numbers
        verifyNumberClicked(phoneNumberText.value!!)
    }

    fun phonePickerDismissed() {
        showPhonePicker = false
        hideSoftKeyboard.value = false
    }

    fun showConsent() {
        val payUSIParams = Utils.getSIParams()
        isSIMode.value = payUSIParams != null
    }

    internal fun validateOffer(textFieldValue: String) {
        if(shouldCallValidateOfferApi().not())
            return

        if (selectedPaymentOption != null) {
            showAndroidLoader.value = Event(true)
            var bankCode = Utils.getValueFromPaymentOption<String>(
                SdkUiConstants.CP_BANK_CODE,
                selectedPaymentOption?.otherParams as? HashMap<String, Any?>
            ).toString()

            if (selectedPaymentOption?.category.equals(SdkUiConstants.VPA_ELIGIBILITY) && Utils.isValidNumber(textFieldValue)) {
                bankCode = SdkUiConstants.CP_GOOGLE_PAY.replace(" ", "").lowercase()
            }

            val category = Utils.getCategoryForOffer(selectedPaymentOption?.paymentType?.name)
            category?.let {
                SdkUiInitializer.apiLayer?.validateOfferDetails(
                    it, null, bankCode, null, loggedInPhoneNumber = getLoggedInPhoneNumber(), this
                )
            }
        }
    }

}