package com.payu.ui.viewmodel

import android.app.Application
import androidx.lifecycle.MutableLiveData
import com.payu.base.listeners.OnDeleteSavedOptionListener
import com.payu.base.models.ErrorResponse
import com.payu.base.models.PaymentMode
import com.payu.base.models.PaymentOption
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.utils.SdkUiConstants

class SavedOptionsViewModel(application: Application, mParam: Map<String, Any>) :
    BaseViewModel(application) , OnDeleteSavedOptionListener{

    val adapterList: MutableLiveData<ArrayList<PaymentMode>> = MutableLiveData()
    var savedCardsListEmpty: MutableLiveData<Boolean> = MutableLiveData()

    val list = mParam[SdkUiConstants.SAVED_CARDS] as ArrayList<PaymentMode>
    private var deleteIndex: Int  = -1

    init {
        adapterList.value = list
    }

    internal fun callDeleteSavedOptionApi(paymentOption: PaymentOption) {
        SdkUiInitializer.apiLayer?.deleteSavedOption(paymentOption, this)
    }

    override fun onDeletedSuccessfully() {
        list.remove(list[deleteIndex])
        if (list.isEmpty()) savedCardsListEmpty.value = true else {
            adapterList.value = list
        }
    }

    override fun onError(errorResponse: ErrorResponse) {
        apiError.value = errorResponse
    }

    override fun showProgressDialog(showDialog: Boolean) {
        showAndroidLoader.postValue(Event(showDialog))
    }

    internal fun handleDeleteItemClicked(deleteIndex: Int){
        this.deleteIndex = deleteIndex
    }

}