package com.payu.ui.view.fragments.olw

import android.app.Dialog
import android.content.res.ColorStateList
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import androidx.core.content.ContextCompat
import androidx.lifecycle.ViewModelProvider
import com.google.android.material.bottomsheet.BottomSheetDialog
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.models.SimpleStatusBottomSheetData
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.viewmodel.OLWViewModel
import com.payu.ui.viewmodel.PaymentOptionViewModel


class MPinSetStatusFragment : BottomSheetDialogFragment() {

    override fun getTheme(): Int = R.style.PayU_BottomSheetDialogTheme
    override fun onCreateDialog(savedInstanceState: Bundle?): Dialog =
        BottomSheetDialog(requireContext(), theme)

    private var viewModel: PaymentOptionViewModel? = null
    private var simpleStatusBottomSheetData: SimpleStatusBottomSheetData? = null

    private var headerIcon: ImageView? = null
    private var tvHeader: TextView? = null
    private var tvSubHeader: TextView? = null
    private var llStatusInfoContainer: LinearLayout? = null

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        return inflater.inflate(R.layout.payu_layout_mpin_set_status_bottomsheet, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        initViewModel()
        simpleStatusBottomSheetData?.let {
            setUpMPinStatusScreen(it)
        }
    }

    private fun initViewModel() {
        viewModel = activity?.run {
            ViewModelProvider(this)[PaymentOptionViewModel::class.java]
        } ?: throw Exception("Invalid Activity")
    }

    private fun setUpMPinStatusScreen(data: SimpleStatusBottomSheetData) {
        headerIcon = view?.findViewById(R.id.ivHeaderIcon)
        tvHeader = view?.findViewById(R.id.tvHeader)
        tvSubHeader = view?.findViewById(R.id.tvSubheader)
        llStatusInfoContainer = view?.findViewById(R.id.llStatusInfoContainer)

        tvHeader?.text = data.title
        tvSubHeader?.text = data.message
        headerIcon?.background = ContextCompat.getDrawable(requireContext(), data.statusIcon)
        val color = ContextCompat.getColor(requireContext(), data.bgColor)
        llStatusInfoContainer?.backgroundTintList = ColorStateList.valueOf(color)

        viewModel?.performDelayedAction(data.dismissInterval) {
            dismiss()
            viewModel?.showMPinOrTopUpBtSheet(data)
        }

        isCancelable = false
    }

    companion object {
        @JvmStatic
        fun newInstance(simpleStatusBottomSheetData: SimpleStatusBottomSheetData) =
            MPinSetStatusFragment().apply {
                this.simpleStatusBottomSheetData = simpleStatusBottomSheetData
            }
    }

}

