package com.payu.ui.view.fragments.olw

import android.app.Dialog
import android.os.Bundle
import android.text.Editable
import android.text.TextWatcher
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.WindowManager
import android.widget.Button
import android.widget.EditText
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import androidx.appcompat.content.res.AppCompatResources
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.content.ContextCompat
import androidx.lifecycle.ViewModelProvider
import com.google.android.material.bottomsheet.BottomSheetBehavior
import com.google.android.material.bottomsheet.BottomSheetDialog
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import com.payu.base.listeners.OnFetchImageListener
import com.payu.base.models.ImageDetails
import com.payu.base.models.ImageParam
import com.payu.base.models.MPinAction
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.models.WalletCardData
import com.payu.ui.model.utils.AnalyticsUtils
import com.payu.ui.model.utils.ImageViewUtils
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.Utils
import com.payu.ui.model.utils.Utils.removeRupeeSymbolFromPrefix
import com.payu.ui.model.utils.Utils.toDoubleOrZero
import com.payu.ui.model.utils.Utils.toStringFormatted
import com.payu.ui.model.utils.ViewUtils
import com.payu.ui.viewmodel.OLWViewModel
import com.payu.ui.viewmodel.PaymentOptionViewModel
import org.json.JSONObject


class CardBalanceFragment : BottomSheetDialogFragment() {

    override fun getTheme(): Int = R.style.PayU_BottomSheetDialogTheme
    override fun onCreateDialog(savedInstanceState: Bundle?): Dialog {
        val dialog =
            BottomSheetDialog(requireContext(), theme)
        dialog.setOnShowListener {
            val bottomSheet = dialog.findViewById<View>(com.google.android.material.R.id.design_bottom_sheet)
            bottomSheet?.let {
                BottomSheetBehavior.from(it).state = BottomSheetBehavior.STATE_EXPANDED
            }
            dialog.window?.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE)
        }
        return dialog;
    }

    private var viewModel: PaymentOptionViewModel? = null
    private var walletCardData: WalletCardData? = null

    private var primaryBtn: Button? = null
    private var secondaryButton: Button? = null

    private var ivBrandIcon: ImageView? = null
    private var tvCardName: TextView? = null
    private var tvCardBalance: TextView? = null
    private var tvBalanceWarning: TextView? = null
    private var etTopUpAmount: EditText? = null
    private var tvTopUp250: TextView? = null
    private var tvTopUp500: TextView? = null
    private var tvTopUp1000: TextView? = null
    private var tvTopUp2000: TextView? = null
    private var clTopUpContainer: ConstraintLayout? = null
    private var llTopUpDisplayContainer: LinearLayout? = null

    private var llEnterMPinContainer: LinearLayout? = null


    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        return inflater.inflate(R.layout.payu_wallet_details_layout, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        initViewModel()
        walletCardData?.let {
            setUpWalletCardScreen(it)
        }
    }

    private fun initViewModel() {
        viewModel = activity?.run {
            ViewModelProvider(this)[PaymentOptionViewModel::class.java]
        } ?: throw Exception("Invalid Activity")
    }



    private fun setUpWalletCardScreen(data: WalletCardData) {
        ivBrandIcon = view?.findViewById(R.id.ivBrandIcon)
        tvCardName = view?.findViewById(R.id.tvWalletName)
        tvCardBalance = view?.findViewById(R.id.tvBalanceAmount)
        clTopUpContainer = view?.findViewById(R.id.clTopUpContainer)
        llTopUpDisplayContainer = view?.findViewById(R.id.llTopupAmountContainer)
        llEnterMPinContainer = view?.findViewById(R.id.llEnterMPinContainer)
        tvBalanceWarning = view?.findViewById(R.id.tvBalanceWarning)
        primaryBtn = view?.findViewById(R.id.btnAction)
        secondaryButton = view?.findViewById(R.id.btnSecondaryAction)
        ViewUtils.updateBackgroundColor(
            requireContext(),
            primaryBtn,
            SdkUiInitializer.apiLayer?.config?.primaryColor,
            R.color.one_payu_colorPrimary
        )
        llTopUpDisplayContainer?.visibility = View.GONE

        if (data.showInsufficientTag.not()) {
            tvBalanceWarning?.visibility = View.GONE
        } else {
            tvBalanceWarning?.visibility = View.VISIBLE
        }

        if (data.showTopUpCard) {
            etTopUpAmount = view?.findViewById(R.id.etTopUpAmount)
            tvTopUp250 = view?.findViewById(R.id.tvTopUp1)
            tvTopUp500 = view?.findViewById(R.id.tvTopUp2)
            tvTopUp1000 = view?.findViewById(R.id.tvTopUp3)
            tvTopUp2000 = view?.findViewById(R.id.tvTopUp4)
            primaryBtn?.text = data.actionText
            val rupeeSymbol = "₹"
            val defaultValue = data.minTopUpAmountNeeded.toStringFormatted()
            val defaultText = Utils.getFormattedAmount(
                defaultValue.toDoubleOrZero(),
                requireContext()
            ) ?: "$rupeeSymbol$defaultValue"
            var isUpdating = false

            etTopUpAmount?.setText(defaultText)
            etTopUpAmount?.setSelection(defaultText.length)

            etTopUpAmount?.addTextChangedListener(object : TextWatcher {
                override fun beforeTextChanged(
                    s: CharSequence?,
                    start: Int,
                    count: Int,
                    after: Int
                ) {

                }

                override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {

                }

                override fun afterTextChanged(s: Editable?) {
                    etTopUpAmount?.let {
                        // Prevent recursive calls
                        if (isUpdating || s == null) return

                        isUpdating = true

                        val text = s.toString()

                                val cleanText = text.replace(rupeeSymbol, "").replace(",", "")
                                val newText = Utils.getFormattedAmount(
                                        cleanText.toDoubleOrZero(),
                                        requireContext()
                                    )
                                it.setText(newText?:"")
                        newText?.length?.let { it1 -> it.setSelection(it1) }
                        isUpdating = false
                    }

                    validateFields()
                }
            })

            tvTopUp250?.setOnClickListener {
                val total = etTopUpAmount?.text.toString().removeRupeeSymbolFromPrefix().replace(",", "")
                    .toDoubleOrZero() + 250.00
                val formattedAmount = Utils.getFormattedAmount(
                    total,
                    requireContext()
                ) ?: defaultText
                etTopUpAmount?.setText(formattedAmount)
            }

            tvTopUp500?.setOnClickListener {
                val total = etTopUpAmount?.text.toString().removeRupeeSymbolFromPrefix().replace(",", "")
                    .toDoubleOrZero() + 500.00
                val formattedAmount = Utils.getFormattedAmount(
                    total,
                    requireContext()
                ) ?: defaultText
                etTopUpAmount?.setText(formattedAmount)
            }

            tvTopUp1000?.setOnClickListener {
                val total = etTopUpAmount?.text.toString().removeRupeeSymbolFromPrefix().replace(",", "")
                    .toDoubleOrZero() + 1000.00
                val formattedAmount = Utils.getFormattedAmount(
                    total,
                    requireContext()
                ) ?: defaultText
                etTopUpAmount?.setText(formattedAmount)
            }

            tvTopUp2000?.setOnClickListener {
                val total = etTopUpAmount?.text.toString().removeRupeeSymbolFromPrefix().replace(",", "")
                    .toDoubleOrZero() + 2000.00
                val formattedAmount = Utils.getFormattedAmount(
                    total,
                    requireContext()
                ) ?: defaultText
                etTopUpAmount?.setText(formattedAmount)
            }

            llEnterMPinContainer?.visibility = View.GONE
            clTopUpContainer?.visibility = View.VISIBLE
        } else {
            llEnterMPinContainer?.visibility = View.VISIBLE
            clTopUpContainer?.visibility = View.GONE
        }


        tvCardName?.text = data.walletName
        tvCardBalance?.text = Utils.getFormattedAmount(
            data.currentBalance,
            requireContext()
        )
        data.walletIcon?.let {
            ivBrandIcon?.background = ContextCompat.getDrawable(requireContext(), it)
        }

        primaryBtn?.setOnClickListener {
            AnalyticsUtils.logKibanaInfoEvent(
                context = requireContext(),
                eventKey = SdkUiConstants.CP_OLW_LOAD_BALANCE_PROCEED_CLICKED,
                eventValue = JSONObject().apply {
                    put(SdkUiConstants.CP_KEY_WALLET_NAME, data.paymentOption.bankName)
                    put(SdkUiConstants.CP_KEY_MOBILE, viewModel?.getLoggedInPhoneNumber())
                }
            )

            etTopUpAmount?.text?.toString()?.removeRupeeSymbolFromPrefix()?.toDoubleOrZero()?.let {
                data.paymentOption.loadAmount = it.toString()
            }
            if(data.paymentOption.isMPinSet.not())
                viewModel?.showSetMPinBottomSheet(requireContext(), MPinAction.SETMPIN, data.paymentOption)
            else
                viewModel?.showTopUpConfirmationBottomSheet(
                    data.paymentOption
                )
        }

        secondaryButton?.visibility = View.GONE

        val param = ImageParam(
            data.paymentOption,
            false,
            Utils.getDefaultDrawable(data.paymentOption.paymentType)
        )
        SdkUiInitializer.apiLayer?.getImageForPaymentOption(
            param,
            onFetchImageListener = object : OnFetchImageListener {
                override fun onImageGenerated(result: ImageDetails) {
                    ImageViewUtils.setImage(ivBrandIcon, result)
                }
            })

        validateFields()
    }

    fun validateFields() {
        if (walletCardData?.showTopUpCard == true) {
            val rechargeAmount =
                etTopUpAmount?.text.toString().removeRupeeSymbolFromPrefix().replace(",","").toDoubleOrZero()
            if (rechargeAmount >= (walletCardData?.minTopUpAmountNeeded ?: 0.00))
                ViewUtils.enableView(primaryBtn)
            else
                ViewUtils.disableView(primaryBtn)
        }
    }

    companion object {
        @JvmStatic
        fun newInstance(walletCardData: WalletCardData) =
            CardBalanceFragment().apply {
                this.walletCardData = walletCardData
            }
    }

}

