package com.payu.ui.view.fragments.olw

import android.app.Dialog
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.appcompat.widget.AppCompatImageView
import androidx.lifecycle.ViewModelProvider
import com.google.android.material.bottomsheet.BottomSheetDialog
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import com.payu.ui.R
import com.payu.ui.model.models.BottomSheetLoaderData
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.ViewUtils.setPayUDialogSettings
import com.payu.ui.viewmodel.PaymentOptionViewModel


class BottomSheetLoaderFragment : BottomSheetDialogFragment() {

    override fun getTheme(): Int = R.style.PayU_BottomSheetDialogTheme
    override fun onCreateDialog(savedInstanceState: Bundle?): Dialog =
        BottomSheetDialog(requireContext(), theme)

    private var viewModel: PaymentOptionViewModel? = null
    private var bottomSheetLoaderData: BottomSheetLoaderData? = null
    private var payuloader : AppCompatImageView? = null


    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        return inflater.inflate(R.layout.payu_bottomsheet_loader, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        payuloader = view.findViewById(R.id.payu_loader)
        setPayUDialogSettings(payuloader, requireActivity())
        initViewModel()
    }

    private fun initViewModel() {
        viewModel = activity?.run {
            ViewModelProvider(this)[PaymentOptionViewModel::class.java]
        } ?: throw Exception("Invalid Activity")
        viewModel?.setScreenName(SdkUiConstants.CP_L1_CHECKOUT_SCREEN)
    }


    companion object {
        @JvmStatic
        fun newInstance(bottomSheetLoaderData: BottomSheetLoaderData) =
            BottomSheetLoaderFragment().apply {
                this.bottomSheetLoaderData = bottomSheetLoaderData
            }
    }

}

