package com.payu.ui.view.fragments.handlers

import android.content.Context
import android.view.View
import android.view.View.GONE
import android.view.View.VISIBLE
import android.widget.EditText
import android.widget.RelativeLayout
import android.widget.TextView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.lifecycle.LifecycleOwner
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.utils.ViewUtils
import com.payu.ui.view.CustomTextWatcher
import com.payu.ui.view.fragments.InputWatcher
import com.payu.ui.viewmodel.CardBaseViewModel
import com.payu.ui.viewmodel.EmiViewModel

class PanUiHandler(private val cardBaseViewModel: CardBaseViewModel?) : InputWatcher,View.OnFocusChangeListener{

    private var etPanNumber: EditText ? = null
    private var rlPanNumber: EditText ? = null
    private var tvPanNumberLabel: TextView ? = null
    private var panNumberTextWatcher: CustomTextWatcher? = null
    private var tvErrorPan: TextView? = null

    internal fun initPanUi(view: View){
        etPanNumber = view.findViewById(R.id.etPanNumber)
        rlPanNumber = view.findViewById(R.id.etPanNumber)
        tvPanNumberLabel = view.findViewById(R.id.tvPanNumberLabel)
        etPanNumber?.let { panNumberTextWatcher = CustomTextWatcher(it, 6, 0.toChar(), this) }
        etPanNumber?.addTextChangedListener(panNumberTextWatcher)
        tvErrorPan = view.findViewById(R.id.tvErrorPan)
    }

    private fun updatePanNumberView(it: Boolean) {
        if (it) {
            rlPanNumber?.setBackgroundResource(R.drawable.payu_rounded_corner_image_for_edittext)
            etPanNumber?.alpha = 0.5f
            tvPanNumberLabel?.alpha = 0.5f

        } else {
            etPanNumber?.alpha = 1f
            tvPanNumberLabel?.alpha = 1f
        }
    }

    internal fun addPanUIObserver(context: Context) {
        cardBaseViewModel?.disablePanNumber?.observe(context as LifecycleOwner) {
            etPanNumber?.isEnabled = !it
            updatePanNumberView(it)
        }
        cardBaseViewModel?.panNumberError?.observe(context as LifecycleOwner) {
            if (it == null) {
                tvErrorPan?.visibility = GONE
            } else {
                tvErrorPan?.visibility = VISIBLE
                tvErrorPan?.text = it
            }

        }
        cardBaseViewModel?.panNumberFieldColor?.observe(context as LifecycleOwner) {
            if (etPanNumber?.hasFocus() == true) {
                ViewUtils.updateStrokeColor(
                    context , rlPanNumber,
                    SdkUiInitializer.apiLayer?.config?.primaryColor, R.color.one_payu_colorPrimary
                )
            } else {
                ViewUtils.updateStrokeColor(context, rlPanNumber, it)
            }

        }
    }

    override fun onInputReceived(input: String, inputType: Int) {
        (cardBaseViewModel as? EmiViewModel)?.panNumber = input
    }

    override fun onFocusChange(p0: View?, hasFocus: Boolean) {
        (cardBaseViewModel as? EmiViewModel)?.updatePanNumberFocus(hasFocus)
    }
}