package com.payu.ui.view.fragments.handlers

import android.content.Context
import android.view.View
import android.view.View.GONE
import android.view.View.VISIBLE
import android.widget.EditText
import android.widget.ProgressBar
import android.widget.TextView
import androidx.lifecycle.LifecycleOwner
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.utils.ViewUtils
import com.payu.ui.view.CustomTextWatcher
import com.payu.ui.view.fragments.InputWatcher
import com.payu.ui.viewmodel.CardBaseViewModel
import com.payu.ui.viewmodel.EmiViewModel


class MobileUiHandler(private val cardBaseViewModel: CardBaseViewModel) : InputWatcher,View.OnFocusChangeListener {

    private var tvMobileNumberLabel : TextView ? = null
    private var pbMobileNumber: ProgressBar? = null
    private var etMobileNumber: EditText ? = null
    private var tvMobileNumberError: TextView ? = null
    private var mobileNumberTextWatcher: CustomTextWatcher? = null

    internal fun initMobileUI(view: View){
        tvMobileNumberLabel = view.findViewById(R.id.tvMobileNumberLabel)
        pbMobileNumber = view.findViewById(R.id.pbMobileNumber)
        etMobileNumber = view.findViewById(R.id.etMobileNumber)
        tvMobileNumberError = view.findViewById(R.id.tvMobileNumberError)
        etMobileNumber?.setText(SdkUiInitializer.apiLayer?.payUPaymentParams?.phone)
        mobileNumberTextWatcher =
            CustomTextWatcher(etMobileNumber!!, 6, 0.toChar(), this)
        etMobileNumber?.addTextChangedListener(mobileNumberTextWatcher)
        initFocus(etMobileNumber)
    }

    internal fun addMobileUiObserver(
        context: Context
    ) {
        cardBaseViewModel.showMobileNumberProgressBar.observe(
            context as LifecycleOwner
        ) {
            if (it) pbMobileNumber?.visibility = VISIBLE else pbMobileNumber?.visibility = GONE
        }

        cardBaseViewModel.mobileNumberLabelText.observe(
            context as LifecycleOwner
        ) {
            tvMobileNumberLabel?.text = it
        }
    }

    override fun onInputReceived(input: String, inputType: Int) {
        (cardBaseViewModel as? EmiViewModel)?.mobileNumber = input
    }
    private fun initFocus(view: View?) {
        view?.requestFocus()
        etMobileNumber?.text?.toString()
            ?.let { (cardBaseViewModel as EmiViewModel).mobileNumberFocusChanged(true, it) }
        if (view != null) {
            ViewUtils.showSoftKeyboard(view)
        }
    }

    override fun onFocusChange(p0: View?, hasFocus: Boolean) {
        cardBaseViewModel.mobileNumberFocusChanged(
            hasFocus,
            etMobileNumber?.text.toString()
        )
    }
}