package com.payu.ui.view.fragments

import android.annotation.SuppressLint
import android.content.Context
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.View.GONE
import android.view.View.VISIBLE
import android.view.ViewGroup
import android.view.ViewTreeObserver
import android.widget.Button
import android.widget.CheckBox
import android.widget.CompoundButton
import android.widget.ImageView
import android.widget.RelativeLayout
import android.widget.TextView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.widget.NestedScrollView
import androidx.fragment.app.Fragment
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.payu.base.models.EMIOption
import com.payu.base.models.InternalConfig
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentState
import com.payu.base.models.calculateEmi.CalculateEmiRequest
import com.payu.commonui.utils.CommonUIViewUtils
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.adapters.EmiTenuresAdapter
import com.payu.ui.model.utils.ImageViewUtils
import com.payu.ui.model.utils.MultipleClickHandler
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.ViewUtils
import com.payu.ui.model.widgets.RoundedCornerBottomSheet
import com.payu.ui.view.customViews.OfferAppliedDialog
import com.payu.ui.view.fragments.handlers.CardUIHandler
import com.payu.ui.view.fragments.handlers.CvvExpiryUiHandler
import com.payu.ui.view.fragments.handlers.MobileUiHandler
import com.payu.ui.view.fragments.handlers.OfferUIHandler
import com.payu.ui.view.fragments.handlers.PanUiHandler
import com.payu.ui.view.fragments.handlers.TenureUiHandler
import com.payu.ui.view.fragments.handlers.VerifyErrorHandler
import com.payu.ui.viewmodel.BaseViewModelFactory
import com.payu.ui.viewmodel.EmiViewModel
import com.payu.ui.viewmodel.PaymentOptionViewModel

/**
 * A simple [Fragment] subclass.
 * Use the [EmiTenureFragment.newInstance] factory method to
 * create an instance of this fragment.
 */
class EmiTenureFragment : Fragment(),
    View.OnClickListener,
    OfferUIHandler.OfferUIInterface, RoundedCornerBottomSheet.OnBottomSheetListener,
    CompoundButton.OnCheckedChangeListener {
    private var cvvExpiryUiHandler: CvvExpiryUiHandler? = null
    private var cardUIHandler: CardUIHandler? = null
    private var tenureUiHandler: TenureUiHandler? = null
    private var offerUIHandler: OfferUIHandler? = null
    private var paymentOptionViewModel: PaymentOptionViewModel? = null
    private var tvSiSummaryTitleLayout: RelativeLayout? = null
    private var tvSISummary: TextView? = null
    private var isOfferAvailable: Boolean = false
    private var paymentState: PaymentState? = null
    private var btnPay: Button? = null
    private var emiViewModel: EmiViewModel? = null
    private var mobileUiHandler: MobileUiHandler? = null
    private var verifyErrorHandler: VerifyErrorHandler? = null
    private var panUiHandler: PanUiHandler? = null
    private var ivEmiIcon: ImageView? = null
    private var tvFooterWalletName: TextView? = null
    private var emiList: ArrayList<PaymentOption>? = ArrayList()
    private var unFilteredEMIList: ArrayList<PaymentOption>? = ArrayList()
    private var emiTenuresAdapter: EmiTenuresAdapter? = null
    private var roundedCornerBottomSheet: RoundedCornerBottomSheet? = null
    private var emiSummaryLayout: ConstraintLayout? = null
    private var emiSummaryFeeLayout: ConstraintLayout? = null
    private var tvEmiSummary: TextView? = null
    private var tvEmiFeeSummary: TextView? = null
    private var tvOfferTitle: TextView? = null
    private var tvOfferDetails: TextView? = null
    private var transparentView: View? = null
    private var scrollViewEmi: NestedScrollView? = null
    private var llAddCard: ConstraintLayout? = null
    private var globalLayoutListener: ViewTreeObserver.OnGlobalLayoutListener? = null
    private var rlSwitchSaveCard: ConstraintLayout? = null
    private var ivSavedCardNudge: ImageView? = null
    private var btnSaveCardNudgePayNow: Button? = null
    private var tvContinueWithoutSaving: TextView? = null
    private var switchSaveCard: CheckBox? = null
    private var isSaveCardInfoBottomSheet: Boolean = false
    private var selectedEmiOption: EMIOption? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        tenureUiHandler = TenureUiHandler(requireActivity())
        offerUIHandler = OfferUIHandler(this)
        arguments?.let {
            emiList = it.getParcelableArrayList(SdkUiConstants.CP_EMI_LIST)
            paymentState = it.get(SdkUiConstants.CP_PAYMENT_STATE) as? PaymentState
        }
    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        var view: View? = null
        initViewModel()
        when (paymentState) {
            PaymentState.CardTenureEligibility -> {
                view = inflater.inflate(R.layout.fragment_card_tenure, container, false)
                cardUIHandler = emiViewModel?.let { CardUIHandler(it) }
                cardUIHandler?.initCardUI(view)
                cvvExpiryUiHandler = emiViewModel?.let { CvvExpiryUiHandler(it) }
                cvvExpiryUiHandler?.initCVVExpiryUi(view)
            }

            PaymentState.CardnumMobileTenureEligibility -> {
                view = inflater.inflate(R.layout.fragment_cardnum_mobile_tenure, container, false)
                cardUIHandler = emiViewModel?.let { CardUIHandler(it) }
                cardUIHandler?.initCardUI(view)
                mobileUiHandler = emiViewModel?.let { MobileUiHandler(it) }
                mobileUiHandler?.initMobileUI(view)
                verifyErrorHandler = emiViewModel?.let { VerifyErrorHandler(it) }
                verifyErrorHandler?.init(view)
                verifyErrorHandler?.addVerifyObserver(viewLifecycleOwner)
            }

            PaymentState.CardMobileTenureEligibility -> {
                view = inflater.inflate(R.layout.fragment_card_mobile_tenure, container, false)
                cardUIHandler = emiViewModel?.let { CardUIHandler(it) }
                cardUIHandler?.initCardUI(view)
                verifyErrorHandler = emiViewModel?.let { VerifyErrorHandler(it) }
                verifyErrorHandler?.init(view)
                verifyErrorHandler?.addVerifyObserver(viewLifecycleOwner)
                mobileUiHandler = emiViewModel?.let { MobileUiHandler(it) }
                mobileUiHandler?.initMobileUI(view)
                cvvExpiryUiHandler = emiViewModel?.let { CvvExpiryUiHandler(it) }
                cvvExpiryUiHandler?.initCVVExpiryUi(view)
            }

            PaymentState.MobilePanTenureEligibility -> {
                view = inflater.inflate(R.layout.fragment_mobile_pan_tenure, container, false)
                verifyErrorHandler = emiViewModel?.let { VerifyErrorHandler(it) }
                verifyErrorHandler?.init(view)
                verifyErrorHandler?.addVerifyObserver(viewLifecycleOwner)
                mobileUiHandler = emiViewModel?.let { MobileUiHandler(it) }
                mobileUiHandler?.initMobileUI(view)
                panUiHandler = PanUiHandler(emiViewModel)
                panUiHandler?.initPanUi(view)
            }

            PaymentState.CardnumTenureEligibility -> {
                view = inflater.inflate(R.layout.fragment_cardnum_tenure, container, false)
                cardUIHandler = emiViewModel?.let { CardUIHandler(it) }
                cardUIHandler?.initCardUI(view, true)
            }
        }
        if (view != null) {
            initUI(view)
        }
        addObservers()
        addEmiObserver()
        return view
    }

    override fun onAttach(context: Context) {
        super.onAttach(context)
        CommonUIViewUtils.updateLayoutSecurity(
            requireActivity(),
            SdkUiInitializer.apiLayer?.config?.isProtectedScreen == true
        )
    }

    override fun onDetach() {
        super.onDetach()
        CommonUIViewUtils.updateLayoutSecurity(requireActivity(), false)
    }
    companion object {
        /**
         * Use this factory method to create a new instance of
         * this fragment using the provided parameters.
         * @return A new instance of fragment CardTenureFragment.
         */
        @JvmStatic
        fun newInstance(
            emiList: ArrayList<PaymentOption>,
            paymentState: PaymentState? = null
        ) =
            EmiTenureFragment().apply {
                arguments = Bundle().apply {
                    putParcelableArrayList(SdkUiConstants.CP_EMI_LIST, emiList)
                    putSerializable(SdkUiConstants.CP_PAYMENT_STATE, paymentState)
                }
            }
    }

    private fun initUI(view: View) {
        offerUIHandler?.initOfferUI(view)
        tenureUiHandler?.initTenureUI(view, emiViewModel)
        tvSiSummaryTitleLayout = view.findViewById(R.id.tv_si_summary_title_layout)
        tvSISummary = view.findViewById(R.id.tv_si_summary_title)
        ivEmiIcon = view.findViewById(R.id.ivEmiIcon)
        tvFooterWalletName = view.findViewById(R.id.tvFooterEmiName)
        emiSummaryLayout = view.findViewById(R.id.emiSummary)
        emiSummaryFeeLayout = view.findViewById(R.id.emiSummaryProcessingFee)
        tvEmiSummary = emiSummaryLayout?.findViewById(R.id.tv_emi_summary_title)
        tvEmiFeeSummary = emiSummaryFeeLayout?.findViewById(R.id.tv_emi_summary_title)
        tvOfferDetails = view.findViewById(R.id.tvOfferDetails)
        tvOfferTitle = view.findViewById(R.id.tvOfferTitle)
        btnPay = view.findViewById(R.id.btnPay)
        transparentView = view.findViewById(R.id.transparentView)
        scrollViewEmi = view.findViewById(R.id.scrollViewAddCard)
        llAddCard = view.findViewById(R.id.llAddCard)
        switchSaveCard = view.findViewById(R.id.switchSaveCard)
        btnPay?.setOnClickListener(this)
        transparentView?.setOnClickListener(this)
        ivSavedCardNudge = view.findViewById(R.id.ivSavedCardNudge)
        rlSwitchSaveCard = view.findViewById(R.id.rlSwitchSaveCard)
        ivSavedCardNudge?.setOnClickListener(this)
        switchSaveCard?.setOnCheckedChangeListener(this)
        ViewUtils.updateBackgroundColor(
            requireContext(),
            btnPay,
            SdkUiInitializer.apiLayer?.config?.primaryColor,
            R.color.one_payu_colorPrimary
        )
        ViewUtils.updateButtonTextColor(btnPay, SdkUiInitializer.apiLayer?.config?.baseTextColor)

    }

    private fun initViewModel() {
        paymentOptionViewModel = activity?.run {
            ViewModelProvider(this)[PaymentOptionViewModel::class.java]
        } ?: throw Exception("Invalid Activity")

        val map = HashMap<String, Any>()
        map[SdkUiConstants.CP_EMI_LIST] = emiList!!
        map[SdkUiConstants.CP_PAYMENT_STATE] = paymentState!!
        emiViewModel = ViewModelProvider(
            this,
            BaseViewModelFactory(requireActivity().application, map)
        )[EmiViewModel::class.java]
    }

    private fun addObservers() {
        emiViewModel?.siHeaderSummary?.observe(viewLifecycleOwner) { value ->
            if (value != null && value.isNotEmpty()) {
                tvSiSummaryTitleLayout?.visibility = VISIBLE
                tvSISummary?.text = value
            }
        }
        emiViewModel?.isOfferAvailable?.observe(viewLifecycleOwner) {
            isOfferAvailable = it
        }

        emiViewModel?.isReadyToPay?.observe(viewLifecycleOwner) {
            if (it!!)
                ViewUtils.enableView(btnPay) else ViewUtils.disableView(btnPay)
        }

        emiViewModel?.emiIcon?.observe(viewLifecycleOwner) {
            ImageViewUtils.setImage(ivEmiIcon, it)
        }
        emiViewModel?.emiFooterTitle?.observe(viewLifecycleOwner) {
            tvFooterWalletName?.text = it
        }
        emiViewModel?.updateEmiList?.observe(viewLifecycleOwner) {
            emiList = ArrayList()
            it?.forEach { it1 ->
                emiList?.add((it1 as EMIOption).clone() as EMIOption)
            }
        }
        emiViewModel?.showBottomSheet?.observe(viewLifecycleOwner) {
            showBottomSheet(it)
        }
        emiViewModel?.hideBottomSheet?.observe(
            viewLifecycleOwner
        ) {
            if (it) roundedCornerBottomSheet?.dismiss()
        }
        emiViewModel?.hideBottomSheet?.observe(viewLifecycleOwner) {
            if (it) roundedCornerBottomSheet?.dismiss()
        }
        emiViewModel?.showProgressDialog?.observe(viewLifecycleOwner) { showProgressDialog ->
            if (showProgressDialog)
                ViewUtils.showProgressDialog(context)
            else
                ViewUtils.hideProgressDialog()
        }
        emiViewModel?.showAndroidLoader?.observe(viewLifecycleOwner) {
            if (it.getContentIfNotHandled() == true)
                ViewUtils.showProgressDialog(context)
            else
                ViewUtils.hideProgressDialog()
        }

        emiViewModel?.showEmiSummary?.observe(viewLifecycleOwner) {
            if (it != null) {
                emiSummaryLayout?.visibility = VISIBLE
                tvEmiSummary?.text = it
            } else emiSummaryLayout?.visibility = GONE
        }
        emiViewModel?.emiFeeSummary?.observe(viewLifecycleOwner) {
            if (it != null) {
                emiSummaryFeeLayout?.visibility = VISIBLE
                tvEmiFeeSummary?.text = it
            } else emiSummaryFeeLayout?.visibility = GONE
        }

        paymentOptionViewModel?.validateOffer?.observe(viewLifecycleOwner) {
            if (it)
                emiViewModel?.validateOffer(SdkUiConstants.CP_EMI)
        }

        paymentOptionViewModel?.showChangeOfferView?.observe(viewLifecycleOwner) {
            if (it && (!InternalConfig.isPaymentOptionSelected || InternalConfig.selectedOfferInfo?.isValidated == true)) {
                unFilteredEMIList = emiList
                emiList = paymentOptionViewModel?.handleEMITenureOnOfferSelection(unFilteredEMIList)
                emiList?.let {
                    InternalConfig.userSelectedOfferInfo?.let { userSelectedOffer ->
                        emiViewModel?.callCalculateEmiRequest(
                            arrayListOf(
                                userSelectedOffer.offerKey ?: ""
                            )
                        )
                    }
                }
                val offerKeysList = ArrayList<String>()
                InternalConfig.selectedOfferInfo?.offerMap?.keys?.forEach { offerKey ->
                    offerKeysList.add(offerKey)
                }
            } else if (it) {
                emiList?.let {
                    InternalConfig.userSelectedOfferInfo?.let { userSelectedOffer ->
                        emiViewModel?.callCalculateEmiRequest(
                            arrayListOf(
                                userSelectedOffer.offerKey ?: ""
                            )
                        )
                    }
                }
            } else {
                if (!unFilteredEMIList.isNullOrEmpty()) {
                    emiList = unFilteredEMIList
                    unFilteredEMIList?.let { it1 -> emiViewModel?.updateDefaultEmiList(it1) }
                }
            }

        }

        emiViewModel?.showOfferApplied?.observe(viewLifecycleOwner) {
            it.getContentIfNotHandled()?.let { isOfferAvailable ->
                paymentOptionViewModel?.showChangeOfferView(
                    shouldShowChangeOffer = isOfferAvailable
                )
                if (!isOfferAvailable) emiViewModel?.updateOfferTextValue(false)
            }
        }

        emiViewModel?.updateSelectedPaymentOption?.observe(viewLifecycleOwner) {
            selectedEmiOption = it
        }

        emiViewModel?.updateHeaderAmount?.observe(viewLifecycleOwner) {
            paymentOptionViewModel?.updateHeaderAmount(
                it,
                gstFlatValue = selectedEmiOption?.cardBinInfo?.gstFlatValue ?: 0.0,
                gstPercentageValue = selectedEmiOption?.gstPercentageValue ?: 0.0,
                additionalCharge = selectedEmiOption?.additionalCharge ?: 0.0,
                isOfferValid = ((InternalConfig.selectedOfferInfo?.totalInstantDiscount != null) || InternalConfig.emiOfferInfo != null)
            )
        }

        emiViewModel?.calculateEmi?.observe(viewLifecycleOwner) {
            emiViewModel?.calculateNoCostEmiTenures(it)
        }

        emiViewModel?.makePayment?.observe(viewLifecycleOwner) {
            emiViewModel?.makePayment()
        }

        emiViewModel?.validateOfferBottomSheet?.observe(viewLifecycleOwner) {
            paymentOptionViewModel?.showSkuBottomSheet(false)
        }
        emiViewModel?.validateOfferCall?.observe(viewLifecycleOwner) {
            emiViewModel?.validateOffer(it)
        }

        emiViewModel?.showErrorSnackBar?.observe(viewLifecycleOwner) {
            ViewUtils.showSnackBar(
                requireContext().resources.getString(R.string.payu_tenure_revisit_message),
                R.drawable.payu_emi,
                requireActivity()
            )
        }

        emiViewModel?.showTransparentView?.observe(viewLifecycleOwner) {
            if (it) showTransparentView() else hideTransparentView()
        }

        emiViewModel?.showOfferAppliedDialog?.observe(viewLifecycleOwner) {
            if (it.getContentIfNotHandled() == true) {
                val offerAppliedDialog = OfferAppliedDialog(requireContext())
                offerAppliedDialog.showOfferDialog(paymentOptionViewModel?.selectedPaymentOption)
                emiViewModel?.updateOfferTextValue(true)
            }
        }


        emiViewModel?.showOfferError?.observe(viewLifecycleOwner) {
            if (it.first.getContentIfNotHandled() == true) {
                InternalConfig.selectedOfferInfo?.let {
                    ViewUtils.showSnackBar(
                        InternalConfig.selectedOfferInfo?.failureReason
                            ?: requireContext().getString(R.string.payu_offer_not_applicable_on_this),
                        R.drawable.verification, requireActivity(),
                        R.color.payu_color_FCE9E9
                    )
                }
                emiViewModel?.updateOfferTextValue(true)
            }
        }

        emiViewModel?.hideSoftKeyboard?.observe(viewLifecycleOwner) {
            if (it) ViewUtils.hideSoftKeyboard(activity)
        }
        emiViewModel?.showSavedCardSwitch?.observe(viewLifecycleOwner) {
            if (it) rlSwitchSaveCard?.visibility = VISIBLE
            else rlSwitchSaveCard?.visibility = GONE
        }
        emiViewModel?.isSaveCardInfoBottomSheet?.observe(viewLifecycleOwner) {
            isSaveCardInfoBottomSheet = it
        }

        emiViewModel?.calculateEmiApi?.observe(viewLifecycleOwner) {
            if (it.getContentIfNotHandled() == true) {
                val offerKeysList = ArrayList<String>()
                InternalConfig.selectedOfferInfo?.offerMap?.keys?.forEach { offerKey ->
                    offerKeysList.add(offerKey)
                }
                val calculateEmiRequest = CalculateEmiRequest(
                    autoApplyOffer = false,
                    emiCodes = emiViewModel?.getSelectedEmiCode() ?: listOf(),
                    offerKeys = offerKeysList,
                    txnAmount = SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDoubleOrNull()
                        ?: 0.0
                )
                emiViewModel?.calculateNoCostEmiTenures(calculateEmiRequest)
            }
        }
    }

    override fun onClick(p0: View?) {
        when (p0?.id) {
            R.id.btnPay -> {
                if (MultipleClickHandler.isSafeOnClickListener()) {
                    ViewUtils.hideSoftKeyboard(requireActivity())
                    switchSaveCard?.isChecked?.let { emiViewModel?.updateEmiOptionForSavedCard(it) }
                    if (rlSwitchSaveCard?.visibility == VISIBLE && switchSaveCard?.isChecked == false) {
                        emiViewModel?.handleSavedCardNudge()
                    } else {
                        emiViewModel?.makePayment()
                        CommonUIViewUtils.updateLayoutSecurity(requireActivity(), false)
                    }
                }
            }

            R.id.tvRemoveOfferButton -> if (MultipleClickHandler.isSafeOnClickListener()) {
                paymentOptionViewModel?.showChangeOfferView(false)
                emiViewModel?.updateEmiListOnRemoveOffer()
                emiViewModel?.updateOfferTextValue(false)
            }

            R.id.transparentView -> emiViewModel?.transparentViewClicked()
            R.id.ivSavedCardNudge -> {
                emiViewModel?.handleSavedCardInfoNudge()
            }

            R.id.tvOfferDetails -> {
                paymentOptionViewModel?.showSkuBottomSheet(true)
            }

        }
    }

    private fun addEmiObserver() {
        cvvExpiryUiHandler?.addCvvExpiryObserver(
            requireActivity()
        )
        emiViewModel?.let { viewModel ->
            cardUIHandler?.addCardObserver(requireContext())
            tenureUiHandler?.addTenureObserver(viewModel, requireContext())
            paymentOptionViewModel?.let {
                offerUIHandler?.addOfferObserver(
                    requireContext(),
                    it
                )
            }
        }
        mobileUiHandler?.addMobileUiObserver(requireContext())
        panUiHandler?.addPanUIObserver(requireContext())
    }

    override fun removeOfferClick() {
        paymentOptionViewModel?.showChangeOfferView(false)
        emiViewModel?.updateEmiListOnRemoveOffer()
        emiViewModel?.updateOfferTextValue(false)
    }

    override fun showSkuDetailsBtSheet() {
        paymentOptionViewModel?.showSkuBottomSheet(true)
    }

    private fun populateEmiTenureAdapter(
        inflatedView: View,
    ) {
        if (emiList.isNullOrEmpty()) return //return if list is empty

        val rvEmiTenures = inflatedView.findViewById<RecyclerView>(R.id.rvEmiTenures)
        val ivClose = inflatedView.findViewById<ImageView>(R.id.ivCloseIcon)
        ivClose?.setOnClickListener {
            roundedCornerBottomSheet?.dismiss()
        }
        rvEmiTenures?.layoutManager = LinearLayoutManager(context)
        if (emiTenuresAdapter == null)
            emiTenuresAdapter = EmiTenuresAdapter(
                emiList
            ) { emiOption, tenureText, totalAmountText ->
                emiViewModel?.tenureSelected(emiOption, tenureText, totalAmountText)
            }
        else emiTenuresAdapter?.setList(emiList!!)
        rvEmiTenures?.adapter = emiTenuresAdapter
    }

    override fun getInflatedView(view: View, roundedCornerBottomSheet: RoundedCornerBottomSheet) {
        populateEmiTenureAdapter(view)
        addSaveCardBottomSheetObserver(view)
    }

    override fun handleBottomSheetClose() {
        roundedCornerBottomSheet?.dismiss()

    }

    override fun bottomSheetDetach() {

    }

    override fun bottomSheetAttach() {
    }

    private fun showBottomSheet(layout: Int) {
        if (!requireActivity().isFinishing && !requireActivity().isDestroyed) {
            roundedCornerBottomSheet =
                RoundedCornerBottomSheet.newInstance(layout)
            roundedCornerBottomSheet?.show(
                requireActivity().supportFragmentManager,
                roundedCornerBottomSheet?.tag
            )
            roundedCornerBottomSheet?.setListener(this)
        }
    }

    @SuppressLint("ClickableViewAccessibility")
    private fun showTransparentView() {
        globalLayoutListener = ViewUtils.attachViewTreeListener(llAddCard, transparentView)
        transparentView?.visibility = VISIBLE
        //disable scroll when transparent view is visible
        scrollViewEmi?.setOnTouchListener { _, _ -> true }
    }

    @SuppressLint("ClickableViewAccessibility")
    private fun hideTransparentView() {
        ViewUtils.removeViewTreeListener(globalLayoutListener, llAddCard)
        transparentView?.visibility = GONE
        //enable scroll when transparent view is hidden
        scrollViewEmi?.setOnTouchListener(null)
    }

    private fun addSaveCardBottomSheetObserver(view: View) {
        btnSaveCardNudgePayNow = view.findViewById(R.id.btnSaveCardNudgePayNow)
        tvContinueWithoutSaving = view.findViewById(R.id.tvContinueWithoutSaving)
        ViewUtils.updateBackgroundColor(
            requireContext(),
            btnSaveCardNudgePayNow,
            SdkUiInitializer.apiLayer?.config?.primaryColor,
            R.color.one_payu_colorPrimary
        )
        ViewUtils.updateButtonTextColor(
            btnSaveCardNudgePayNow,
            SdkUiInitializer.apiLayer?.config?.baseTextColor
        )
        if (isSaveCardInfoBottomSheet) {
            btnSaveCardNudgePayNow?.text = resources.getString(R.string.payu_back)
            tvContinueWithoutSaving?.visibility = GONE
            btnSaveCardNudgePayNow?.setOnClickListener {
                emiViewModel?.bottomSheetCloseClicked()
            }
        } else {
            btnSaveCardNudgePayNow?.text = resources.getString(R.string.payu_save_card_and_pay)
            btnSaveCardNudgePayNow?.setOnClickListener {
                emiViewModel?.handlePayNow(isSaveCardInfoBottomSheet)
                emiViewModel?.makePayment()
                CommonUIViewUtils.updateLayoutSecurity(requireActivity(), false)
            }
            tvContinueWithoutSaving?.setOnClickListener {
                emiViewModel?.bottomSheetCloseClicked()
                emiViewModel?.makePayment()
                CommonUIViewUtils.updateLayoutSecurity(requireActivity(), false)
            }
        }
    }

    override fun onCheckedChanged(p0: CompoundButton?, p1: Boolean) {
        when (p0?.id) {
            R.id.switchSaveCard -> {
                if (!p1) {
                    /**
                     * When screen launches, saved card toggle is enabled. So this flag avoids showing snackbar for
                     * first time when screen loads. Rest everytime, snackbar is displayed, when enabled.
                     * */
                    ViewUtils.showSnackBar(
                        resources.getString(R.string.payu_this_card_will_not_be_saved),
                        R.drawable.payu_cards_placeholder,
                        activity
                    )
                } else {
                    ViewUtils.showSnackBar(
                        resources.getString(R.string.payu_this_card_will_be_saved),
                        R.drawable.payu_cards_placeholder,
                        activity
                    )
                }
                emiViewModel?.selectedEmiOption?.shouldSaveCard = p1
            }
        }
    }

    override fun onDestroyView() {
        verifyErrorHandler?.clear()
        super.onDestroyView()
    }

}
