package com.payu.ui.view.fragments

import android.annotation.SuppressLint
import android.content.Context
import android.nfc.NfcAdapter
import android.os.Bundle
import android.text.InputFilter
import android.text.InputFilter.LengthFilter
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.View.GONE
import android.view.View.VISIBLE
import android.view.ViewGroup
import android.view.ViewTreeObserver.OnGlobalLayoutListener
import android.view.animation.AccelerateInterpolator
import android.view.animation.AlphaAnimation
import android.view.animation.Animation
import android.view.animation.DecelerateInterpolator
import android.widget.Button
import android.widget.CheckBox
import android.widget.CompoundButton
import android.widget.CompoundButton.OnCheckedChangeListener
import android.widget.EditText
import android.widget.ImageView
import android.widget.ProgressBar
import android.widget.TextView
import android.widget.Toast
import androidx.appcompat.widget.SwitchCompat
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.constraintlayout.widget.Group
import androidx.core.content.ContextCompat
import androidx.core.view.isVisible
import androidx.core.widget.NestedScrollView
import androidx.fragment.app.Fragment
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.payu.base.listeners.OnFetchImageListener
import com.payu.base.models.CardBinInfo
import com.payu.base.models.EMIOption
import com.payu.base.models.ImageDetails
import com.payu.base.models.ImageParam
import com.payu.base.models.InternalConfig
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentState
import com.payu.base.models.PaymentType
import com.payu.base.models.SavedCardOption
import com.payu.base.models.calculateEmi.CalculateEmiRequest
import com.payu.cardscanner.PayU
import com.payu.cardscanner.callbacks.PayUCardListener
import com.payu.cardscanner.model.PUCardRecognizer
import com.payu.cardscanner.model.PUError
import com.payu.commonui.utils.CommonUIViewUtils
import com.payu.nfc.PayUNFC
import com.payu.nfc.interfaces.PayUNFCCallback
import com.payu.nfc.model.CardDetails
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.adapters.EmiTenuresAdapter
import com.payu.ui.model.managers.NetworkManager
import com.payu.ui.model.utils.AnalyticsUtils
import com.payu.ui.model.utils.ImageViewUtils
import com.payu.ui.model.utils.MultipleClickHandler
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.Utils
import com.payu.ui.model.utils.ViewUtils
import com.payu.ui.model.utils.ViewUtils.hideSoftKeyboard
import com.payu.ui.model.widgets.MonitoringEditText
import com.payu.ui.model.widgets.RoundedCornerBottomSheet
import com.payu.ui.view.CustomTextWatcher
import com.payu.ui.view.customViews.OfferAppliedDialog
import com.payu.ui.viewmodel.AddNewCardViewModel
import com.payu.ui.viewmodel.BaseViewModelFactory
import com.payu.ui.viewmodel.PaymentOptionViewModel


class AddCardFragment : Fragment(), InputWatcher, View.OnClickListener, OnCheckedChangeListener,
    View.OnFocusChangeListener,
    RoundedCornerBottomSheet.OnBottomSheetListener,
    MonitoringEditText.OnMonitorListener {

    private val TAG = "AddCardFragment"

    private var etCardNumber: MonitoringEditText? = null
    private var etBajajCardNumber: EditText? = null
    private var rlCardNumber: ConstraintLayout? = null
    private var rlCvv: ConstraintLayout? = null
    private var etExpiry: EditText? = null
    private var etNameOnCard: EditText? = null
    private var rlExpiry: ConstraintLayout? = null
    private var etCvv: EditText? = null
    private var ivToolTipCvv: ImageView? = null
    private var ivIssuerImage: ImageView? = null
    private var ivToolTipExpiry: ImageView? = null
    private var tvOfferText: TextView? = null
    private var tvErrorExpiry: TextView? = null
    private var tvErrorCvv: TextView? = null
    private var btnPay: Button? = null
    private var addNewCardViewModel: AddNewCardViewModel? = null
    private var paymentOptionViewModel: PaymentOptionViewModel? = null
    private var cardTextWatcher: CustomTextWatcher? = null
    private var expiryTextWatcher: CustomTextWatcher? = null
    private var cvvTextWatcher: CustomTextWatcher? = null
    private var nameOnCardTextWatcher: CustomTextWatcher? = null
    private var mobileNumberTextWatcher: CustomTextWatcher? = null
    private var bajajCardNumberTextWatcher: CustomTextWatcher? = null
    private var switchSaveCard: CheckBox? = null
    private val cardDivider = 5
    private val expiryDivider = 3
    private val expirySeparator = '/'
    private var tvAddNewCard: TextView? = null
    private var transparentView: View? = null
    private var llAddCard: ConstraintLayout? = null
    private var globalLayoutListener: OnGlobalLayoutListener? = null
    private var scrollViewAddCard: NestedScrollView? = null
    private var rlEmiInstallment: ConstraintLayout? = null
    private var rlEmiTenuresLayout: ConstraintLayout? = null
    private var tvCardNumberLabel: TextView? = null
    private var tvConsentText: TextView? = null
    private var isSIMode: Boolean = false
    private var llNameOnCard: ConstraintLayout? = null
    private val animationDuration: Long = 500
    private var isAnimationStarted = false
    private var additionalCharges: Double? = 0.0
    private var gstAmount: Double? = 0.0
    private var gstPercent: Double? = 0.0
    private var tvMobileNumberLabel: TextView? = null
    private var rlMobileNumber: ConstraintLayout? = null
    private var tvMobileNumberError: TextView? = null
    private var etMobileNumber: EditText? = null
    private var pbMobileNumber: ProgressBar? = null
    private var ivWallet: ImageView? = null
    private var tvFooterWalletName: TextView? = null
    private var tvSISummary: TextView? = null
    private var tvSiSummaryTitleLayout: ConstraintLayout? = null
    private var initiatedFrom: String = SdkUiConstants.CP_CARDS
    private var ivCameraImage: ImageView? = null
    private var removeOfferButton: TextView? = null
    private var tvOfferTitle: TextView? = null
    private var tvOfferDetails: TextView? = null
    private var tvOfferDisc: TextView? = null
    private var changeOfferOption: ConstraintLayout? = null
    private var isOfferAvailable: Boolean = false
    private var bankCode: String? = null
    private var rlNameOnCard: View? = null
    private var tvAmount: TextView? = null
    private var tvTotalAmountDisplay: TextView? = null
    private var last4digitCards: TextView? = null
    private var etCardNumberGv: MonitoringEditText? = null
    private var iv_issuer_image_gv: ImageView? = null
    private var paymentOption: PaymentOption? = null
    private var rlSwitchSaveCard: ConstraintLayout? = null
    private var switchEmiLayout: SwitchCompat? = null
    private var rlSwitchEmi: Group? = null
    private var ivSavedCardNudge: ImageView? = null
    private var btnSaveCardNudgePayNow: Button? = null
    private var tvContinueWithoutSaving: TextView? = null
    private var roundedCornerBottomSheet: RoundedCornerBottomSheet? = null
    private var emiList: ArrayList<PaymentOption>? = null
    private var emiTenuresAdapter: EmiTenuresAdapter? = null
    private var tvSelectInstallment: TextView? = null
    private var tvEmiInterest: TextView? = null
    private var isSaveCardInfoBottomSheet: Boolean = false
    private var tvNoCostEmi: TextView? = null
    private var emiSummaryLayout: ConstraintLayout? = null
    private var emiSummaryFeeLayout: ConstraintLayout? = null
    private var tvEmiSummary: TextView? = null
    private var tvEmiFeeSummary: TextView? = null
    private var tvEmiCashBackText: TextView? = null
    private var isEmiTxn: Boolean = false
    private var btnPayLayout: ConstraintLayout? = null
    private var progressLoader: ProgressBar?= null
    private var mNfcAdapter: NfcAdapter? = null
    private var ivNfcImage: ImageView? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        arguments?.let {
            if (null != it.get(SdkUiConstants.INITIATED_FROM))
                initiatedFrom = it.getString(SdkUiConstants.INITIATED_FROM).toString()
            paymentOption = it.getParcelable(SdkUiConstants.PAYMENT_OPTION)

        }
        mNfcAdapter = NfcAdapter.getDefaultAdapter(activity);
    }

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        val view = inflater.inflate(R.layout.add_card_layout, container, false)
        initUI(view)
        initViewModel()
        getScreenName()
        if (initiatedFrom == SdkUiConstants.GLOBAL_VAULT)
            initTextWatchers(etCardNumberGv)
        else initTextWatchers(etCardNumber)
        addObservers()

        return view
    }

    override fun onAttach(context: Context) {
        super.onAttach(context)
        CommonUIViewUtils.updateLayoutSecurity(
            requireActivity(),
            SdkUiInitializer.apiLayer?.config?.isProtectedScreen == true
        )
    }


    override fun onDetach() {
        super.onDetach()
        CommonUIViewUtils.updateLayoutSecurity(requireActivity(), false)
    }

    private fun initFocus(view: View?) {
        view?.requestFocus()
        addNewCardViewModel?.cardNumberFocused(true)
        if (view != null) {
            ViewUtils.showSoftKeyboard(view)
        }
    }

    private fun getScreenName() {
        if (initiatedFrom == PaymentType.EMI.name) paymentOptionViewModel?.setScreenName("L4 $initiatedFrom")
        else paymentOptionViewModel?.setScreenName("L3 $initiatedFrom")
    }

    private fun initUI(view: View) {
        tvConsentText = view.findViewById(R.id.tv_consent_text)
        etCardNumber = view.findViewById(R.id.et_add_card)
        etBajajCardNumber = view.findViewById(R.id.et_bajaj_card_no)
        rlCardNumber = view.findViewById(R.id.rlCardNumber)
        rlCvv = view.findViewById(R.id.rlCvv)
        etExpiry = view.findViewById(R.id.etExpiry)
        etNameOnCard = view.findViewById(R.id.etNameOnCard)
        rlExpiry = view.findViewById(R.id.rlExpiry)
        switchSaveCard = view.findViewById(R.id.switchSaveCard)
        switchEmiLayout = view.findViewById(R.id.switchEmiLayout)
        etCvv = view.findViewById(R.id.etCvv)
        ivToolTipCvv = view.findViewById(R.id.ivToolTipCvv)
        ivIssuerImage = view.findViewById(R.id.iv_issuer_image)
        ivCameraImage = view.findViewById(R.id.iv_camera_image)
        ivCameraImage?.setOnClickListener(this)
        ivToolTipExpiry = view.findViewById(R.id.ivToolTipExpiry)
        tvErrorExpiry = view.findViewById(R.id.tvErrorExpiry)
        tvErrorCvv = view.findViewById(R.id.tvErrorCvv)
        tvOfferText = view.findViewById(R.id.tvOfferText)
        tvAddNewCard = view.findViewById(R.id.tvAddNewCard)
        btnPayLayout = view.findViewById(R.id.payButtonLayout)
        btnPay = btnPayLayout?.findViewById(R.id.btnPay)
        progressLoader = btnPayLayout?.findViewById(R.id.cpbProgressBarBtn)
        transparentView = view.findViewById(R.id.transparentView)
        llAddCard = view.findViewById(R.id.llAddCard)
        scrollViewAddCard = view.findViewById(R.id.scrollViewAddCard)
        rlEmiInstallment = view.findViewById(R.id.rlEmiInstallment)
        rlEmiTenuresLayout = view.findViewById(R.id.rlEmiTenuresLayout)
        tvCardNumberLabel = view.findViewById(R.id.tvCardNumberLabel)
        tvMobileNumberLabel = view.findViewById(R.id.tvMobileNumberLabel)
        rlMobileNumber = view.findViewById(R.id.rlMobileNumber)
        tvMobileNumberError = view.findViewById(R.id.tvMobileNumberError)
        etMobileNumber = view.findViewById(R.id.etMobileNumber)
        etMobileNumber?.setText(SdkUiInitializer.apiLayer?.payUPaymentParams?.phone)
        llNameOnCard = view.findViewById(R.id.llNameOnCard)
        pbMobileNumber = view.findViewById(R.id.pbMobileNumber)
        ivWallet = view.findViewById(R.id.ivEmiIcon)
        tvFooterWalletName = view.findViewById(R.id.tvFooterEmiName)
        tvSISummary = view.findViewById(R.id.tv_si_summary_title)
        tvSiSummaryTitleLayout = view.findViewById(R.id.siSummary)
        tvOfferTitle = view.findViewById(R.id.tvOfferTitle)
        tvOfferDetails = view.findViewById(R.id.tvOfferDetails)
        tvOfferDisc = view.findViewById(R.id.tvOfferDisc)
        removeOfferButton = view.findViewById(R.id.tvRemoveOfferButton)
        changeOfferOption = view.findViewById(R.id.changeOfferOption)
        tvTotalAmountDisplay = view.findViewById(R.id.tvTotalAmountDisplay)
        rlSwitchSaveCard = view.findViewById(R.id.rlSwitchSaveCard)
        tvSelectInstallment = view.findViewById(R.id.tvSelectInstallment)
        tvEmiInterest = view.findViewById(R.id.tvEmiInterest)
        tvNoCostEmi = view.findViewById(R.id.tvNoCostEmi)
        emiSummaryLayout = view.findViewById(R.id.emiSummary)
        emiSummaryFeeLayout = view.findViewById(R.id.emiSummaryProcessingFee)
        tvEmiSummary = emiSummaryLayout?.findViewById(R.id.tv_emi_summary_title)
        tvEmiFeeSummary = emiSummaryFeeLayout?.findViewById(R.id.tv_emi_summary_title)
        tvEmiCashBackText = view.findViewById(R.id.tvEmiCashBackText)
        removeOfferButton?.setOnClickListener(this)
        transparentView?.setOnClickListener(this)
        btnPay?.setOnClickListener(this)
        ivToolTipExpiry?.setOnClickListener(this)
        ivToolTipCvv?.setOnClickListener(this)
        etCardNumber?.onFocusChangeListener = this
        etMobileNumber?.onFocusChangeListener = this
        etBajajCardNumber?.onFocusChangeListener = this
        etCardNumber?.onMonitorListener = this
        etExpiry?.onFocusChangeListener = this
        etCvv?.onFocusChangeListener = this
        etNameOnCard?.onFocusChangeListener = this
        switchSaveCard?.setOnCheckedChangeListener(this)
        switchEmiLayout?.setOnCheckedChangeListener(this)
        rlEmiInstallment?.setOnClickListener(this)
        rlNameOnCard = view.findViewById(R.id.rlNameOnCard)
        ViewUtils.updateBackgroundColor(
            requireContext(),
            btnPay,
            SdkUiInitializer.apiLayer?.config?.primaryColor,
            R.color.one_payu_colorPrimary
        )
        ViewUtils.updateButtonTextColor(btnPay, SdkUiInitializer.apiLayer?.config?.baseTextColor)
        etCardNumberGv = view.findViewById(R.id.etAddCardGv)
        last4digitCards = view.findViewById(R.id.last4digitCards)
        val cardNumberSize = (paymentOption as? SavedCardOption)?.cardNumber?.length ?: 0
        if (cardNumberSize > 4) {
            val last4DigitCard = (paymentOption as? SavedCardOption)?.cardNumber?.substring(
                cardNumberSize - 4,
                cardNumberSize
            )
            last4digitCards?.text = last4DigitCard
        }
        iv_issuer_image_gv = view.findViewById(R.id.iv_issuer_image_gv)
        etCardNumberGv?.onFocusChangeListener = this
        etCardNumberGv?.onMonitorListener = this
        rlSwitchEmi = view.findViewById(R.id.rlSwitchEmi)
        ivSavedCardNudge = view.findViewById(R.id.ivSavedCardNudge)
        ivSavedCardNudge?.setOnClickListener(this)
        if (!Utils.isSdkAvailable(SdkUiConstants.CP_CARD_SCANNER)) {
            ivCameraImage?.visibility = View.GONE
        }

        val param = paymentOption?.let {
            ImageParam(
                it,
                true,
                R.drawable.payu_cards_placeholder
            )
        }
        if (param != null) {
            SdkUiInitializer.apiLayer?.getImageForPaymentOption(
                param,
                object : OnFetchImageListener {
                    override fun onImageGenerated(result: ImageDetails) {
                        ImageViewUtils.setImage(iv_issuer_image_gv, result)
                    }
                })
        }

        if (initiatedFrom == SdkUiConstants.GLOBAL_VAULT)
            last4digitCards?.visibility = VISIBLE
        tvOfferDetails?.setOnClickListener(this)

        ivNfcImage = view.findViewById(R.id.iv_nfc_image)
        ivNfcImage?.setOnClickListener(this)

        if (InternalConfig.isNfcEnabled && PayUNFC.isNfcSupportedAndReady(activity as? Context))
            ivNfcImage?.visibility = VISIBLE
    }

    private fun addObservers() {
        addNewCardViewModel?.cardScheme?.observe(
            viewLifecycleOwner
        ) {
            if (null != it) {

//                    addNewCardViewModel?.cardOption?.cardBinInfo = CardBinInfo()
                addNewCardViewModel?.cardOption?.cardBinInfo?.cardScheme = it
                val param = ImageParam(
                    addNewCardViewModel?.cardOption!!,
                    true,
                    R.drawable.payu_cards_placeholder
                )
                SdkUiInitializer.apiLayer?.getImageForPaymentOption(
                    param,
                    object : OnFetchImageListener {
                        override fun onImageGenerated(result: ImageDetails) {
                            ImageViewUtils.setImage(ivIssuerImage, result)
                        }
                    })
            } else {
                ivIssuerImage?.setImageResource(R.drawable.payu_cards_placeholder)
            }
        }
        addNewCardViewModel?.cardBinAdditionalCharge?.observe(viewLifecycleOwner) {
            additionalCharges = it
        }
        addNewCardViewModel?.cardBinGstAmount?.observe(viewLifecycleOwner) {
            gstPercent = it?.first
            gstAmount = it?.second
            if (InternalConfig.selectedOfferInfo?.totalInstantDiscount != null) {
                val amount = SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDouble()
                    ?.minus(InternalConfig.selectedOfferInfo?.totalInstantDiscount!!)
                paymentOptionViewModel?.updateHeaderAmount(
                    amount = amount,
                    additionalCharge = additionalCharges,
                    gstFlatValue = it.second,
                    gstPercentageValue = it.first,
                    isOfferValid = true
                )
            } else {
                paymentOptionViewModel?.updateHeaderAmount(
                    additionalCharge = additionalCharges,
                    gstFlatValue = it.second,
                    gstPercentageValue = it.first,
                    isOfferValid = false
                )
            }
        }

        addNewCardViewModel?.cvvLength?.observe(viewLifecycleOwner) {
            etCvv?.filters = arrayOf<InputFilter>(LengthFilter(it!!))

        }
        (addNewCardViewModel)?.updateEmiList?.observe(viewLifecycleOwner) {
            emiList = ArrayList()
            it?.forEach { it1 ->
                emiList?.add((it1 as EMIOption).clone() as EMIOption)
            }
        }
        addNewCardViewModel?.cardError?.observe(viewLifecycleOwner) {
            if (it == null) {
                if (etCardNumber!!.hasFocus())
                    ViewUtils.updateStrokeColor(
                        requireActivity(),
                        rlCardNumber,
                        SdkUiInitializer.apiLayer?.config?.primaryColor,
                        R.color.one_payu_colorPrimary
                    )
                else ViewUtils.updateStrokeColor(requireContext(), rlCardNumber)
                tvOfferText?.text = resources.getString(R.string.payu_offer_s)
                tvOfferText?.visibility = GONE
                tvOfferText?.setTextColor(
                    ContextCompat.getColor(
                        requireContext(),
                        R.color.payu_color_36b37e
                    )
                )

            } else {
                ViewUtils.updateStrokeColor(
                    requireContext(),
                    rlCardNumber,
                    R.color.payu_color_de350b
                )
                tvOfferText?.text = it
                tvOfferText?.visibility = VISIBLE
                tvOfferText?.setTextColor(
                    ContextCompat.getColor(
                        requireContext(),
                        R.color.payu_color_de350b
                    )
                )

            }
        }

        addNewCardViewModel?.cardOffer?.observe(viewLifecycleOwner) {
            if (!it.isNullOrEmpty()) {
                rlCardNumber?.setBackgroundResource(R.drawable.payu_rounded_corner_image_for_edittext)
                tvOfferText?.text = it
                tvOfferText?.visibility = VISIBLE
            } else {
                tvOfferText?.visibility = GONE
            }
            etCardNumber?.let { it1 -> addNewCardViewModel?.requestFocusOnOfferApplied(it1) }
        }
        addNewCardViewModel?.siHeaderSummary?.observe(viewLifecycleOwner) { value ->
            if (value != null && value.isNotEmpty()) {
                tvSiSummaryTitleLayout?.visibility = VISIBLE
                tvSISummary?.text = value
            }
        }
        addNewCardViewModel?.expiryError?.observe(viewLifecycleOwner) {
            if (it == null) {
                ViewUtils.updateStrokeColor(requireContext(), rlExpiry)
                tvErrorExpiry?.visibility = GONE
            } else {
                ViewUtils.updateStrokeColor(requireContext(), rlExpiry, R.color.payu_color_de350b)
                tvErrorExpiry?.visibility = VISIBLE
                tvErrorExpiry?.text = it
            }
        }

        addNewCardViewModel?.cvvError?.observe(viewLifecycleOwner) {
            if (it == null) {
                ViewUtils.updateStrokeColor(requireContext(), rlCvv)
                tvErrorCvv?.visibility = GONE
            } else {
                ViewUtils.updateStrokeColor(requireContext(), rlCvv, R.color.payu_color_de350b)
                tvErrorCvv?.visibility = VISIBLE
                tvErrorCvv?.text = it
            }
        }
        addNewCardViewModel?.cardBinBankDownStatus?.observe(viewLifecycleOwner) {

            if (it != null) {
                addNewCardViewModel?.isBankDown = it
                val isCardBinsupported = addNewCardViewModel?.isCardBinSupported
                if (it && isCardBinsupported!!) {
                    rlCardNumber?.setBackgroundResource(R.drawable.payu_rounded_corner_image_red)
                    tvOfferText?.text = resources.getString(R.string.payu_bankdown)
                    tvOfferText?.visibility = VISIBLE

                    tvOfferText?.setTextColor(
                        ContextCompat.getColor(
                            requireContext(),
                            R.color.payu_color_de350b
                        )
                    )
                }
            }
        }

        addNewCardViewModel?.highlightCardNumber?.observe(viewLifecycleOwner) {
            if (it) {
                ViewUtils.updateStrokeColor(
                    requireContext(),
                    rlCardNumber,
                    SdkUiInitializer.apiLayer?.config?.primaryColor,
                    R.color.one_payu_colorPrimary
                )
            } else {
                ViewUtils.updateStrokeColor(requireContext(), rlCardNumber)
            }
        }

        addNewCardViewModel?.highlightCardName?.observe(viewLifecycleOwner) {
            if (it) {
                ViewUtils.updateStrokeColor(
                    requireContext(),
                    rlNameOnCard,
                    SdkUiInitializer.apiLayer?.config?.primaryColor,
                    R.color.one_payu_colorPrimary
                )
            } else {
                ViewUtils.updateStrokeColor(requireContext(), rlNameOnCard)
            }
        }

        addNewCardViewModel?.highlightCardExpiry?.observe(viewLifecycleOwner) {
            if (it) {
                ViewUtils.updateStrokeColor(
                    requireContext(),
                    rlExpiry,
                    SdkUiInitializer.apiLayer?.config?.primaryColor,
                    R.color.one_payu_colorPrimary
                )
                tvErrorExpiry?.visibility = GONE
            } else {
                ViewUtils.updateStrokeColor(requireContext(), rlExpiry)
            }
        }

        addNewCardViewModel?.highlightCardCvv?.observe(viewLifecycleOwner) {
            if (it) {
                ViewUtils.updateStrokeColor(
                    requireContext(),
                    rlCvv,
                    SdkUiInitializer.apiLayer?.config?.primaryColor,
                    R.color.one_payu_colorPrimary
                )
                tvErrorCvv?.visibility = GONE
            } else {
                ViewUtils.updateStrokeColor(requireContext(), rlCvv)
            }
        }

        addNewCardViewModel?.isReadyToPay?.observe(viewLifecycleOwner) {
            if (it!!)
                ViewUtils.enableView(btnPay) else ViewUtils.disableView(btnPay)
        }

        addNewCardViewModel?.clearExpiry?.observe(viewLifecycleOwner) {
            if (it) etExpiry?.text?.clear()
        }

        addNewCardViewModel?.offerTextColor?.observe(viewLifecycleOwner) {
            tvOfferText?.setTextColor(ContextCompat.getColor(requireContext(), it))
        }

        addNewCardViewModel?.showTransparentView?.observe(viewLifecycleOwner) {
            if (it) showTranparentView() else hideTransparentView()
        }

        addNewCardViewModel?.expiryToolTip?.observe(viewLifecycleOwner) {
            if (it != null) {
                ViewUtils.showTextToolTip(requireActivity(), ivToolTipExpiry!!, null, it)
            }
        }

        addNewCardViewModel?.cvvToolTip?.observe(viewLifecycleOwner) {
            if (it != null) {
                ViewUtils.showImageToolTip(requireActivity(), ivToolTipCvv!!, null, it)
            }
        }

        addNewCardViewModel?.hideToolTip?.observe(viewLifecycleOwner) {
            if (it) ViewUtils.hideToolTip()
        }

        addNewCardViewModel?.cardNumberLabel?.observe(viewLifecycleOwner) {
            tvCardNumberLabel?.text = it
        }

        (addNewCardViewModel)?.showBottomSheet?.observe(viewLifecycleOwner) {
            showBottomSheet(it)
        }

        (addNewCardViewModel)?.hideBottomSheet?.observe(viewLifecycleOwner) {
            if (it) roundedCornerBottomSheet?.dismiss()
        }

        (addNewCardViewModel)?.selectedTenure?.observe(viewLifecycleOwner) {
            tvSelectInstallment?.text = it
        }
        (addNewCardViewModel)?.selectedTenureBankCode?.observe(viewLifecycleOwner) {
            bankCode = it
        }

        addNewCardViewModel?.resetSelectedTenurePosition?.observe(viewLifecycleOwner) {
            emiTenuresAdapter?.selectedPosition = -1
            tvSelectInstallment?.text = requireContext().getText(R.string.payu_select_installment)
        }

        (addNewCardViewModel)?.showEmiInterestText?.observe(viewLifecycleOwner) {
            if (it) tvEmiInterest?.visibility = VISIBLE else tvEmiInterest?.visibility =
                GONE
        }
        (addNewCardViewModel)?.tenureInterest?.observe(viewLifecycleOwner) {
            tvEmiInterest?.text = it
        }

        (addNewCardViewModel)?.highlightEmiField?.observe(viewLifecycleOwner) {
            if (it) {
                ViewUtils.updateStrokeColor(
                    requireContext(),
                    rlEmiInstallment,
                    SdkUiInitializer.apiLayer?.config?.primaryColor,
                    R.color.one_payu_colorPrimary
                )
                if (context != null) {
                    tvSelectInstallment?.setTextColor(
                        ContextCompat.getColor(
                            requireContext(),
                            R.color.payu_color_0d1b2e
                        )
                    )
                    tvTotalAmountDisplay?.setTextColor(
                        ContextCompat.getColor(
                            requireContext(),
                            R.color.payu_color_0d1b2e
                        )
                    )
                }
            } else ViewUtils.updateStrokeColor(requireContext(), rlEmiInstallment)

        }


        (addNewCardViewModel)?.hideSoftKeyboard?.observe(viewLifecycleOwner) {
            if (it) ViewUtils.hideSoftKeyboard(activity)
        }


        addNewCardViewModel?.cardCategory?.observe(
            viewLifecycleOwner
        ) {
            if (null != it) {
                if (addNewCardViewModel?.cardOption?.cardBinInfo == null)
                    addNewCardViewModel?.cardOption?.cardBinInfo = CardBinInfo()
                addNewCardViewModel?.cardOption?.cardBinInfo?.cardCategory = it

            }
        }

        addNewCardViewModel?.cardType?.observe(
            viewLifecycleOwner
        ) {
            if (null != it) {
                if (addNewCardViewModel?.cardOption?.cardBinInfo == null)
                    addNewCardViewModel?.cardOption?.cardBinInfo = CardBinInfo()
                addNewCardViewModel?.cardOption?.cardBinInfo?.cardType = it

            }
        }


        addNewCardViewModel?.isSIMode?.observe(viewLifecycleOwner) {
            isSIMode = it
            if (it) tvConsentText?.visibility = VISIBLE
            else tvConsentText?.visibility = GONE
        }

        addNewCardViewModel?.showNameOnCardView?.observe(viewLifecycleOwner) {
            if (it) showNameOnCardView() else hideNameOnCardView()
        }

        addNewCardViewModel?.showProgressDialog?.observe(viewLifecycleOwner) { showProgressDialog ->
            if (showProgressDialog)
                ViewUtils.showProgressDialog(context)
            else
                ViewUtils.hideProgressDialog()
        }

        addNewCardViewModel?.showAndroidLoader?.observe(viewLifecycleOwner) {
            if (it.getContentIfNotHandled() == true)
                ViewUtils.showProgressDialog(context)
            else
                ViewUtils.hideProgressDialog()
        }


        addNewCardViewModel?.cardNumberValid?.observe(viewLifecycleOwner) {
            if (it) {
                rlCardNumber?.setBackgroundResource(R.drawable.payu_rounded_corner_image_for_edittext)
                // TODO: we need to apply the regex
//                etExpiry!!.requestFocus()
                addNewCardViewModel?.validateOffer()
            }
        }

        addNewCardViewModel?.cvvValid?.observe(viewLifecycleOwner) {
            if (it) {
                ViewUtils.hideSoftKeyboard(activity)
                etCvv!!.clearFocus()
            }
        }

        addNewCardViewModel?.expiryValid?.observe(viewLifecycleOwner) {
            if (it) etCvv!!.requestFocus()
        }

        paymentOptionViewModel?.showChangeOfferView?.observe(viewLifecycleOwner) { value ->
            if (value && (!InternalConfig.isPaymentOptionSelected || InternalConfig.selectedOfferInfo?.isValidated == true)) {
                changeOfferOption?.visibility = VISIBLE
                val offerKeySet = HashSet<String>()
                InternalConfig.selectedOfferInfo?.offerMap?.values?.forEach {
                    it.offerKey?.let { it1 -> offerKeySet.add(it1) }
                }
                val length = offerKeySet.size
                if (length > 1) {
                    tvOfferTitle?.text = requireContext().getString(
                        R.string.payu_offer_applied_text,
                        length.toString()
                    )
                    tvOfferDisc?.visibility = GONE
                } else if (length == 1) {
                    val offerKey = InternalConfig.selectedOfferInfo?.offerMap?.keys?.first()
                    tvOfferTitle?.text =
                        InternalConfig.selectedOfferInfo?.offerMap?.get(offerKey)?.title
                    tvOfferDisc?.visibility = VISIBLE
                    tvOfferDisc?.text =
                        InternalConfig.selectedOfferInfo?.offerMap?.get(offerKey)?.description
                } else changeOfferOption?.visibility = GONE
                if (InternalConfig.selectedOfferInfo?.isSkuOffer == true) tvOfferDetails?.visibility =
                    VISIBLE else tvOfferDetails?.visibility = GONE
            } else {
                changeOfferOption?.visibility = GONE
            }
        }

        paymentOptionViewModel?.updateOffer?.observe(viewLifecycleOwner) {
            if (it) {
                val amount = InternalConfig.selectedOfferInfo?.totalInstantDiscount?.let { it1 ->
                    SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDouble()?.minus(
                        it1
                    )
                }
                paymentOptionViewModel?.updateHeaderAmount(
                    amount = amount,
                    additionalCharge = additionalCharges,
                    gstFlatValue = gstAmount,
                    gstPercentageValue = gstPercent,
                    isOfferValid = InternalConfig.selectedOfferInfo?.totalInstantDiscount != null
                )
            } else {
                paymentOptionViewModel?.resetHeaderAmount(isOfferValid = InternalConfig.selectedOfferInfo?.totalInstantDiscount != null)
            }
//            if (addNewCardViewModel?.cardOption?.cardBinInfo != null) {
//                addNewCardViewModel?.updateOfferValue()
//            }
        }

        addNewCardViewModel?.isOfferAvailable?.observe(viewLifecycleOwner) {
            isOfferAvailable = it
        }

        addNewCardViewModel?.showCardNoGV?.observe(viewLifecycleOwner) {
            if (it) {
                etCardNumberGv?.visibility = VISIBLE
                last4digitCards?.visibility = VISIBLE
                iv_issuer_image_gv?.visibility = VISIBLE
                rlCardNumber?.visibility = GONE
                etCardNumber?.visibility = GONE
            } else {
                etCardNumberGv?.visibility = GONE
                last4digitCards?.visibility = GONE
                iv_issuer_image_gv?.visibility = GONE
            }
        }
        addNewCardViewModel?.showEmiLayoutSwitch?.observe(viewLifecycleOwner) {
            if (it) {
                rlSwitchEmi?.visibility = VISIBLE
            } else {
                rlSwitchEmi?.visibility = GONE
            }
            switchEmiLayout?.isChecked = false
        }
        addNewCardViewModel?.showErrorSnackBar?.observe(viewLifecycleOwner) {
            if (activity?.isDestroyed == false && activity?.isFinishing == false) {
                ViewUtils.showSnackBar(
                    getString(R.string.payu_payment_option_error_message),
                    R.drawable.payu_emi,
                    activity
                )
            }
        }
        addNewCardViewModel?.showEmiTenureLayout?.observe(viewLifecycleOwner) {
            if (it) {
                rlEmiTenuresLayout?.visibility =
                    VISIBLE
                emiTenuresAdapter?.selectedPosition = -1
                tvSelectInstallment?.text =
                    requireContext().getText(R.string.payu_select_installment)
                tvSelectInstallment?.setTextColor(
                    ContextCompat.getColor(
                        requireActivity(),
                        R.color.payu_color_8f9dbd
                    )
                )
                tvEmiInterest?.text = null
            } else rlEmiTenuresLayout?.visibility = GONE
        }
        addNewCardViewModel?.validateOfferCall?.observe(viewLifecycleOwner) {
            addNewCardViewModel?.validateOffer(it)
        }
        addNewCardViewModel?.showOfferApplied?.observe(viewLifecycleOwner) {
            it.getContentIfNotHandled()?.let { isOfferAvailable ->
                paymentOptionViewModel?.showChangeOfferView(isOfferAvailable)
                if (!isOfferAvailable) addNewCardViewModel?.updateOfferTextValue(false)
                if (InternalConfig.selectedOfferInfo?.totalInstantDiscount != null) {
                    val amount = SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDouble()
                        ?.minus(InternalConfig.selectedOfferInfo?.totalInstantDiscount!!)
                    paymentOptionViewModel?.updateHeaderAmount(
                        amount = amount,
                        additionalCharge = additionalCharges,
                        gstFlatValue = gstAmount,
                        gstPercentageValue = gstPercent,
                        isOfferValid = true
                    )
                } else {
                    paymentOptionViewModel?.updateHeaderAmount(
                        additionalCharge = additionalCharges,
                        gstFlatValue = gstAmount,
                        gstPercentageValue = gstPercent,
                        isOfferValid = false
                    )
                }
            }

        }
        addNewCardViewModel?.showOfferAppliedDialog?.observe(viewLifecycleOwner) {
            if (it.getContentIfNotHandled() == true) {
                val offerAppliedDialog = OfferAppliedDialog(requireContext())
                offerAppliedDialog.showOfferDialog(paymentOptionViewModel?.selectedPaymentOption)
                addNewCardViewModel?.updateOfferTextValue(true)
            }
        }

        addNewCardViewModel?.showOfferError?.observe(viewLifecycleOwner) {
            if (it.first.getContentIfNotHandled() == true) {
                InternalConfig.selectedOfferInfo?.let {
                    ViewUtils.showSnackBar(
                        InternalConfig.selectedOfferInfo?.failureReason
                            ?: requireContext().getString(R.string.payu_offer_not_applicable_on_this),
                        R.drawable.verification, requireActivity(),
                        R.color.payu_color_FCE9E9
                    )
                }
                addNewCardViewModel?.updateOfferTextValue(false)
            }
        }
        addNewCardViewModel?.showSavedCardSwitch?.observe(viewLifecycleOwner) {
            if (it) rlSwitchSaveCard?.visibility = VISIBLE
            else rlSwitchSaveCard?.visibility = GONE
        }

        addNewCardViewModel?.isSaveCardInfoBottomSheet?.observe(viewLifecycleOwner) {
            isSaveCardInfoBottomSheet = it
        }
        addNewCardViewModel?.calculateEmiApi?.observe(viewLifecycleOwner) {
            if (it.getContentIfNotHandled() == true && addNewCardViewModel?.getSelectedEmiCode()
                    ?.isNotEmpty() == true && isEmiTxn
            ) {
                val offerKeysList = ArrayList<String>()
                InternalConfig.selectedOfferInfo?.offerMap?.keys?.forEach { offerKey ->
                    offerKeysList.add(offerKey)
                }
                val calculateEmiRequest = CalculateEmiRequest(
                    autoApplyOffer = false,
                    emiCodes = addNewCardViewModel?.getSelectedEmiCode() ?: listOf(),
                    offerKeys = offerKeysList,
                    txnAmount = SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDoubleOrNull()
                        ?: 0.0
                )
                addNewCardViewModel?.calculateNoCostEmiTenures(calculateEmiRequest)
            }
        }
        addNewCardViewModel?.showErrorSnackBar?.observe(viewLifecycleOwner) {
            ViewUtils.showSnackBar(
                requireContext().resources.getString(R.string.payu_tenure_revisit_message),
                R.drawable.payu_emi,
                requireActivity()
            )
        }

        addNewCardViewModel?.calculateEmi?.observe(viewLifecycleOwner) {
            if (isEmiTxn)
                addNewCardViewModel?.calculateNoCostEmiTenures(it)
        }
        addNewCardViewModel?.showNoCostTag?.observe(viewLifecycleOwner) {
            if (it) tvNoCostEmi?.visibility = VISIBLE
            else tvNoCostEmi?.visibility = GONE
            ViewUtils.updateBackgroundColor(
                requireContext(),
                tvNoCostEmi,
                SdkUiInitializer.apiLayer?.config?.primaryColor,
                R.color.one_payu_colorPrimary
            )
        }

        addNewCardViewModel?.showEmiSummary?.observe(viewLifecycleOwner) {
            if (it != null) {
                emiSummaryLayout?.visibility = VISIBLE
                tvEmiSummary?.text = it
            } else emiSummaryLayout?.visibility = GONE
        }
        addNewCardViewModel?.emiFeeSummary?.observe(viewLifecycleOwner) {
            if (it != null) {
                emiSummaryFeeLayout?.visibility = VISIBLE
                tvEmiFeeSummary?.text = it
            } else emiSummaryFeeLayout?.visibility = GONE
        }

        addNewCardViewModel?.showCashBackTenureText?.observe(viewLifecycleOwner) {
            if (it != null) {
                tvEmiCashBackText?.text = it
                tvEmiCashBackText?.visibility = VISIBLE
            } else tvEmiCashBackText?.visibility = GONE
        }
        paymentOptionViewModel?.validateOffer?.observe(viewLifecycleOwner) {
            if (it)
                addNewCardViewModel?.validateOffer()
        }

        addNewCardViewModel?.updateHeaderAmount?.observe(viewLifecycleOwner) {
            paymentOptionViewModel?.updateHeaderAmount(
                it,
                gstFlatValue = paymentOption?.cardBinInfo?.gstFlatValue ?: 0.0,
                gstPercentageValue = paymentOption?.gstPercentageValue ?: 0.0,
                additionalCharge = paymentOption?.additionalCharge ?: 0.0,
                isOfferValid = ((InternalConfig.selectedOfferInfo?.totalInstantDiscount != null) || InternalConfig.emiOfferInfo != null)
            )
        }

        addNewCardViewModel?.showPayButtonLoader?.observe(viewLifecycleOwner) { it ->
            if(!it.hasBeenHandled){
                it.getContentIfNotHandled()?.let {
                    progressLoader?.isVisible = it
                    btnPay?.isEnabled = it.not()
                }
            }
        }
    }

    private fun hideNameOnCardView() {
        if (llNameOnCard != null && llNameOnCard!!.isVisible && !isAnimationStarted) {
            isAnimationStarted = true
            val fadeOut: Animation = AlphaAnimation(1f, 0f)
            fadeOut.interpolator = AccelerateInterpolator()
            fadeOut.duration = animationDuration
            llNameOnCard?.animation = fadeOut
            fadeOut.setAnimationListener(object : Animation.AnimationListener {
                override fun onAnimationStart(animation: Animation?) {
                }

                override fun onAnimationEnd(animation: Animation?) {
                    isAnimationStarted = false
                    llNameOnCard?.visibility = GONE
                }

                override fun onAnimationRepeat(animation: Animation?) {
                }
            })
        }
    }

    private fun populateEmiTenureAdapter(inflatedView: View) {
        if (emiList.isNullOrEmpty()) return //return if list if empty

        val rvEmiTenures = inflatedView.findViewById<RecyclerView>(R.id.rvEmiTenures)
        rvEmiTenures?.layoutManager = LinearLayoutManager(context)
        if (emiTenuresAdapter == null)
            emiTenuresAdapter = EmiTenuresAdapter(
                emiList
            ) { emiOption, tenureText, totalAmountText ->
                addNewCardViewModel?.tenureSelected(emiOption, tenureText, totalAmountText)
                paymentOptionViewModel?.updateHeaderAmount(
                    additionalCharge = emiOption?.additionalCharge,
                    gstFlatValue = emiOption?.cardBinInfo?.gstFlatValue ?: 0.0,
                    gstPercentageValue = emiOption?.gstPercentageValue ?: 0.0,
                    isOfferValid = true
                )
            }
        else {
            emiList?.let { emiTenuresAdapter?.setList(it) }
        }
        rvEmiTenures?.adapter = emiTenuresAdapter
    }

    private fun showNameOnCardView() {
        llNameOnCard?.visibility = VISIBLE
        val fadeIn: Animation = AlphaAnimation(0f, 1f)
        fadeIn.interpolator = DecelerateInterpolator()
        fadeIn.duration = animationDuration
        llNameOnCard?.animation = fadeIn
    }

    @SuppressLint("ClickableViewAccessibility")
    private fun showTranparentView() {
        globalLayoutListener = ViewUtils.attachViewTreeListener(llAddCard, transparentView)
        transparentView?.visibility = VISIBLE
        //disable scroll when transparent view is visible
        scrollViewAddCard?.setOnTouchListener { _, _ -> true }
    }

    @SuppressLint("ClickableViewAccessibility")
    private fun hideTransparentView() {
        ViewUtils.removeViewTreeListener(globalLayoutListener, llAddCard)
        transparentView?.visibility = GONE
        //enable scroll when transparent view is hidden
        scrollViewAddCard?.setOnTouchListener(null)
    }

    override fun onDestroy() {
        super.onDestroy()
        ViewUtils.removeViewTreeListener(globalLayoutListener, llAddCard)
    }

    private fun initTextWatchers(editText: MonitoringEditText?) {
        cardTextWatcher = CustomTextWatcher(
            editText!!,
            cardDivider,
            addNewCardViewModel!!.cardSeparator[0],
            this
        )
        expiryTextWatcher = CustomTextWatcher(etExpiry!!, expiryDivider, expirySeparator, this)
        cvvTextWatcher = CustomTextWatcher(etCvv!!, 6, 0.toChar(), this)
        nameOnCardTextWatcher = CustomTextWatcher(etNameOnCard!!, 6, 0.toChar(), this)
        mobileNumberTextWatcher = CustomTextWatcher(etMobileNumber!!, 6, 0.toChar(), this)
        bajajCardNumberTextWatcher = CustomTextWatcher(etBajajCardNumber!!, 6, 0.toChar(), this)
        etCardNumber?.addTextChangedListener(cardTextWatcher)
        etExpiry?.addTextChangedListener(expiryTextWatcher)
        etCvv?.addTextChangedListener(cvvTextWatcher)
        etNameOnCard?.addTextChangedListener(nameOnCardTextWatcher)
        etMobileNumber?.addTextChangedListener(mobileNumberTextWatcher)
        etBajajCardNumber?.addTextChangedListener(bajajCardNumberTextWatcher)
        etCardNumberGv?.addTextChangedListener(cardTextWatcher)

    }

    private fun initViewModel() {
        /**
         * We will create ViewModel instance in the fragment using the activity scope so
         * that it will be available for all the fragment of the activity including activity itself.
         * */

        paymentOptionViewModel = activity?.run {
            ViewModelProvider(this)[PaymentOptionViewModel::class.java]
        } ?: throw Exception("Invalid Activity")

        val map = HashMap<String, Any>()
        initFocus(etCardNumber)
        initFocus(etCardNumberGv)
        addNewCardViewModel = ViewModelProvider(
            this, BaseViewModelFactory(
                requireActivity().application,
                map
            )
        )[AddNewCardViewModel::class.java]
        addNewCardViewModel?.initiatedFor(initiatedFrom)
        addNewCardViewModel?.cardOption?.shouldSaveCard = false
        addNewCardViewModel?.sodexoCardOption?.shouldSaveCard = true
    }

    override fun onInputReceived(input: String, inputType: Int) {
        when (inputType) {
            R.id.et_add_card -> addNewCardViewModel?.cardNumber = input
            R.id.etExpiry -> addNewCardViewModel?.cardExpiry = input
            R.id.etCvv -> addNewCardViewModel?.cvv = input
            R.id.etNameOnCard -> addNewCardViewModel?.nameOnCard = input
            R.id.etMobileNumber -> (addNewCardViewModel)?.mobileNumber =
                input

            R.id.etAddCardGv -> {
                addNewCardViewModel?.cardNumber = input.plus(last4digitCards?.text.toString())

            }

        }
    }

    override fun onClick(p0: View?) {
        if (MultipleClickHandler.isSafeOnClickListener()) {
            Log.d(TAG, "onClick called")
            when (p0?.id) {
                R.id.btnPay -> {
                    ViewUtils.hideSoftKeyboard(requireActivity())
                    addNewCardViewModel?.cardOption?.shouldSaveCard = switchSaveCard!!.isChecked
                    if (rlSwitchSaveCard?.visibility == VISIBLE && switchSaveCard?.visibility == VISIBLE && switchSaveCard?.isChecked == false) {
                        addNewCardViewModel?.handleSavedCardNudge()
                    } else {
                        makePayment()
                    }
                }

                R.id.ivToolTipExpiry -> addNewCardViewModel?.toolTipExpiryClicked()
                R.id.ivToolTipCvv -> addNewCardViewModel?.toolTipCvvClicked()
                R.id.transparentView -> addNewCardViewModel?.transparentViewClicked()
                R.id.tvRemoveOfferButton -> {
                    paymentOptionViewModel?.showChangeOfferView(false)
                    InternalConfig.userSelectedOfferInfo = null
                    addNewCardViewModel?.updateEmiListOnRemoveOffer()
                    addNewCardViewModel?.updateOfferTextValue(false)

                }

                R.id.tvOfferDetails -> {
                    paymentOptionViewModel?.showSkuBottomSheet(true)
                }

                R.id.iv_camera_image -> if (Utils.isSdkAvailable(SdkUiConstants.CP_CARD_SCANNER)) {
                    PayU.openScanner(requireContext(), object : PayUCardListener {
                        override fun onFailure(error: PUError) {
                            activity?.let {
                                Toast.makeText(
                                    it.applicationContext,
                                    error.errorDescription.toString(),
                                    Toast.LENGTH_LONG
                                ).show()
                            }
                        }


                        override fun onSuccess(result: PUCardRecognizer) {
                            Log.d(TAG, "Card scan success")
                            etCardNumber?.setText(result.number?.text.toString())
                            setExpiry(result)
                        }
                    })
                }

                R.id.ivSavedCardNudge -> {
                    addNewCardViewModel?.handleSavedCardInfoNudge()
                }

                R.id.rlEmiInstallment -> {
                    rlEmiInstallment?.isFocusableInTouchMode = true
                    rlEmiInstallment?.requestFocus()
                    rlEmiInstallment?.isFocusableInTouchMode = false
                    (addNewCardViewModel)?.showBottomSheet()
                    (addNewCardViewModel)?.emiTenuresClicked()
                }
                R.id.iv_nfc_image -> {
                    val isEnabled = PayUNFC.isNFCEnabled(activity as? Context);
                    hideSoftKeyboard(activity);
                    if (!isEnabled) {
                        PayUNFC.enableNFC(activity as? Context);
                    } else {
                        AnalyticsUtils.logNFCImpression(activity as Context, SdkUiConstants.CP_NFC_ENTRY)
                        PayUNFC.startNFCReading(activity as? Context, object : PayUNFCCallback {
                            override fun onNFCReadSuccess(response: Any) {
                                if (response is CardDetails) {
                                    val cardNumber = response.cardNumber
                                    val expiryMonth = response.expiryMonth
                                    val expiryYear = if (response.expiryYear?.length ?: 0 == 4)
                                    {
                                        response.expiryYear.substring(2, 4)
                                    } else {
                                        ""
                                    }
                                    if (cardNumber.isNotEmpty()) {
                                        etCardNumber?.setText(cardNumber)
                                    }
                                    if (expiryMonth.isNotEmpty() && expiryYear.isNotEmpty()) {
                                        etExpiry?.setText("$expiryMonth/$expiryYear");
                                    }
                                    AnalyticsUtils.logNFCImpression(activity as Context, SdkUiConstants.CP_NFC_READ_SUCCESS)
                                }
                                else {
                                    AnalyticsUtils.logNFCImpression(activity as Context, SdkUiConstants.CP_NFC_READ_FAILURE)
                                }
                            }

                            override fun onNFCReadFailure(
                                errorCode: Int,
                                errorMessage: String
                            ) {
                                AnalyticsUtils.logNFCImpression(activity as Context, SdkUiConstants.CP_NFC_READ_FAILURE)
                            }
                        })
                    }
                }
            }
        }
    }

    fun makePayment() {
        if (ViewUtils.isInternetAvailable(requireContext())) {
            ViewUtils.dismissSnackBar()
            addNewCardViewModel?.cardOption?.nameOnCard = etNameOnCard?.text.toString().trim()
            addNewCardViewModel?.makePayment()
            CommonUIViewUtils.updateLayoutSecurity(requireActivity(), false)
        } else {
            NetworkManager.registerReceiver(requireContext().applicationContext)
            ViewUtils.showSnackBar(
                resources.getString(R.string.payu_no_internet_connection),
                R.drawable.payu_no_internet,
                activity
            )
        }
    }

    override fun onCheckedChanged(p0: CompoundButton?, p1: Boolean) {
        when (p0?.id) {
            R.id.switchSaveCard -> {
                if (!p1) {
                    /**
                     * When screen launches, saved card toggle is enabled. So this flag avoids showing snackbar for
                     * first time when screen loads. Rest everytime, snackbar is displayed, when enabled.
                     * */
                    tvAddNewCard?.text = resources.getString(R.string.payu_enter_card_details)
                    ViewUtils.showSnackBar(
                        resources.getString(R.string.payu_this_card_will_not_be_saved),
                        R.drawable.payu_cards_placeholder,
                        activity
                    )
                } else {
                    tvAddNewCard?.text = resources.getString(R.string.payu_add_new_card)
                    ViewUtils.showSnackBar(
                        resources.getString(R.string.payu_this_card_will_be_saved),
                        R.drawable.payu_cards_placeholder,
                        activity
                    )
                }
                addNewCardViewModel?.updateSodexoOption(p1)
                addNewCardViewModel?.updateEmiOptionForSavedCard(p1)
            }

            R.id.switchEmiLayout -> {
                isEmiTxn = p1
                addNewCardViewModel?.showEmiTenure(p1)
                paymentOptionViewModel?.handlePayUsingEMI(p1, emiList)
                if (!p1)
                    addNewCardViewModel?.clearBinAndFetchBin()
            }
        }
    }

    override fun onFocusChange(v: View?, hasFocus: Boolean) {

        when (v?.id) {
            R.id.et_add_card -> {
                if (!ViewUtils.isInternetAvailable(requireContext())) {
                    showNetworkErrorForSIMode()
                }
                addNewCardViewModel?.cardNumberFocused(hasFocus)
            }

            R.id.etExpiry -> addNewCardViewModel?.cardExpiryFocused(hasFocus)
            R.id.etCvv -> addNewCardViewModel?.cardCvvFocused(hasFocus)
            R.id.etNameOnCard -> addNewCardViewModel?.updateCardNameFocusView(hasFocus)
        }
    }

    private fun showNetworkErrorForSIMode() {
        NetworkManager.registerReceiver(requireContext().applicationContext)
        ViewUtils.showSnackBar(
            resources.getString(R.string.payu_no_internet_connection),
            R.drawable.payu_no_internet,
            activity
        )

    }

    override fun onPause() {
        super.onPause()
        ViewUtils.hideSoftKeyboard(activity)

    }

    companion object {
        /**
         * Use this factory method to create a new instance of
         * this fragment using the provided parameters.
         *
         * @param emiList emi banks list
         * @return A new instance of fragment NetBankingFragment.
         */
        @JvmStatic
        fun newInstance(
            emiList: ArrayList<PaymentOption>,
            paymentState: PaymentState? = null,
            initiatedFrom: String? = null
        ) =
            AddCardFragment().apply {
                arguments = Bundle().apply {
                    putParcelableArrayList(SdkUiConstants.CP_EMI_LIST, emiList)
                    putSerializable(SdkUiConstants.CP_PAYMENT_STATE, paymentState)
                    putSerializable(SdkUiConstants.INITIATED_FROM, initiatedFrom)
                }
            }

        @JvmStatic
        fun newInstance(
            initiatedFrom: String
        ) =
            AddCardFragment().apply {
                arguments = Bundle().apply {
                    putSerializable(SdkUiConstants.INITIATED_FROM, initiatedFrom)
                }
            }

        @JvmStatic
        fun newInstance(
            initiatedFrom: String,
            paymentOption: PaymentOption?
        ) =
            AddCardFragment().apply {
                arguments = Bundle().apply {
                    putSerializable(SdkUiConstants.INITIATED_FROM, initiatedFrom)
                    putParcelable(SdkUiConstants.PAYMENT_OPTION, paymentOption)
                }
            }
    }

    override fun getInflatedView(view: View, roundedCornerBottomSheet: RoundedCornerBottomSheet) {
        view.findViewById<ImageView>(R.id.ivCloseIcon)?.setOnClickListener {
            addNewCardViewModel?.bottomSheetCloseClicked()
        }
//        (addNewCardViewModel as? EmiViewModel)?.emiTenureFocused(true)
        tvAmount = view.findViewById(R.id.tvAmount)
        tvAmount?.text = context?.getString(
            R.string.payu_pay_amount,
            Utils.formatAmount(
                SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDoubleOrNull().toString()
            )
        )
        populateEmiTenureAdapter(view)
        addSaveCardBottomSheetObserver(view)
    }

    override fun handleBottomSheetClose() {
    }

    override fun bottomSheetDetach() {

    }

    override fun bottomSheetAttach() {
    }

    override fun onTextPaste() {
        etCardNumber?.let {
            etCardNumber?.setSelection(etCardNumber!!.text!!.length)
        }
    }

    private fun setExpiry(result: PUCardRecognizer) {
        val expiryDate = result.expiryMonth?.text.plus(result.expiryYear?.text)
        if (Utils.isValidExpiry(expiryDate)) {
            etExpiry?.setText(expiryDate)
            etCvv?.requestFocus()
            if (etCvv != null)
                ViewUtils.showSoftKeyboard(etCvv!!)
        }
    }


    private fun addSaveCardBottomSheetObserver(view: View) {
        btnSaveCardNudgePayNow = view.findViewById(R.id.btnSaveCardNudgePayNow)
        tvContinueWithoutSaving = view.findViewById(R.id.tvContinueWithoutSaving)
        ViewUtils.updateBackgroundColor(
            requireContext(),
            btnSaveCardNudgePayNow,
            SdkUiInitializer.apiLayer?.config?.primaryColor,
            R.color.one_payu_colorPrimary
        )
        ViewUtils.updateButtonTextColor(
            btnSaveCardNudgePayNow,
            SdkUiInitializer.apiLayer?.config?.baseTextColor
        )
        if (isSaveCardInfoBottomSheet) {
            btnSaveCardNudgePayNow?.text = resources.getString(R.string.payu_back)
            tvContinueWithoutSaving?.visibility = GONE
            btnSaveCardNudgePayNow?.setOnClickListener {
                addNewCardViewModel?.bottomSheetCloseClicked()
            }
        } else {
            btnSaveCardNudgePayNow?.text = resources.getString(R.string.payu_save_card_and_pay)
            btnSaveCardNudgePayNow?.setOnClickListener {
                addNewCardViewModel?.handlePayNow(false)
                makePayment()
            }
            tvContinueWithoutSaving?.setOnClickListener {
                addNewCardViewModel?.bottomSheetCloseClicked()
                makePayment()
            }
        }
    }


    private fun showBottomSheet(layout: Int) {
        if (activity != null && !requireActivity().isFinishing && !requireActivity().isDestroyed) {
            roundedCornerBottomSheet =
                RoundedCornerBottomSheet.newInstance(layout)
            roundedCornerBottomSheet?.show(
                requireActivity().supportFragmentManager,
                roundedCornerBottomSheet?.tag
            )
            roundedCornerBottomSheet?.setListener(this)
        }
    }
}


interface InputWatcher {
    fun onInputReceived(input: String, inputType: Int)
}