package com.payu.ui.view.customViews

import android.text.SpannableStringBuilder
import android.view.View
import android.view.View.OnClickListener
import android.widget.Button
import android.widget.TextView
import androidx.core.text.bold
import androidx.core.text.color
import androidx.fragment.app.FragmentManager
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.utils.Utils
import com.payu.ui.model.utils.ViewUtils
import com.payu.ui.model.widgets.RoundedCornerBottomSheet

class UpiOtmDetailBottomSheet(
    private val fragmentManager: FragmentManager, val tag: String,
    private val roundedCornerBottomSheet: RoundedCornerBottomSheet
) {

    fun show() {
        roundedCornerBottomSheet.show(fragmentManager, tag)
    }

    class Builder(private val fragmentManager: FragmentManager, val tag: String) :
        RoundedCornerBottomSheet.OnBottomSheetListener {
        private lateinit var tvMandateAmountValue: TextView
        private lateinit var tvValidityValue: TextView
        private lateinit var tvPrivacyPolicy: TextView
        private lateinit var btnProceed: Button
        private var proceedBtnListener: View.OnClickListener? = null
        private var privacyClickListener: OnClickListener? = null
        private var onDetachCallBack: (() -> Unit)? = null

        fun build(): UpiOtmDetailBottomSheet {

            val roundedCornerBottomSheet = RoundedCornerBottomSheet.newInstance(
                R.layout.upi_otm_details_bottom_sheet
            )
            roundedCornerBottomSheet.setListener(this)
            return UpiOtmDetailBottomSheet(fragmentManager, tag, roundedCornerBottomSheet)

        }

        override fun getInflatedView(
            view: View,
            roundedCornerBottomSheet: RoundedCornerBottomSheet
        ) {
            tvMandateAmountValue = view.findViewById(R.id.tvMandateAmountValue)
            tvValidityValue = view.findViewById(R.id.tvValidityValue)
            btnProceed = view.findViewById(R.id.btnProceed)
            tvPrivacyPolicy = view.findViewById(R.id.tvPrivacyPolicy)

            val context = view.context
            val amount =
                Utils.getFormattedAmount(
                    SdkUiInitializer.apiLayer?.payUPaymentParams?.amount?.toDoubleOrNull() ?: 0.0,
                    context
                )


            val amountString = SpannableStringBuilder()
                .append(context.getString(R.string.payu_upto))
                .append(" ")
                .bold { append(amount) }

            tvMandateAmountValue.text = amountString

            val startDate = Utils.formatDate(
                SdkUiInitializer.apiLayer?.payUPaymentParams?.payUSIParams?.paymentStartDate,
                Utils.DATE_FORMAT_yyyy_MM_dd, Utils.DATE_FORMAT_dd_MMM_yyyy
            )
            val endDate = Utils.formatDate(
                SdkUiInitializer.apiLayer?.payUPaymentParams?.payUSIParams?.paymentEndDate,
                Utils.DATE_FORMAT_yyyy_MM_dd, Utils.DATE_FORMAT_dd_MMM_yyyy
            )
            tvValidityValue.text = context.getString(R.string.payu_otm_validity_value, startDate, endDate)

            val policyString = SpannableStringBuilder()
                .append(context.getString(R.string.payu_proceeding_agree))
                .append(" ")
                .color(context.resources.getColor(R.color.payu_color_282828), { append(context.getString(R.string.payu_terms)) })
                .append(" ")
                .append(context.getString(R.string.payu_and))
                .append(" ")
                .color(context.resources.getColor(R.color.payu_color_282828), { append(context.getString(R.string.payu_privacy_policy)) })

            tvPrivacyPolicy.text = policyString
            tvPrivacyPolicy.setOnClickListener {
                privacyClickListener?.onClick(it)
            }

            btnProceed.setOnClickListener {
                roundedCornerBottomSheet.dismiss()
                proceedBtnListener?.onClick(it)
            }
        }

        fun setProceedListener(listener: View.OnClickListener): Builder {
            this.proceedBtnListener = listener
            return this
        }

        fun setPrivacyUrlClickListener(listener: OnClickListener): Builder {
            this.privacyClickListener = listener
            return this
        }

        override fun handleBottomSheetClose() {
            onDetachCallBack?.invoke()
        }

        override fun bottomSheetDetach() {
        }

        override fun bottomSheetAttach() {
        }
    }
}