package com.payu.ui.view.customViews

import android.content.Intent
import android.view.KeyEvent
import android.view.View
import android.widget.Button
import android.widget.ImageView
import android.widget.TextView
import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentActivity
import androidx.fragment.app.FragmentManager
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.payu.base.listeners.BaseTransactionListener
import com.payu.base.models.InternalConfig
import com.payu.base.models.PaymentMode
import com.payu.base.models.PaymentOption
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.adapters.OnQuickOptionAdapterListener
import com.payu.ui.model.adapters.QuickPayAdapter
import com.payu.ui.model.listeners.HandleBackPress
import com.payu.ui.model.listeners.ValidateOfferResultListener
import com.payu.ui.model.models.FragmentModel
import com.payu.ui.model.utils.AnalyticsUtils
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.Utils
import com.payu.ui.model.utils.ViewUtils
import com.payu.ui.model.widgets.RoundedCornerBottomSheet
import com.payu.ui.view.activities.CheckoutActivity
import com.payu.ui.viewmodel.BaseViewModelFactory
import com.payu.ui.viewmodel.QuickPayViewModel
import java.util.Stack


class QuickPayBottomSheet(
    private val fragmentManager: FragmentManager,
    private val roundedCornerBottomSheet: RoundedCornerBottomSheet
) {
    fun show() {
        roundedCornerBottomSheet.show(fragmentManager, null)
    }

    class Builder(
        private val context: FragmentActivity,
        private val quickPayList: ArrayList<PaymentMode>
    ) :
        RoundedCornerBottomSheet.OnBottomSheetListener, OnQuickOptionAdapterListener,
        ValidateOfferResultListener {
        private var quickPayViewModel: QuickPayViewModel? = null
        private val PAYU_VM_KEY = this.javaClass.simpleName.plus(System.currentTimeMillis())
        private var onValidateOfferResultListener: ValidateOfferResultListener? = null
        private var roundedCornerBottomSheet: RoundedCornerBottomSheet? = null
        private var exitDialogSheet: RoundedCornerBottomSheet? = null
        private var fragment: Fragment? = null
        private var isExitBtSheet = false
        private var fragmentStack = Stack<FragmentModel>()

        private var quickPayAdapter: QuickPayAdapter? = null

//        init {
//            onBackPress()
//        }

        fun build(): QuickPayBottomSheet {
            initViewModel()
            roundedCornerBottomSheet = RoundedCornerBottomSheet.newInstance(
                R.layout.bottomsheet_quick_pay
            )
            roundedCornerBottomSheet?.setListener(this)
            roundedCornerBottomSheet?.dialog?.setCanceledOnTouchOutside(false)
            return QuickPayBottomSheet(context.supportFragmentManager, roundedCornerBottomSheet!!)

        }

        override fun getInflatedView(
            view: View,
            roundedCornerBottomSheet: RoundedCornerBottomSheet
        ) {


            if (isExitBtSheet) {
                setExitDialogInfo(view)
            } else {
                val rvMain = view.findViewById<RecyclerView>(R.id.rv_main)
                val ivClose = view.findViewById<ImageView>(R.id.ivClose)
                roundedCornerBottomSheet.isCancelable = false

                roundedCornerBottomSheet.dialog?.setOnKeyListener { dialogInterface, keyCode, keyEvent ->
                    if ((keyCode == KeyEvent.KEYCODE_BACK && keyEvent.action == KeyEvent.ACTION_DOWN)) {
                        quickPayViewModel?.showExitConfirmation(fragmentStack)
                        false
                    }
                    false
                }
                quickPayAdapter = QuickPayAdapter(quickPayList, this)
                rvMain.adapter = quickPayAdapter
                rvMain.layoutManager = LinearLayoutManager(rvMain.context)
                ivClose.setOnClickListener {
                    quickPayViewModel?.showExitConfirmation(fragmentStack)
                }
            }
        }

        override fun handleBottomSheetClose() {
        }

        override fun bottomSheetDetach() {
        }

        override fun bottomSheetAttach() {
        }

        override fun validate(
            paymentOption: PaymentOption,
            onValidateOfferResultListener: ValidateOfferResultListener
        ) {
            this.onValidateOfferResultListener = onValidateOfferResultListener
            val bankCode = Utils.getValueFromPaymentOption<String>(
                SdkUiConstants.CP_BANK_CODE,
                paymentOption.otherParams as? HashMap<String, Any?>
            ).toString()
            val category = Utils.getCategoryForOffer(paymentOption.paymentType?.name)
            quickPayViewModel?.validateOffer(category, bankCode)
        }

        override fun showOfferView(showOffer: Boolean) {
            quickPayViewModel?.showOfferAppliedView()
        }

        override fun makePayment(paymentOption: PaymentOption, position: Int) {
            AnalyticsUtils.logProceedToPayFromQuickPay(context, position, paymentOption.paymentType.toString(), paymentOption.bankName)
            quickPayViewModel?.makePayment(paymentOption, context)
            roundedCornerBottomSheet?.dismiss()
        }

        override fun otherOptionClicked() {
            AnalyticsUtils.logOtherFromQuickPay(context)
            quickPayViewModel?.openCheckout()
        }

        override fun onValidateOfferResponse(isOfferValid: Boolean) {

        }

        private fun initViewModel() {
            val map = HashMap<String, Any>()
            quickPayViewModel = ViewModelProvider(
                context,
                BaseViewModelFactory(context.application, map)
            )[PAYU_VM_KEY, QuickPayViewModel::class.java]
            addObserver()
            quickPayViewModel?.checkEligibilityForBNPL(quickPayList)
            SdkUiInitializer.apiLayer?.connectListener(
                context,
                quickPayViewModel as BaseTransactionListener
            )
        }

        private fun addObserver() {
            quickPayViewModel?.showOfferAppliedDialog?.observe(context) {
                if (it.getContentIfNotHandled() == true) {
                    onValidateOfferResultListener?.onValidateOfferResponse(true)
                    val offerAppliedDialog = OfferAppliedDialog(context)
                    offerAppliedDialog.showOfferDialog()
                }

            }
            quickPayViewModel?.showAndroidLoader?.observe(context) {
                if (it.getContentIfNotHandled() == true)
                    ViewUtils.showProgressDialog(context)
                else
                    ViewUtils.hideProgressDialog()
            }
            quickPayViewModel?.loadFragment?.observe(context) { fragmentModel ->
                fragment = fragmentModel.fragment
                dynamicFrag(fragmentModel)
            }

            quickPayViewModel?.flowComplete?.observe(context) {
                fragment?.let {
                    context.supportFragmentManager.beginTransaction().remove(it).commit()
                }
                context.supportFragmentManager.executePendingTransactions()
                fragment = null
            }
            quickPayViewModel?.openCheckout?.observe(context) {
                roundedCornerBottomSheet?.dismiss()
                InternalConfig.selectedOfferInfo = null
                val intent = Intent(context, CheckoutActivity::class.java)
                context.startActivityForResult(intent, SdkUiConstants.REQUEST_CODE_SDK_INIT)
            }
            quickPayViewModel?.showBottomSheet?.observe(context) {
                isExitBtSheet = true
                exitDialogSheet =
                    it.second?.let { second ->
                        RoundedCornerBottomSheet.newInstance(
                            it.first,
                            second
                        )
                    }
                        ?: kotlin.run { RoundedCornerBottomSheet.newInstance(it.first) }
                exitDialogSheet?.setListener(this)
                exitDialogSheet?.show(
                    context.supportFragmentManager,
                    SdkUiConstants.CP_BOTTOM_SHEET_FRAGMENT
                )
            }
            quickPayViewModel?.hideBottomSheet?.observe(context) {
                roundedCornerBottomSheet?.dismiss()
            }
            quickPayViewModel?.hideExitDialogSheet?.observe(context) {
                exitDialogSheet?.dismiss()
            }

            quickPayViewModel?.bnplEligibilityLiveData?.observe(context) {
                quickPayAdapter?.notifyDataSetChanged()
            }
            quickPayViewModel?.popBackStack?.observe(context) {
                if (it) {
                    context.supportFragmentManager.popBackStack()
                    if (fragmentStack.isNotEmpty()) {
                        fragmentStack.pop()
                    }
                    fragment = null
                }
            }

        }

        private fun dynamicFrag(fragmentModel: FragmentModel) {
            val fragmentTransaction = context.supportFragmentManager.beginTransaction()
            fragmentModel.handleBackPress = object : HandleBackPress {
                override fun onBackPressed() {
                    fragmentModel.fragment?.let {
                        SdkUiInitializer.apiLayer?.onBackPressed(it)
                    }
                }
            }
            fragmentStack.add(fragmentModel)

            fragmentTransaction.add(
                android.R.id.content,
                fragmentModel.fragment!!,
                fragmentModel.tag
            ).addToBackStack(null)
                .commit()
            context.supportFragmentManager.executePendingTransactions()
        }

        private fun setExitDialogInfo(view: View?) {
            val btnNo = view?.findViewById<Button>(R.id.btnNo)
            ViewUtils.updateBackgroundColor(
                context,
                btnNo,
                SdkUiInitializer.apiLayer?.config?.primaryColor,
                R.color.one_payu_colorPrimary
            )
            ViewUtils.updateButtonTextColor(
                btnNo,
                SdkUiInitializer.apiLayer?.config?.baseTextColor
            )

            btnNo
                ?.setOnClickListener {
                    quickPayViewModel?.exitDialogNoClicked()
                }

            view?.findViewById<TextView>(R.id.tvYes)
                ?.setOnClickListener {
                    quickPayViewModel?.exitDialogYesClicked(fragmentStack)
                }
        }
    }

}