package com.payu.ui.model.widgets

import android.R
import android.content.Context
import android.util.AttributeSet
import androidx.appcompat.widget.AppCompatEditText


/**
 * An EditText, which notifies when something was cut/copied/pasted inside it.
 */
class MonitoringEditText : AppCompatEditText {
    private var applicationContext: Context? = null
    var onMonitorListener: OnMonitorListener? = null

    /*
        Just the constructors to create a new EditText...
     */
    constructor(context: Context) : super(context) {
        this.applicationContext = context
    }

    constructor(
        context: Context,
        attrs: AttributeSet?
    ) : super(context, attrs) {
        this.applicationContext = context
    }

    constructor(
        context: Context,
        attrs: AttributeSet?,
        defStyle: Int
    ) : super(context, attrs, defStyle) {
        this.applicationContext = context
    }

    /**
     *
     * This is where the "magic" happens.
     *
     * The menu used to cut/copy/paste is a normal ContextMenu, which allows us to
     * overwrite the consuming method and react on the different events.
     * @see [Original Implementation](http://grepcode.com/file/repository.grepcode.com/java/ext/com.google.android/android/2.3_r1/android/widget/TextView.java.TextView.onTextContextMenuItem%28int%29)
     */
    override fun onTextContextMenuItem(id: Int): Boolean {
        // Do your thing:
        val consumed = super.onTextContextMenuItem(id)
        when (id) {
            R.id.cut -> onTextCut()
            R.id.paste -> onTextPaste()
            R.id.copy -> onTextCopy()
        }
        return consumed
    }

    /**
     * Text was cut from this EditText.
     */
    private fun onTextCut() {
        //Handle text cut
    }

    /**
     * Text was copied from this EditText.
     */
    private fun onTextCopy() {
        //Handle text copy
    }

    /**
     * Text was pasted into the EditText.
     */
    private fun onTextPaste() {
        //Handle text paste
        onMonitorListener?.onTextPaste()
    }

    interface OnMonitorListener {
        fun onTextPaste()
    }
}