package com.payu.ui.model.models

import androidx.annotation.ColorRes
import androidx.annotation.DrawableRes
import com.payu.base.models.MPinAction
import com.payu.base.models.OlwPaymentOption
import java.net.URL

data class EnterMPinData(
    var bankName: String,
    var currentBalance: Double,
    @DrawableRes var bankIcon: Int? = null,
    var mPinHint: String,
    var mPinLength: Int,
    var reActionDescText: String,
    var reActionText: String,
    var actionText: String,
    var topUpAmountNeeded: Double,
    var showInsufficientTag: Boolean,
    var showTopUpAmountConfirmation: Boolean,
    var showSecondaryButton: Boolean,
    var paymentOption: OlwPaymentOption
)


data class SetMPinData(
    var bankName: String,
    var currentBalance: Double,
    var subHeader: String? = null,
    var mobileNumber: String,
    var otpLength: Int,
    var mPinLength: Int,
    var reActionDescText: String,
    var reActionText: String,
    var actionText: String,
    var setMPinText: String,
    var setMPinAction: MPinAction,
    var paymentOption: OlwPaymentOption,
    var postSuccessNavigation: (() -> Unit)? = null
)

data class SimpleStatusBottomSheetData(
    var title: String,
    var message: String,
    @DrawableRes var statusIcon: Int,
    @ColorRes var bgColor: Int,
    var dismissInterval: Long,
    var isSetMPinSuccess: Boolean,
    var paymentOption: OlwPaymentOption,
    var postDelayAction: (() -> Unit)? = null
)


data class WalletCardData(
    var walletName: String,
    var currentBalance: Double,
    @DrawableRes var walletIcon: Int? = null,
    var showInsufficientTag: Boolean,
    var showTopUpCard: Boolean,
    var minTopUpAmountNeeded: Double,
    var actionText: String,
    var paymentOption: OlwPaymentOption
)

data class BottomSheetLoaderData(
    var message: String
)

data class MultiStepBottomSheetLoaderData(
    var step1Description: String,
    var step2Description: String,
    var warningDescription: String
)

data class PaymentStatusPageData(
    @DrawableRes var statusIcon: Int,
    var title: String,
    var message: String,
    var noteMessage1: String,
    var noteMessage2: String? = null,
    var actionText: String,
    var footerInfo: String,
    var dismissInterval: Long,
    var showNote: Boolean
)