package com.payu.ui.model.managers

import com.payu.base.models.EMIOption
import com.payu.base.models.EmiType
import com.payu.base.models.FetchOfferDetails
import com.payu.base.models.InternalConfig
import com.payu.base.models.OfferInfo
import com.payu.base.models.PaymentMode
import com.payu.base.models.PaymentOption
import com.payu.base.models.PaymentOptionOfferinfo
import com.payu.base.models.PaymentType
import com.payu.base.models.UPIOption
import com.payu.ui.model.utils.SdkUiConstants
import com.payu.ui.model.utils.SdkUiConstants.ALL
import com.payu.ui.model.utils.SdkUiConstants.CP_BANK_CODE
import com.payu.ui.model.utils.SdkUiConstants.CP_CREDIT_CARD
import com.payu.ui.model.utils.SdkUiConstants.CP_DEBIT_CARD
import com.payu.ui.model.utils.SdkUiConstants.CP_EMI_CODE
import java.util.Stack


object OfferFilterManager {
    private var filteredOfferMap: HashMap<String, FetchOfferDetails?> = HashMap()
    private var paymentTypeFlowStack: Stack<String> = Stack<String>()
    private var couponMap: HashMap<String, OfferInfo?> = HashMap()

    init {
        paymentTypeFlowStack.add(ALL)
    }

    internal fun filterOffersForPaymentType(
        ignoreRewardsOffer: Boolean = false,
        fetchOfferDetails: FetchOfferDetails?
    ) {
        filteredOfferMap = HashMap()
        val nbOfferDetails = FetchOfferDetails(arrayListOf(), arrayListOf(), arrayListOf())
        val cardOfferDetails = FetchOfferDetails(arrayListOf(), arrayListOf(), arrayListOf())
        val emiCCOfferDetails = FetchOfferDetails(arrayListOf(), arrayListOf(), arrayListOf())
        val emiDCOfferDetails = FetchOfferDetails(arrayListOf(), arrayListOf(), arrayListOf())
        val emiOfferDetails = FetchOfferDetails(arrayListOf(), arrayListOf(), arrayListOf())
        val walletOfferDetails = FetchOfferDetails(arrayListOf(), arrayListOf(), arrayListOf())
        val bnplOfferDetails = FetchOfferDetails(arrayListOf(), arrayListOf(), arrayListOf())
        val upiOfferDetails = FetchOfferDetails(arrayListOf(), arrayListOf(), arrayListOf())
        for (offer in fetchOfferDetails?.payuSkuOfferList ?: listOf()) {
            if (ignoreRewardsOffer && offer.offerType == SdkUiConstants.CP_REWARD) {
                continue
            }
            if (offer.isAllPaymentMethodsAvailable || !offer.nbOptionOfferInfoList.isNullOrEmpty())
                nbOfferDetails.payuSkuOfferList.add(offer)
            if (offer.isAllPaymentMethodsAvailable || !offer.walletOptionOfferInfoList.isNullOrEmpty())
                walletOfferDetails.payuSkuOfferList.add(offer)
            if (offer.isAllPaymentMethodsAvailable || !offer.bnplOptionOfferInfoList.isNullOrEmpty())
                bnplOfferDetails.payuSkuOfferList.add(offer)
            if (offer.isAllPaymentMethodsAvailable || !offer.cardsOfferInfo?.bankOfferInfoCards?.banksListForCCCards.isNullOrEmpty() || !offer.cardsOfferInfo?.bankOfferInfoCards?.banksListForDCCards.isNullOrEmpty()
                || !offer.cardsOfferInfo?.networkOfferInfoCards?.networkListForCCCards.isNullOrEmpty() || !offer.cardsOfferInfo?.networkOfferInfoCards?.networkListForDCCards.isNullOrEmpty()
            )
                cardOfferDetails.payuSkuOfferList.add(offer)
            if (offer.isAllPaymentMethodsAvailable || !offer.emiOfferInfo?.emiCCOfferList.isNullOrEmpty())
                emiCCOfferDetails.payuSkuOfferList.add(offer)
            if (offer.isAllPaymentMethodsAvailable || !offer.emiOfferInfo?.emiDCOfferList.isNullOrEmpty())
                emiDCOfferDetails.payuSkuOfferList.add(offer)
            if (offer.isAllPaymentMethodsAvailable || !offer.emiOfferInfo?.emiDCOfferList.isNullOrEmpty() || !offer.emiOfferInfo?.emiCCOfferList.isNullOrEmpty())
                emiOfferDetails.payuSkuOfferList.add(offer)
            if (offer.isAllPaymentMethodsAvailable || !offer.upiOptionOfferInfoList.isNullOrEmpty())
                upiOfferDetails.payuSkuOfferList.add(offer)
        }
        for (offer in fetchOfferDetails?.payuOfferArrayList ?: listOf()) {
            if(offer.offerType == SdkUiConstants.CP_INSTANT_OFFER) {
                if (offer.isAllPaymentMethodsAvailable || !offer.nbOptionOfferInfoList.isNullOrEmpty())
                    nbOfferDetails.payuOfferArrayList.add(offer)
                if (offer.isAllPaymentMethodsAvailable || !offer.walletOptionOfferInfoList.isNullOrEmpty())
                    walletOfferDetails.payuOfferArrayList.add(offer)
                if (offer.isAllPaymentMethodsAvailable || !offer.bnplOptionOfferInfoList.isNullOrEmpty())
                    bnplOfferDetails.payuOfferArrayList.add(offer)
                if (offer.isAllPaymentMethodsAvailable || !offer.cardsOfferInfo?.bankOfferInfoCards?.banksListForCCCards.isNullOrEmpty() || !offer.cardsOfferInfo?.bankOfferInfoCards?.banksListForDCCards.isNullOrEmpty()
                    || !offer.cardsOfferInfo?.networkOfferInfoCards?.networkListForCCCards.isNullOrEmpty() || !offer.cardsOfferInfo?.networkOfferInfoCards?.networkListForDCCards.isNullOrEmpty()
                )
                    cardOfferDetails.payuOfferArrayList.add(offer)
                if (offer.isAllPaymentMethodsAvailable || !offer.emiOfferInfo?.emiCCOfferList.isNullOrEmpty())
                    emiCCOfferDetails.payuOfferArrayList.add(offer)
                if (offer.isAllPaymentMethodsAvailable || !offer.emiOfferInfo?.emiDCOfferList.isNullOrEmpty())
                    emiDCOfferDetails.payuOfferArrayList.add(offer)
                if (offer.isAllPaymentMethodsAvailable || !offer.emiOfferInfo?.emiDCOfferList.isNullOrEmpty() || !offer.emiOfferInfo?.emiCCOfferList.isNullOrEmpty())
                    emiOfferDetails.payuSkuOfferList.add(offer)
                if (offer.isAllPaymentMethodsAvailable || !offer.upiOptionOfferInfoList.isNullOrEmpty())
                    upiOfferDetails.payuOfferArrayList.add(offer)
            }
        }
        for (offer in fetchOfferDetails?.payuRewardOfferArrayList ?: listOf()) {
            if (ignoreRewardsOffer && offer.offerType == SdkUiConstants.CP_REWARD) {
                continue
            }
            if(offer.offerType == SdkUiConstants.CP_CASHBACK || offer.offerType == SdkUiConstants.CP_REWARD) {
                if (offer.isAllPaymentMethodsAvailable || !offer.nbOptionOfferInfoList.isNullOrEmpty())
                    nbOfferDetails.payuRewardOfferArrayList.add(offer)
                if (offer.isAllPaymentMethodsAvailable || !offer.walletOptionOfferInfoList.isNullOrEmpty())
                    walletOfferDetails.payuRewardOfferArrayList.add(offer)
                if (offer.isAllPaymentMethodsAvailable || !offer.bnplOptionOfferInfoList.isNullOrEmpty())
                    bnplOfferDetails.payuRewardOfferArrayList.add(offer)
                if (offer.isAllPaymentMethodsAvailable || !offer.cardsOfferInfo?.bankOfferInfoCards?.banksListForCCCards.isNullOrEmpty() || !offer.cardsOfferInfo?.bankOfferInfoCards?.banksListForDCCards.isNullOrEmpty()
                    || !offer.cardsOfferInfo?.networkOfferInfoCards?.networkListForCCCards.isNullOrEmpty() || !offer.cardsOfferInfo?.networkOfferInfoCards?.networkListForDCCards.isNullOrEmpty()
                )
                    cardOfferDetails.payuRewardOfferArrayList.add(offer)
                if (offer.isAllPaymentMethodsAvailable || !offer.emiOfferInfo?.emiCCOfferList.isNullOrEmpty())
                    emiCCOfferDetails.payuRewardOfferArrayList.add(offer)
                if (offer.isAllPaymentMethodsAvailable || !offer.emiOfferInfo?.emiDCOfferList.isNullOrEmpty())
                    emiDCOfferDetails.payuRewardOfferArrayList.add(offer)
                if (offer.isAllPaymentMethodsAvailable || !offer.emiOfferInfo?.emiDCOfferList.isNullOrEmpty() || !offer.emiOfferInfo?.emiCCOfferList.isNullOrEmpty())
                    emiOfferDetails.payuRewardOfferArrayList.add(offer)
                if (offer.isAllPaymentMethodsAvailable || !offer.upiOptionOfferInfoList.isNullOrEmpty())
                    upiOfferDetails.payuRewardOfferArrayList.add(offer)
            }
        }
        if (!isNoOfferPresent(nbOfferDetails))
            filteredOfferMap[PaymentType.NB.name] = nbOfferDetails
        if (!isNoOfferPresent(cardOfferDetails))
            filteredOfferMap[PaymentType.CARD.name] = cardOfferDetails
        if (!isNoOfferPresent(bnplOfferDetails))
            filteredOfferMap[PaymentType.BNPL.name] = bnplOfferDetails
        if (!isNoOfferPresent(walletOfferDetails))
            filteredOfferMap[PaymentType.WALLET.name] = walletOfferDetails
        if (!isNoOfferPresent(emiOfferDetails)) {
            filteredOfferMap[PaymentType.EMI.name] = emiOfferDetails
            if (!isNoOfferPresent(emiDCOfferDetails))
                filteredOfferMap[PaymentType.EMI.name + EmiType.DC.name] = emiDCOfferDetails
            if (!isNoOfferPresent(emiCCOfferDetails))
                filteredOfferMap[PaymentType.EMI.name + EmiType.CC.name] = emiCCOfferDetails
        }
        if (!isNoOfferPresent(upiOfferDetails)) {
            filteredOfferMap[PaymentType.UPI.name] = upiOfferDetails
            filteredOfferMap[PaymentType.UPI_INTENT.name] = upiOfferDetails
        }
        if (!isNoOfferPresent(fetchOfferDetails))
            filteredOfferMap[ALL] = fetchOfferDetails?.let {
                if(ignoreRewardsOffer){
                    FetchOfferDetails(payuOfferArrayList = it.payuOfferArrayList, payuSkuOfferList = it.payuSkuOfferList, payuRewardOfferArrayList = it.payuRewardOfferArrayList.filter { it.offerType != SdkUiConstants.CP_REWARD } as ArrayList<OfferInfo>)
                }
                else
                    it
            }
    }

    fun handleOfferListForSelectedPaymentMode(
        list: ArrayList<PaymentOption>? = null,
        paymentType: PaymentType?,
        listener: OfferFilterListener
    ) {
        if ((paymentType == PaymentType.EMI) && ((list?.first()?.bankName != CP_CREDIT_CARD) || (list.first().bankName != CP_DEBIT_CARD))) {
            if (InternalConfig.selectedOfferInfo == null)
                listener.offerDetails(filteredOfferMap[paymentType.name + (list?.first() as? EMIOption)?.emiType?.name])
            paymentTypeFlowStack.add(paymentType.name + (list?.first() as? EMIOption)?.emiType?.name)
        } else {
            if (InternalConfig.selectedOfferInfo == null)
                listener.offerDetails(filteredOfferMap[paymentType?.name])
            paymentTypeFlowStack.add(paymentType?.name)
        }
    }

    internal fun handleOfferListForEMITenures(
        list: ArrayList<PaymentOption>?,
        listner: OfferFilterListener
    ) {
        if ((list?.first()?.bankName != CP_CREDIT_CARD || list.first().bankName != CP_DEBIT_CARD)) {
            val emiOffers =
                filteredOfferMap[PaymentType.EMI.name + ((list?.first() as? EMIOption)?.emiType?.name
                    ?: "")]
            val fetchOfferDetails = FetchOfferDetails(arrayListOf(), arrayListOf(), arrayListOf())
            for (offer in emiOffers?.payuSkuOfferList ?: listOf()) {
                if ((list?.first() as? EMIOption)?.emiType == EmiType.CC) {
                    for (bank in offer.emiOfferInfo?.emiCCOfferList ?: listOf()) {
                        if (bank.emiBankCode == ((list.first().otherParams as? HashMap<*, *>)?.get(
                                CP_EMI_CODE
                            ) ?: "")
                        ) {
                            fetchOfferDetails.payuSkuOfferList.add(offer)
                            break
                        }
                    }
                } else if ((list?.first() as? EMIOption)?.emiType == EmiType.DC) {
                    for (bank in offer.emiOfferInfo?.emiDCOfferList ?: listOf()) {
                        if (bank.emiBankCode == ((list.first().otherParams as? HashMap<*, *>)?.get(
                                CP_EMI_CODE
                            ) ?: "")
                        ) {
                            fetchOfferDetails.payuSkuOfferList.add(offer)
                            break
                        }
                    }
                }
            }
            for (offer in emiOffers?.payuOfferArrayList ?: listOf()) {
                if ((list?.first() as? EMIOption)?.emiType == EmiType.CC) {
                    for (bank in offer.emiOfferInfo?.emiCCOfferList ?: listOf()) {
                        if (bank.emiBankCode == ((list.first().otherParams as? HashMap<*, *>)?.get(
                                CP_EMI_CODE
                            ) ?: "")
                        ) {
                            fetchOfferDetails.payuOfferArrayList.add(offer)
                            break
                        }
                    }
                } else if ((list?.first() as? EMIOption)?.emiType == EmiType.DC) {
                    for (bank in offer.emiOfferInfo?.emiDCOfferList ?: listOf()) {
                        if (bank.emiBankCode == ((list.first().otherParams as? HashMap<*, *>)?.get(
                                CP_EMI_CODE
                            ) ?: "")
                        ) {
                            fetchOfferDetails.payuOfferArrayList.add(offer)
                            break
                        }
                    }
                }
            }
            if (InternalConfig.selectedOfferInfo == null) {
                if (!isNoOfferPresent(fetchOfferDetails))
                    listner.offerDetails(fetchOfferDetails)
                else
                    listner.offerDetails(null)
            }
            filteredOfferMap[PaymentType.EMI.name + (list?.first() as EMIOption).emiType?.name + (list.first().otherParams as? HashMap<*, *>)?.get(
                CP_EMI_CODE
            )] = fetchOfferDetails
            paymentTypeFlowStack.add(
                PaymentType.EMI.name + (list.first() as EMIOption).emiType?.name + (list.first().otherParams as? HashMap<*, *>)?.get(
                    CP_EMI_CODE
                )
            )
        }

    }

    private fun isNoOfferPresent(fetchOfferDetails: FetchOfferDetails?): Boolean {
        return (fetchOfferDetails?.payuSkuOfferList.isNullOrEmpty()) && (fetchOfferDetails?.payuOfferArrayList.isNullOrEmpty()) && (fetchOfferDetails?.payuRewardOfferArrayList.isNullOrEmpty())
    }

    internal fun updateOfferListOnBackPress(listner: OfferFilterListener) {
        if (paymentTypeFlowStack.size > 1) {
            paymentTypeFlowStack.pop()
            if (InternalConfig.selectedOfferInfo == null)
                listner.offerDetails(filteredOfferMap[paymentTypeFlowStack.last()])
        }
        listner.showChangeOfferView(false, handleBackstack = true)
    }

    internal fun getCurrentOfferList(): FetchOfferDetails? {
        val offerDetails = filteredOfferMap[paymentTypeFlowStack.last()]
        return if (offerDetails?.payuOfferArrayList.isNullOrEmpty() && offerDetails?.payuSkuOfferList.isNullOrEmpty() && offerDetails?.payuRewardOfferArrayList.isNullOrEmpty()) null else offerDetails
    }

    internal fun isAtleastOneOfferPresentForTheCurrentPaymentType(): Boolean {
        val offerDetails =  getCurrentOfferList()
        return offerDetails?.payuOfferArrayList.isNullOrEmpty().not() || offerDetails?.payuSkuOfferList.isNullOrEmpty().not() || offerDetails?.payuRewardOfferArrayList.isNullOrEmpty().not()
    }

    internal fun resetOfferPaymentTypeFlowStack() {
        paymentTypeFlowStack.removeAllElements()
        paymentTypeFlowStack.add(ALL)
    }

    internal fun resetOfferFilterData() {
        resetOfferPaymentTypeFlowStack()
        filteredOfferMap = HashMap()
    }


    internal fun filterPaymentOption(
        paymentType: PaymentType?,
        allBankList: ArrayList<PaymentOption>?
    ): ArrayList<PaymentOption>? {
        InternalConfig.userSelectedOfferInfo?.let {
            if (it.isAllPaymentMethodsAvailable)
                return allBankList
            when (paymentType) {
                PaymentType.L1_OPTION -> {
                    if (allBankList?.first()?.paymentType == PaymentType.UPI || allBankList?.first()?.paymentType == PaymentType.UPI_INTENT) {
                        return filterPaymentOption(it.upiOptionOfferInfoList, allBankList)
                    }
                    return filterPaymentOption(it.walletOptionOfferInfoList, allBankList)
                }

                PaymentType.CLOSED_LOOP_WALLET -> {
                    return filterPaymentOption(it.clwOptionOfferInfoList, allBankList)
                }

                PaymentType.NB ->
                    return filterPaymentOption(it.nbOptionOfferInfoList, allBankList)

                PaymentType.BNPL ->
                    return filterPaymentOption(it.bnplOptionOfferInfoList, allBankList)

                PaymentType.WALLET ->
                    return filterPaymentOption(it.walletOptionOfferInfoList, allBankList)

                PaymentType.UPI, PaymentType.UPI_INTENT ->
                    return filterPaymentOption(it.upiOptionOfferInfoList, allBankList)

                PaymentType.EMI ->
                    if (allBankList?.first()?.bankName == CP_CREDIT_CARD || allBankList?.first()?.bankName == CP_DEBIT_CARD)
                        return filterEMIOption(allBankList)
                    else if ((allBankList?.first() as? EMIOption)?.emiType == EmiType.CC)
                        return filterEMIBankOption(it.emiOfferInfo?.emiCCOfferList, allBankList)
                    else if ((allBankList?.first() as? EMIOption)?.emiType == EmiType.DC)
                        return filterEMIBankOption(it.emiOfferInfo?.emiDCOfferList, allBankList)

                else ->
                    return null
            }
        }
        return allBankList
    }

    internal fun filterPaymentOption(
        offerBanks: ArrayList<PaymentOptionOfferinfo>?,
        allBankList: ArrayList<PaymentOption>?,
    ): ArrayList<PaymentOption>? {
        val offerBanksMap: HashMap<String, PaymentOptionOfferinfo> = HashMap()
        for (bank in offerBanks ?: listOf())
            offerBanksMap[bank.paymentCode] = bank
        val filterBankList: ArrayList<PaymentOption> = arrayListOf()
        for (bank in allBankList ?: listOf()) {
            if ((bank.otherParams as? HashMap<*, *>)?.get(CP_BANK_CODE) == SdkUiConstants.INTENT) {
                if (offerBanksMap[(SdkUiConstants.CP_UPI)]?.paymentCode == SdkUiConstants.CP_UPI) {
                    filterBankList.add(bank)
                } else {
                    if (offerBanksMap[((bank as UPIOption).appName)] != null)
                        filterBankList.add(bank)
                }
            } else if (bank.category == SdkUiConstants.VPA_ELIGIBILITY) {
                filterBankList.add(bank)
            } else {
                if (offerBanksMap[(bank.otherParams as? HashMap<*, *>)?.get(CP_BANK_CODE)] != null)
                    filterBankList.add(bank)
            }
        }
        if (filterBankList.isNotEmpty())
            return filterBankList
        return null
    }

    internal fun filterRecommendedMode(modeList: ArrayList<PaymentMode>?): ArrayList<PaymentMode> {
        val filteredMoreOptionList: ArrayList<PaymentMode> = arrayListOf()
        for (mode in modeList ?: listOf()) {
            mode.type?.let {
                filterPaymentOption(paymentType = mode.type, allBankList = mode.optionDetail)?.let {
                    filteredMoreOptionList.add(
                        mode
                    )
                }
            }

        }
        return filteredMoreOptionList
    }

    internal fun filterSavedPaymentMode(modeList: ArrayList<PaymentMode>?): ArrayList<PaymentMode> {
        val filteredMoreOptionList: ArrayList<PaymentMode> = arrayListOf()
        for (mode in modeList ?: listOf()) {
            filterPaymentOption(
                paymentType = mode.type,
                allBankList = mode.optionDetail
            )?.let { filteredMoreOptionList.add(mode) }
        }
        return filteredMoreOptionList
    }


    internal fun filterPaymentMode(
        offer: OfferInfo,
        modeList: ArrayList<PaymentMode>?
    ): ArrayList<PaymentMode> {
        val filteredMoreOption: ArrayList<PaymentMode> = arrayListOf()
        if (offer.isAllPaymentMethodsAvailable) {
            modeList?.forEach {
                if(it.type != PaymentType.NEFTRTGS || it.type != PaymentType.OPEN_LOOP_WALLET)
                 it.isOfferValid = true
            }
            return modeList?.filter { it.type != PaymentType.NEFTRTGS || it.type != PaymentType.OPEN_LOOP_WALLET }
                ?.let { ArrayList(it) } ?: arrayListOf()
        }
        for (mode in modeList ?: listOf()) {
            when (mode.type) {
                PaymentType.CARD -> {
                    if (!offer.cardsOfferInfo?.bankOfferInfoCards?.banksListForCCCards.isNullOrEmpty() || !offer.cardsOfferInfo?.bankOfferInfoCards?.banksListForDCCards.isNullOrEmpty()
                        || !offer.cardsOfferInfo?.networkOfferInfoCards?.networkListForCCCards.isNullOrEmpty() || !offer.cardsOfferInfo?.networkOfferInfoCards?.networkListForDCCards.isNullOrEmpty()
                    )
                        filteredMoreOption.add(mode)
                }

                PaymentType.NB -> {
                    if (!offer.nbOptionOfferInfoList.isNullOrEmpty())
                        filteredMoreOption.add(mode)
                }

                PaymentType.WALLET -> {
                    if (!offer.walletOptionOfferInfoList.isNullOrEmpty())
                        filteredMoreOption.add(mode)
                }

                PaymentType.BNPL -> {
                    if (!offer.bnplOptionOfferInfoList.isNullOrEmpty())
                        filteredMoreOption.add(mode)
                }

                PaymentType.EMI -> {
                    if (!offer.emiOfferInfo?.emiDCOfferList.isNullOrEmpty() || !offer.emiOfferInfo?.emiCCOfferList.isNullOrEmpty())
                        filteredMoreOption.add(mode)
                }

                PaymentType.L1_OPTION -> {
                    filterPaymentOption(mode.type, mode.optionDetail)?.let {
                        mode.isOfferValid = true
                        filteredMoreOption.add(
                            mode
                        )
                    }
                }

                PaymentType.UPI, PaymentType.UPI_INTENT -> {
                    if (!offer.upiOptionOfferInfoList.isNullOrEmpty())
                        filteredMoreOption.add(mode)
                }

                else -> {}
            }

        }
        return filteredMoreOption
    }

    internal fun getPaymentStack(): Stack<String> {
        return paymentTypeFlowStack
    }

    private fun filterEMIOption(allBankList: ArrayList<PaymentOption>?): ArrayList<PaymentOption>? {
        InternalConfig.userSelectedOfferInfo?.let {
            val filteredEMIOption: ArrayList<PaymentOption> = arrayListOf()
            for (bank in allBankList ?: listOf()) {
                if ((!it.emiOfferInfo?.emiCCOfferList.isNullOrEmpty() && (bank as? EMIOption)?.emiType == EmiType.CC)
                    || (!it.emiOfferInfo?.emiDCOfferList.isNullOrEmpty() && (bank as? EMIOption)?.emiType == EmiType.DC)
                )
                    filteredEMIOption.add(bank)

            }
            return filteredEMIOption
        }
        return allBankList
    }

    private fun filterEMIBankOption(
        offerBanks: ArrayList<PaymentOptionOfferinfo>?,
        allBankList: ArrayList<PaymentOption>?
    ): ArrayList<PaymentOption>? {
        val offerBanksMap: HashMap<String, PaymentOptionOfferinfo> = HashMap()
        for (bank in offerBanks ?: listOf())
            offerBanksMap[bank.emiBankCode ?: ""] = bank
        var totalOfferBank = offerBanksMap.size
        val filterBankList: MutableSet<PaymentOption> = mutableSetOf()
        for (bank in allBankList ?: listOf()) {
            if (totalOfferBank == 0 && filterBankList.isNotEmpty()) {
                return ArrayList(filterBankList)

            } else if (offerBanksMap[(bank.otherParams as? HashMap<*, *>)?.get(CP_BANK_CODE)
                    ?: ""] != null
            ) {
                totalOfferBank -= 1
                filterBankList.add(bank)
            }
        }
        if (filterBankList.isNotEmpty())
            return ArrayList(filterBankList)
        return null
    }

    internal fun handleEMITenureOnOfferSelection(list: ArrayList<PaymentOption>?): ArrayList<PaymentOption>? {
        InternalConfig.userSelectedOfferInfo?.let {
            if (InternalConfig.selectedOfferInfo?.isAutoApply == false) {
                if ((list?.first() as EMIOption).emiType == EmiType.CC)
                    return filterPaymentOption(it.emiOfferInfo?.emiCCOfferList, list)
                else if ((list.first() as? EMIOption)?.emiType == EmiType.DC)
                    return filterPaymentOption(it.emiOfferInfo?.emiDCOfferList, list)
            }
        }
        return list
    }

    internal fun handlePayUsingEMI(
        isOn: Boolean,
        list: ArrayList<PaymentOption>?,
        listener: OfferFilterListener
    ) {
        getPaymentStack().pop()
        if (isOn)
            handleOfferListForEMITenures(list, listener)
        else
            handleOfferListForSelectedPaymentMode(list, PaymentType.CARD, listener)
    }

    internal fun findCouponInCache(couponCode: String, fetchOfferDetails: FetchOfferDetails?): OfferInfo?{
        var couponFound: OfferInfo? = null
        if(couponMap.containsKey(couponCode))
            couponFound = couponMap[couponCode]
        if(couponFound == null)
            couponFound = fetchOfferDetails?.payuOfferArrayList?.firstOrNull { it.offerKey == couponCode }
        if(couponFound == null)
            couponFound = fetchOfferDetails?.payuRewardOfferArrayList?.firstOrNull { it.offerKey == couponCode }
        if(couponFound == null)
            couponFound = fetchOfferDetails?.payuSkuOfferList?.firstOrNull { it.offerKey == couponCode }
        return couponFound
    }

    internal fun addCouponToCache(couponCode: String, offer: OfferInfo?){
        couponMap[couponCode] = offer
    }

    fun clearCouponCache(){
        couponMap = HashMap()
    }

}

interface OfferFilterListener {
    fun offerDetails(fetchOfferDetails: FetchOfferDetails?)
    fun showChangeOfferView(
        shouldShowChangeOffer: Boolean,
        isAutoApply: Boolean = true,
        handleBackstack: Boolean = false
    )
}
