package com.payu.ui.model.managers

import android.content.Intent
import android.net.Uri
import android.os.CountDownTimer
import android.view.View
import android.widget.Button
import android.widget.TextView
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.listeners.EnachCallback
import com.payu.ui.model.utils.SdkUiConstants


class EnachDialogHandler(private val enachCallback: EnachCallback):BottomSheetManager(),
    View.OnClickListener {
    private var isAutoHandle:Boolean? = false
    private var btnOk:Button?=null
    private var timer:CountDownTimer?=null
    override fun init() {
        val message = SdkUiInitializer.apiLayer?.payUPaymentParams?.payUSIParams?.enachFeedbackHandlerMessage
        val title = SdkUiInitializer.apiLayer?.payUPaymentParams?.payUSIParams?.enachFeedbackHandlerTitle
        isAutoHandle = SdkUiInitializer.apiLayer?.payUPaymentParams?.payUSIParams?.enachEnableFeedbackHandler
        val tvMessage = view.findViewById<TextView>(R.id.tvMessage)
        val tvTitle = view.findViewById<TextView>(R.id.tvTitle)
        tvMessage?.text = message
        tvTitle?.text = title
        val tvCancel = view.findViewById<TextView>(R.id.tvCancel)
        val tvTimer = view.findViewById<TextView>(R.id.tvTimer)
        btnOk = view.findViewById(R.id.btnOk)
        tvCancel.setOnClickListener(this)
        btnOk?.setOnClickListener(this)
        startTimer(tvTimer)
    }

    private fun startTimer(tvTimer: TextView?) {
        timer = object :CountDownTimer(SdkUiConstants.ENACH_TIMER,1000){
            override fun onTick(millisUntilFinished: Long) {
                tvTimer?.text = String.format(view.context.getString(R.string.payu_redirection_timer),millisUntilFinished / 1000)
            }

            override fun onFinish() {
                onClick(btnOk)
            }
        }
        timer?.start()

    }


    override fun handleBottomSheetClose() {
        timer?.cancel()
        enachCallback.onCompleted()
    }

    override fun bottomSheetDetach() {

    }

    override fun bottomSheetAttach() {
    }

    override fun onClick(v: View?) {
        when(v?.id){
            R.id.tvCancel->{
                timer?.cancel()
                roundedCornerBottomSheet.dismiss()
                enachCallback.onCompleted()
            }
            R.id.btnOk->{
                timer?.cancel()
                if(isAutoHandle == true){
                    val url = SdkUiConstants.ENACH_FEEDBACK_URL
                    val i = Intent(Intent.ACTION_VIEW)
                    i.data = Uri.parse(url)
                    view.context.startActivity(i)
                }
                enachCallback.onCompleted()
            }
        }
    }
}