package com.payu.ui.model.adapters.viewholders

import android.view.View
import android.widget.TextView
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.payu.ui.R
import com.payu.ui.SdkUiInitializer
import com.payu.ui.model.adapters.HorizontalTilesAdapter
import com.payu.ui.model.models.AdapterViewSections

class TpvAccountListViewHolder(view: View) : RecyclerView.ViewHolder(view) {

    private var rvTpvOptions: RecyclerView? = view.findViewById(R.id.rvrecommendedoptions)
    private var tvTpvInfo: TextView = view.findViewById(R.id.tvTpvInfo)
    private var emptyTpvBTView: View = view.findViewById(R.id.emptyTpvBTView)

    fun bind(
        item: AdapterViewSections.TpvAccountView,
        showAccountInfo: Boolean = false,
        showTpvInfo: Boolean = false
    ) {
        if (showAccountInfo) {
            if (rvTpvOptions?.layoutManager == null)
                rvTpvOptions?.layoutManager =
                    LinearLayoutManager(itemView.context, LinearLayoutManager.HORIZONTAL, false)
            val adapter = HorizontalTilesAdapter(item.tilesDataList)
            rvTpvOptions?.adapter = adapter
            rvTpvOptions?.visibility = View.VISIBLE
            emptyTpvBTView.visibility = View.VISIBLE
        }
        if (showTpvInfo) {
            tvTpvInfo.visibility = View.VISIBLE
            tvTpvInfo.text = itemView.context.getString(
                R.string.payu_tpv_info_summary
            )
        }
    }
}